/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.outlook.memory.impl;

import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.outlook.memory.MemoryCRUD;
import com.openexchange.folderstorage.outlook.memory.MemoryFolder;
import com.openexchange.folderstorage.outlook.memory.MemoryTree;
import com.openexchange.folderstorage.outlook.memory.impl.MemoryCRUDImpl;
import com.openexchange.i18n.tools.StringHelper;
import gnu.trove.ConcurrentTIntHashSet;
import gnu.trove.set.TIntSet;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MemoryTreeImpl
implements MemoryTree {
    private final ConcurrentMap<String, MemoryFolder> folderMap;
    private final ConcurrentMap<String, Set<MemoryFolder>> parentMap;
    private final MemoryCRUD crud;
    private final int treeId;
    private static final TIntSet KNOWN_TREES = new ConcurrentTIntHashSet(new int[]{Tools.getUnsignedInteger(FolderStorage.REAL_TREE_ID), Tools.getUnsignedInteger("1")});

    public MemoryTreeImpl(int treeId) {
        this.treeId = treeId;
        this.folderMap = new ConcurrentHashMap<String, MemoryFolder>(128);
        this.parentMap = new ConcurrentHashMap<String, Set<MemoryFolder>>(128);
        this.crud = new MemoryCRUDImpl(this.folderMap, this.parentMap);
    }

    @Override
    public String getFolderName(String folderId) {
        MemoryFolder memoryFolder = (MemoryFolder)this.folderMap.get(folderId);
        return null == memoryFolder ? null : memoryFolder.getName();
    }

    @Override
    public boolean containsParent(String parentId) {
        return this.parentMap.containsKey(parentId);
    }

    @Override
    public boolean containsFolder(String folderId) {
        return this.folderMap.containsKey(folderId);
    }

    @Override
    public boolean[] containsFolders(String[] folderIds) {
        boolean[] ret = new boolean[folderIds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.folderMap.containsKey(folderIds[i]);
        }
        return ret;
    }

    @Override
    public boolean[] containsFolders(SortableId[] folderIds) {
        boolean[] ret = new boolean[folderIds.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.folderMap.containsKey(folderIds[i].getId());
        }
        return ret;
    }

    @Override
    public boolean hasSubfolderIds(String parentId) {
        Set set = (Set)this.parentMap.get(parentId);
        return null == set ? false : !set.isEmpty();
    }

    @Override
    public List<String[]> getSubfolderIds(String parentId) {
        Set set = (Set)this.parentMap.get(parentId);
        if (null == set) {
            return Collections.emptyList();
        }
        ArrayList<String[]> l = new ArrayList<String[]>(set.size());
        for (MemoryFolder subfolder : set) {
            l.add(new String[]{subfolder.getId(), subfolder.getName()});
        }
        return l;
    }

    @Override
    public List<String> getFolders() {
        return new ArrayList<String>(this.folderMap.keySet());
    }

    @Override
    public String[] getSubfolderIds(Locale locale, String parentId, List<String[]> realSubfolderIds) {
        ArrayList<String> subfolderIds;
        List<String[]> ids = this.getSubfolderIds(parentId);
        boolean knownTree = KNOWN_TREES.contains(this.treeId);
        if (knownTree) {
            if (FolderStorage.ROOT_ID.equals(parentId)) {
                Collections.sort(ids, PrivateSubfolderIDComparator.valueOf(locale));
                subfolderIds = new ArrayList<String>(ids.size());
                for (String[] fn : ids) {
                    subfolderIds.add(fn[0]);
                }
            } else {
                List<String> list;
                TreeMap<String, ArrayList<String>> treeMap = new TreeMap<String, ArrayList<String>>(FolderNameComparator.valueOf(locale));
                StringHelper stringHelper = StringHelper.valueOf(locale);
                for (String[] realSubfolderId : realSubfolderIds) {
                    String localizedName = stringHelper.getString(realSubfolderId[1]);
                    list = (ArrayList<String>)treeMap.get(localizedName);
                    if (null == list) {
                        list = new ArrayList<String>(2);
                        treeMap.put(localizedName, (ArrayList<String>)list);
                    }
                    list.add(realSubfolderId[0]);
                }
                for (String[] idAndName : ids) {
                    String name = idAndName[1];
                    list = (List)treeMap.get(name);
                    if (null == list) {
                        list = new ArrayList(2);
                        treeMap.put(name, (ArrayList<String>)list);
                    }
                    list.add(idAndName[0]);
                }
                subfolderIds = new ArrayList(treeMap.size());
                for (List list2 : treeMap.values()) {
                    for (String name : list2) {
                        subfolderIds.add(name);
                    }
                }
            }
        } else {
            Set set = (Set)this.parentMap.get(parentId);
            if (null == set || set.isEmpty()) {
                return new String[0];
            }
            ArrayList list = new ArrayList(set);
            Collections.sort(list, MemoryFolderComparator.valueOf(locale));
            subfolderIds = new ArrayList(list.size());
            for (MemoryFolder memoryFolder : list) {
                subfolderIds.add(memoryFolder.getId());
            }
        }
        return subfolderIds.toArray(new String[subfolderIds.size()]);
    }

    @Override
    public boolean fillFolder(Folder folder) {
        int modifiedBy;
        String folderId = folder.getID();
        MemoryFolder memoryFolder = (MemoryFolder)this.folderMap.get(folderId);
        if (null == memoryFolder) {
            return false;
        }
        folder.setParentID(memoryFolder.getParentId());
        String name = memoryFolder.getName();
        if (null != name) {
            folder.setName(name);
        }
        if ((modifiedBy = memoryFolder.getModifiedBy()) > 0) {
            folder.setModifiedBy(-1);
        } else {
            folder.setModifiedBy(modifiedBy);
        }
        Date date = memoryFolder.getLastModified();
        if (null != date) {
            folder.setLastModified(null);
        } else {
            folder.setLastModified(date);
        }
        Permission[] permissions = memoryFolder.getPermissions();
        if (null == permissions) {
            folder.setPermissions(null);
        } else {
            folder.setPermissions(permissions);
        }
        Boolean subscribed = memoryFolder.getSubscribed();
        if (null != subscribed) {
            folder.setSubscribed(subscribed);
        } else {
            folder.setSubscribed(true);
        }
        boolean subscribedSubfolder = false;
        Set set = (Set)this.parentMap.get(folderId);
        if (null != set) {
            for (MemoryFolder subfolder : set) {
                Boolean subscribed2 = subfolder.getSubscribed();
                if (null == subscribed2 || !subscribed2.booleanValue()) continue;
                subscribedSubfolder = true;
                break;
            }
        }
        if (subscribedSubfolder) {
            folder.setSubscribedSubfolders(true);
        }
        return true;
    }

    @Override
    public MemoryCRUD getCrud() {
        return this.crud;
    }

    @Override
    public int size() {
        return this.folderMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.folderMap.isEmpty();
    }

    @Override
    public void clear() {
        this.folderMap.clear();
    }

    public String toString() {
        return this.folderMap.toString();
    }

    private static final class PrivateSubfolderIDComparator
    implements Comparator<String[]> {
        private static final ConcurrentMap<Locale, PrivateSubfolderIDComparator> CACHE = new ConcurrentHashMap<Locale, PrivateSubfolderIDComparator>(16);
        private final Collator collator;

        protected static PrivateSubfolderIDComparator valueOf(Locale locale) {
            PrivateSubfolderIDComparator nucomp;
            if (null == locale) {
                return null;
            }
            PrivateSubfolderIDComparator comparator = (PrivateSubfolderIDComparator)CACHE.get(locale);
            if (null == comparator && null == (comparator = CACHE.putIfAbsent(locale, nucomp = new PrivateSubfolderIDComparator(locale)))) {
                comparator = nucomp;
            }
            return comparator;
        }

        private PrivateSubfolderIDComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String[] o1, String[] o2) {
            String privateId = "1";
            Integer privateComp = this.conditionalCompare("1".equals(o1[0]), "1".equals(o2[0]));
            if (null != privateComp) {
                return privateComp;
            }
            String publicId = "2";
            Integer publicComp = this.conditionalCompare("2".equals(o1[0]), "2".equals(o2[0]));
            if (null != publicComp) {
                return publicComp;
            }
            String sharedId = "3";
            Integer sharedComp = this.conditionalCompare("3".equals(o1[0]), "3".equals(o2[0]));
            if (null != sharedComp) {
                return sharedComp;
            }
            String uiName = "Unified Inbox";
            Integer unifiedInboxComp = this.conditionalCompare("Unified Inbox".equalsIgnoreCase(o1[1]), "Unified Inbox".equalsIgnoreCase(o2[1]));
            if (null != unifiedInboxComp) {
                return unifiedInboxComp;
            }
            return this.collator.compare(o1[1], o2[1]);
        }

        private Integer conditionalCompare(boolean b1, boolean b2) {
            if (b1) {
                if (!b2) {
                    return -1;
                }
                return 0;
            }
            if (b2) {
                return 1;
            }
            return null;
        }
    }

    private static final class MemoryFolderComparator
    implements Comparator<MemoryFolder> {
        private static final ConcurrentMap<Locale, MemoryFolderComparator> CACHE = new ConcurrentHashMap<Locale, MemoryFolderComparator>(16);
        private final Collator collator;
        private final StringHelper stringHelper;

        protected static MemoryFolderComparator valueOf(Locale locale) {
            MemoryFolderComparator nucomp;
            if (null == locale) {
                return null;
            }
            MemoryFolderComparator comparator = (MemoryFolderComparator)CACHE.get(locale);
            if (null == comparator && null == (comparator = CACHE.putIfAbsent(locale, nucomp = new MemoryFolderComparator(locale)))) {
                comparator = nucomp;
            }
            return comparator;
        }

        public MemoryFolderComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
            this.stringHelper = StringHelper.valueOf(locale);
        }

        @Override
        public int compare(MemoryFolder o1, MemoryFolder o2) {
            int sortNum2;
            int sortNum1 = o1.getSortNum();
            if (sortNum1 == (sortNum2 = o2.getSortNum())) {
                return this.collator.compare(this.stringHelper.getString(o1.getName()), this.stringHelper.getString(o2.getName()));
            }
            return sortNum1 - sortNum2;
        }
    }

    private static final class FolderNameComparator
    implements Comparator<String> {
        private static final ConcurrentMap<Locale, FolderNameComparator> CACHE = new ConcurrentHashMap<Locale, FolderNameComparator>(16);
        private final Collator collator;

        protected static FolderNameComparator valueOf(Locale locale) {
            FolderNameComparator nucomp;
            if (null == locale) {
                return null;
            }
            FolderNameComparator comparator = (FolderNameComparator)CACHE.get(locale);
            if (null == comparator && null == (comparator = CACHE.putIfAbsent(locale, nucomp = new FolderNameComparator(locale)))) {
                comparator = nucomp;
            }
            return comparator;
        }

        private FolderNameComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(String o1, String o2) {
            return this.collator.compare(o1, o2);
        }
    }
}

