/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.folderstorage.internal.performers.ListPerformer;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class MovePerformer
extends AbstractPerformer {
    private static final String MAIL_DEFAULT_ID = MailFolderUtility.prepareFullname(0, "default");
    private static final String MAIL = MailContentType.getInstance().toString();
    private final String realTreeId = FolderStorage.REAL_TREE_ID;

    MovePerformer(ServerSession session) {
        super(session);
    }

    MovePerformer(User user, Context context) {
        super(user, context);
    }

    MovePerformer(ServerSession session, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(session, folderStorageDiscoverer);
    }

    MovePerformer(User user, Context context, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, folderStorageDiscoverer);
    }

    void doMoveReal(Folder folder, FolderStorage folderStorage, FolderStorage realParentStorage, FolderStorage newRealParentStorage) throws OXException {
        folderStorage.updateFolder(folder, this.storageParameters);
    }

    void doMoveVirtual(Folder folder, FolderStorage virtualStorage, FolderStorage realParentStorage, FolderStorage newRealParentStorage, Folder storageFolder, List<FolderStorage> openedStorages) throws OXException {
        List<ContentType> contentTypes;
        String rootId;
        Folder rootFolder;
        Permission rootPermission;
        Permission permission = this.effectivePermission(storageFolder);
        if (!permission.isAdmin()) {
            throw FolderExceptionErrorMessage.FOLDER_NOT_MOVEABLE.create(this.getFolderInfo4Error(storageFolder), this.getUserInfo4Error(), this.getContextInfo4Error());
        }
        FolderStorage realStorage = this.folderStorageDiscoverer.getFolderStorage(this.realTreeId, folder.getID());
        if (null == realStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(this.realTreeId, folder.getID());
        }
        this.checkOpenedStorage(realStorage, openedStorages);
        boolean flag = true;
        if (FolderStorage.PRIVATE_ID.equals(folder.getParentID()) && MAIL.equals(((Object)storageFolder.getContentType()).toString()) && (rootPermission = CalculatePermission.calculate(rootFolder = realStorage.getFolder(this.realTreeId, rootId = MAIL_DEFAULT_ID, this.storageParameters), this, contentTypes = Collections.emptyList())).getFolderPermission() >= 8) {
            Folder clone4Real = (Folder)folder.clone();
            clone4Real.setParentID(rootId);
            clone4Real.setTreeID(this.realTreeId);
            realStorage.updateFolder(clone4Real, this.storageParameters);
            virtualStorage.deleteFolder(folder.getTreeID(), folder.getID(), this.storageParameters);
            folder.setID(clone4Real.getID());
            boolean started = realStorage.startTransaction(this.storageParameters, true);
            try {
                realStorage.updateLastModified(System.currentTimeMillis(), this.realTreeId, folder.getParentID(), this.storageParameters);
                if (started) {
                    realStorage.commitTransaction(this.storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    realStorage.rollback(this.storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    realStorage.rollback(this.storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            flag = false;
        }
        if (!flag) {
            return;
        }
        Folder destFolder = virtualStorage.getFolder(folder.getTreeID(), folder.getParentID(), this.storageParameters);
        Permission permission2 = this.effectivePermission(destFolder);
        if (permission2.getFolderPermission() < 8) {
            throw FolderExceptionErrorMessage.NO_CREATE_SUBFOLDERS.create(this.getUserInfo4Error(), this.getFolderInfo4Error(destFolder), this.getContextInfo4Error());
        }
        String oldParent = storageFolder.getParentID();
        if (virtualStorage.equals(realStorage)) {
            virtualStorage.updateFolder(folder, this.storageParameters);
        } else {
            String treeId = folder.getTreeID();
            boolean destEquality = realStorage.equals(newRealParentStorage);
            boolean parentEquality = newRealParentStorage.equals(realParentStorage);
            if (destEquality) {
                FolderInfo oldFolderInfo = new FolderInfo(folder.getID(), storageFolder.getName());
                this.gatherSubfolders(treeId, oldFolderInfo, this.storageParameters, virtualStorage, true);
                if (MovePerformer.containsAny(folder.getTreeID(), oldFolderInfo, virtualStorage, this.storageParameters)) {
                    virtualStorage.updateFolder(folder, this.storageParameters);
                    String oldId = folder.getID();
                    this.checkOpenedStorage(realStorage, openedStorages);
                    realStorage.updateFolder(folder, this.storageParameters);
                    String newId = folder.getID();
                    if (!parentEquality) {
                        virtualStorage.deleteFolder(treeId, oldId, this.storageParameters);
                    }
                    FolderInfo newFolderInfo = new FolderInfo(newId, folder.getName());
                    this.gatherSubfolders(treeId, newFolderInfo, this.storageParameters, realStorage, false);
                    Map<String, String> parentIDMap = MovePerformer.generateParentIDMap(oldFolderInfo, newFolderInfo);
                    Map<String, String> idMap = MovePerformer.generateIDMap(oldFolderInfo, newFolderInfo);
                    for (Map.Entry<String, String> entry : parentIDMap.entrySet()) {
                        UpdateFolder up = new UpdateFolder();
                        String id = entry.getKey();
                        up.setID(id);
                        up.setParentID(entry.getValue());
                        up.setTreeID(treeId);
                        String newIdent = idMap.get(id);
                        if (null != newIdent) {
                            up.setNewID(newIdent);
                        }
                        virtualStorage.updateFolder(up, this.storageParameters);
                    }
                } else {
                    realStorage.updateFolder(folder, this.storageParameters);
                }
                return;
            }
            boolean parentChildEquality = realStorage.equals(realParentStorage);
            if (parentChildEquality && parentEquality) {
                this.checkOpenedStorage(realStorage, openedStorages);
                Folder clone4Real = (Folder)folder.clone();
                clone4Real.setName(this.nonExistingName(clone4Real.getName(), this.realTreeId, clone4Real.getParentID(), openedStorages));
                realStorage.updateFolder(clone4Real, this.storageParameters);
                virtualStorage.updateFolder(folder, this.storageParameters);
                Date lastModified = clone4Real.getLastModified();
                virtualStorage.updateLastModified(lastModified.getTime(), treeId, folder.getParentID(), this.storageParameters);
                virtualStorage.updateLastModified(lastModified.getTime(), treeId, oldParent, this.storageParameters);
            } else if (!parentChildEquality && parentEquality) {
                virtualStorage.updateFolder(folder, this.storageParameters);
            } else if (parentChildEquality && !parentEquality) {
                this.checkOpenedStorage(realStorage, openedStorages);
                String defaultParentId = virtualStorage.getDefaultFolderID(this.user, treeId, realStorage.getDefaultContentType(), virtualStorage.getTypeByParent(this.user, treeId, folder.getParentID(), this.storageParameters), this.storageParameters);
                if (null == defaultParentId) {
                    throw FolderExceptionErrorMessage.NO_DEFAULT_FOLDER.create(realStorage.getDefaultContentType(), this.realTreeId);
                }
                String realParentID = realStorage.getFolder(this.realTreeId, folder.getID(), this.storageParameters).getParentID();
                if (!defaultParentId.equals(realParentID)) {
                    Folder clone4Real = (Folder)folder.clone();
                    clone4Real.setParentID(defaultParentId);
                    clone4Real.setName(this.nonExistingName(clone4Real.getName(), this.realTreeId, defaultParentId, openedStorages));
                    realStorage.updateFolder(clone4Real, this.storageParameters);
                    String newId = clone4Real.getID();
                    if (null != newId) {
                        folder.setID(newId);
                    }
                }
                virtualStorage.createFolder(folder, this.storageParameters);
            } else {
                throw FolderExceptionErrorMessage.MOVE_NOT_PERMITTED.create(new Object[0]);
            }
        }
    }

    private void gatherSubfolders(String treeId, FolderInfo folder, StorageParameters params, FolderStorage storage, boolean check) throws OXException {
        SortableId[] subfolders = storage.getSubfolders(treeId, folder.id, params);
        if (0 == subfolders.length) {
            return;
        }
        for (SortableId id : subfolders) {
            FolderInfo subfolder;
            String subfolderId = id.getId();
            if (check) {
                Folder f = storage.getFolder(treeId, subfolderId, params);
                Permission permission = this.effectivePermission(f);
                if (!permission.isAdmin()) {
                    throw FolderExceptionErrorMessage.FOLDER_NOT_MOVEABLE.create(this.getFolderInfo4Error(f), this.getUserInfo4Error(), this.getContextInfo4Error());
                }
                subfolder = new FolderInfo(subfolderId, f.getName());
            } else {
                subfolder = new FolderInfo(subfolderId, storage.getFolder(treeId, subfolderId, params).getName());
            }
            folder.addSubfolder(subfolder);
            this.gatherSubfolders(treeId, subfolder, params, storage, check);
        }
    }

    private Permission effectivePermission(Folder f) throws OXException {
        return CalculatePermission.calculate(f, this, (List<ContentType>)ALL_ALLOWED);
    }

    private static boolean containsAny(String treeId, FolderInfo folderInfo, FolderStorage folderStorage, StorageParameters storageParameters) throws OXException {
        if (folderStorage.containsFolder(treeId, folderInfo.id, storageParameters)) {
            return true;
        }
        for (FolderInfo subfolder : folderInfo.subfolders) {
            if (!MovePerformer.containsAny(treeId, subfolder, folderStorage, storageParameters)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> generateIDMap(FolderInfo oldFolder, FolderInfo newFolder) {
        HashMap<String, String> map = new HashMap<String, String>();
        MovePerformer.fillIDMap(oldFolder, newFolder, map);
        return map;
    }

    private static void fillIDMap(FolderInfo oldFolder, FolderInfo newFolder, Map<String, String> map) {
        map.put(oldFolder.id, newFolder.id);
        for (FolderInfo oldSubfolder : oldFolder.subfolders) {
            FolderInfo newSubfolder = newFolder.getByName(oldSubfolder.name);
            if (null == newSubfolder) continue;
            MovePerformer.fillIDMap(oldSubfolder, newSubfolder, map);
        }
    }

    private static Map<String, String> generateParentIDMap(FolderInfo oldFolder, FolderInfo newFolder) {
        HashMap<String, String> map = new HashMap<String, String>();
        MovePerformer.fillParentIDMap(oldFolder, newFolder, map);
        return map;
    }

    private static void fillParentIDMap(FolderInfo oldFolder, FolderInfo newFolder, Map<String, String> map) {
        for (FolderInfo oldSubfolder : oldFolder.subfolders) {
            map.put(oldSubfolder.id, newFolder.id);
            FolderInfo newSubfolder = newFolder.getByName(oldSubfolder.name);
            if (null == newSubfolder) continue;
            MovePerformer.fillParentIDMap(oldSubfolder, newSubfolder, map);
        }
    }

    private void checkOpenedStorage(FolderStorage storage, List<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage openedStorage : openedStorages) {
            if (!openedStorage.equals(storage)) continue;
            return;
        }
        if (storage.startTransaction(this.storageParameters, true)) {
            openedStorages.add(storage);
        }
    }

    private boolean equallyNamedSibling(String name, String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        UserizedFolder[] subfolders;
        ListPerformer listPerformer = null == this.session ? new ListPerformer(this.user, this.context, null) : new ListPerformer(this.session, null);
        listPerformer.setStorageParameters(this.storageParameters);
        for (UserizedFolder userizedFolder : subfolders = listPerformer.doList(treeId, parentId, true, openedStorages, false)) {
            if (!name.equals(userizedFolder.getName())) continue;
            return true;
        }
        return false;
    }

    private String nonExistingName(String name, String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        ListPerformer listPerformer = null == this.session ? new ListPerformer(this.user, this.context, null) : new ListPerformer(this.session, null);
        listPerformer.setStorageParameters(this.storageParameters);
        UserizedFolder[] subfolders = listPerformer.doList(treeId, parentId, true, openedStorages, false);
        StringBuilder sb = new StringBuilder();
        String nonExistingName = name;
        int i = 0;
        int count = 0;
        while (i < subfolders.length) {
            if (nonExistingName.equals(subfolders[i].getName())) {
                sb.setLength(0);
                sb.append(name).append('_').append(String.valueOf(++count));
                nonExistingName = sb.toString();
                i = 0;
                continue;
            }
            ++i;
        }
        return nonExistingName;
    }

    private static final class UpdateFolder
    extends AbstractFolder {
        private static final long serialVersionUID = -6666991788068206301L;

        @Override
        public boolean isGlobalID() {
            return false;
        }

        @Override
        public boolean isCacheable() {
            return false;
        }
    }

    private static final class FolderInfo {
        final String id;
        final String name;
        final List<FolderInfo> subfolders;
        final Map<String, FolderInfo> subfoldersMap;

        public FolderInfo(String id, String name) {
            this.id = id;
            this.name = name;
            this.subfolders = new ArrayList<FolderInfo>();
            this.subfoldersMap = new HashMap<String, FolderInfo>();
        }

        public void addSubfolder(FolderInfo subfolder) {
            this.subfolders.add(subfolder);
            this.subfoldersMap.put(subfolder.name, subfolder);
        }

        public FolderInfo getByName(String name) {
            return this.subfoldersMap.get(name);
        }

        public String toString() {
            return "{id=" + this.id + ", name=" + this.name + ", subfolders=" + this.subfolders.toString() + '}';
        }
    }
}

