/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.filestorage;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.java.Strings;
import com.openexchange.tools.id.IDMangler;
import java.util.List;

public final class FileStorageFolderIdentifier {
    private static final String DELIM = "://";
    private final String serviceId;
    private final String accountId;
    private final String folderId;
    private final int hash;
    private final String fqn;

    public static String getFQN(String serviceId, String accountId, String folderId) {
        if (serviceId == null && accountId == null) {
            return folderId;
        }
        if (serviceId == null) {
            throw new NullPointerException("In plugin supplied folder IDs, the service may not be null");
        }
        if (accountId == null) {
            throw new NullPointerException("In plugin supplied folder IDs, the acccountId should not be null");
        }
        if (folderId == null) {
            folderId = "";
        }
        return IDMangler.mangle((String[])new String[]{serviceId, accountId, folderId});
    }

    public static boolean isFQN(String identifier) {
        if (null == identifier) {
            return false;
        }
        int pos = identifier.indexOf(DELIM);
        if (pos <= 0) {
            return false;
        }
        int prev = pos + DELIM.length();
        if ((pos = identifier.indexOf(47, prev)) <= 0) {
            return identifier.substring(prev).length() != 0;
        }
        return identifier.substring(prev, pos).length() != 0;
    }

    public static FileStorageFolderIdentifier parseFQN(String identifier) {
        try {
            return new FileStorageFolderIdentifier(identifier);
        }
        catch (OXException e) {
            return null;
        }
    }

    public FileStorageFolderIdentifier(String identifier) throws OXException {
        if (null == identifier) {
            throw FolderExceptionErrorMessage.MISSING_FOLDER_ID.create();
        }
        List components = IDMangler.unmangle((String)identifier);
        if (components.isEmpty()) {
            throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(identifier);
        }
        int size = components.size();
        if (size == 1) {
            throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(identifier);
        }
        this.serviceId = (String)components.get(0);
        if (size == 2) {
            this.accountId = (String)components.get(1);
            if (FileStorageFolderIdentifier.isEmpty(this.accountId)) {
                throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(identifier);
            }
            this.folderId = "";
            this.fqn = IDMangler.mangle((String[])new String[]{this.serviceId, this.accountId, this.folderId});
        } else {
            this.accountId = (String)components.get(1);
            if (FileStorageFolderIdentifier.isEmpty(this.accountId)) {
                throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(identifier);
            }
            this.folderId = (String)components.get(2);
            this.fqn = identifier;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountId == null ? 0 : this.accountId.hashCode());
        result = 31 * result + (this.folderId == null ? 0 : this.folderId.hashCode());
        this.hash = result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
    }

    public FileStorageFolderIdentifier(String serviceId, String accountId, String folderId) {
        this.serviceId = serviceId;
        this.accountId = accountId;
        this.folderId = folderId;
        this.fqn = IDMangler.mangle((String[])new String[]{serviceId, accountId, folderId});
        int prime = 31;
        int result = 1;
        result = 31 * result + (accountId == null ? 0 : accountId.hashCode());
        result = 31 * result + (folderId == null ? 0 : folderId.hashCode());
        this.hash = result = 31 * result + (serviceId == null ? 0 : serviceId.hashCode());
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public String toString() {
        return this.fqn;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileStorageFolderIdentifier)) {
            return false;
        }
        FileStorageFolderIdentifier other = (FileStorageFolderIdentifier)obj;
        if (this.accountId == null ? other.accountId != null : !this.accountId.equals(other.accountId)) {
            return false;
        }
        if (this.folderId == null ? other.folderId != null : !this.folderId.equals(other.folderId)) {
            return false;
        }
        return !(this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId));
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

