/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.internal;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.image.ImageDataSource;
import com.openexchange.image.ImageLocation;
import com.openexchange.image.ImageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public final class ManagedFileImageDataSource
implements ImageDataSource {
    private static final String REG_NAME = "com.openexchange.image.managedFile";
    private static final String ARG = "com.openexchange.image.managedFile.id";
    private static final String ALIAS = "/mfile/picture";

    public <D> Data<D> getData(Class<? extends D> type, DataArguments dataArguments, Session session) throws OXException {
        try {
            ManagedFileManagement fileManagement = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class, true);
            ManagedFile managedFile = fileManagement.getByID(dataArguments.get(ARG));
            DataProperties properties = new DataProperties();
            properties.put("com.openexchange.conversion.content-type", managedFile.getContentType());
            properties.put("com.openexchange.conversion.charset", "UTF-8");
            properties.put("com.openexchange.conversion.size", Long.toString(managedFile.getSize()));
            properties.put("com.openexchange.conversion.name", managedFile.getFileName());
            return new SimpleData((Object)new FileInputStream(managedFile.getFile()), properties);
        }
        catch (FileNotFoundException e) {
            throw DataExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    public String[] getRequiredArguments() {
        return new String[]{ARG};
    }

    public Class<?>[] getTypes() {
        return new Class[]{InputStream.class};
    }

    @Override
    public String getRegistrationName() {
        return REG_NAME;
    }

    @Override
    public DataArguments generateDataArgumentsFrom(ImageLocation imageLocation) {
        DataArguments dataArguments = new DataArguments(1);
        dataArguments.put(ARG, imageLocation.getImageId());
        return dataArguments;
    }

    @Override
    public String generateUrl(ImageLocation imageLocation, Session session) throws OXException {
        StringBuilder sb = new StringBuilder(64);
        ImageUtility.startImageUrl(imageLocation, session, this, true, sb);
        return sb.toString();
    }

    @Override
    public ImageLocation parseUrl(String url) {
        return ImageUtility.parseImageLocationFrom(url);
    }

    @Override
    public ImageLocation parseRequest(AJAXRequestData requestData) {
        return ImageUtility.parseImageLocationFrom(requestData);
    }

    @Override
    public long getExpires() {
        return -1L;
    }

    @Override
    public String getETag(ImageLocation imageLocation, Session session) throws OXException {
        return imageLocation.getImageId();
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }
}

