/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.provider;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import java.sql.Connection;

public class ReuseReadConProvider
implements DBProvider {
    private final DBProvider provider;
    private Connection readCon;
    private int refCount;

    public ReuseReadConProvider(DBProvider provider) {
        this.provider = provider;
    }

    @Override
    public Connection getReadConnection(Context ctx) throws OXException {
        if (this.readCon != null) {
            ++this.refCount;
            return this.readCon;
        }
        this.readCon = this.provider.getReadConnection(ctx);
        ++this.refCount;
        return this.readCon;
    }

    @Override
    public Connection getWriteConnection(Context ctx) throws OXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseReadConnection(Context ctx, Connection con) {
        if (con == null) {
            return;
        }
        if (!this.readCon.equals(con)) {
            throw new IllegalArgumentException("I don't know this connection");
        }
        --this.refCount;
        if (this.refCount == 0) {
            this.provider.releaseReadConnection(ctx, con);
            this.readCon = null;
        }
    }

    @Override
    public void releaseWriteConnection(Context ctx, Connection con) {
        throw new UnsupportedOperationException();
    }
}

