/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.api2;

import com.openexchange.ajax.parser.ContactSearchtermSqlConverter;
import com.openexchange.api2.ContactSQLInterface;
import com.openexchange.contact.LdapServer;
import com.openexchange.database.provider.SimpleDBProvider;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.contact.ContactConfig;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.ContactMySql;
import com.openexchange.groupware.contact.ContactSql;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.contact.Search;
import com.openexchange.groupware.contact.helpers.CollationContactComparator;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.contact.helpers.ContactSetter;
import com.openexchange.groupware.contact.helpers.ContactSwitcherForTimestamp;
import com.openexchange.groupware.contact.helpers.SpecialAlphanumSortContactComparator;
import com.openexchange.groupware.contact.helpers.UseCountComparator;
import com.openexchange.groupware.contact.sqlinjectors.SQLInjector;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tools.iterator.PrefetchIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.StringAllocator;
import com.openexchange.l10n.SuperCollator;
import com.openexchange.log.LogFactory;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.search.SearchTerm;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;

public class RdbContactSQLImpl
implements ContactSQLInterface {
    private final int userId;
    private final int[] memberInGroups;
    private final Context ctx;
    private final Session session;
    private final UserConfiguration userConfiguration;
    private Locale locale;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(RdbContactSQLImpl.class));

    public RdbContactSQLImpl(Session session) throws OXException {
        this.ctx = ContextStorage.getStorageContext(session);
        this.userId = session.getUserId();
        this.memberInGroups = UserStorage.getStorageUser(session.getUserId(), this.ctx).getGroups();
        this.session = session;
        this.userConfiguration = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), this.ctx);
    }

    public RdbContactSQLImpl(Session session, Context ctx) {
        this.ctx = ctx;
        this.userId = session.getUserId();
        this.memberInGroups = UserStorage.getStorageUser(session.getUserId(), ctx).getGroups();
        this.session = session;
        this.userConfiguration = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), ctx);
    }

    private Locale getLocale() {
        if (null == this.locale) {
            this.locale = this.session instanceof ServerSession ? ((ServerSession)this.session).getUser().getLocale() : UserStorage.getStorageUser(this.session.getUserId(), this.ctx).getLocale();
        }
        return this.locale;
    }

    @Override
    public void insertContactObject(Contact co) throws OXException {
        this.insertContactObject(co, false);
    }

    protected void insertContactObject(Contact co, boolean override) throws OXException {
        Contacts.performContactStorageInsert(co, this.userId, this.session, override);
        EventClient ec = new EventClient(this.session);
        ec.create(co);
    }

    @Override
    public void updateContactObject(Contact co, int fid, Date d) throws OXException {
        Contact storageVersion = Contacts.getContactById(co.getObjectID(), this.session);
        Contacts.performContactStorageUpdate(co, fid, d, this.userId, this.memberInGroups, this.ctx, this.userConfiguration);
        EventClient ec = new EventClient(this.session);
        ec.modify(storageVersion, co, new OXFolderAccess(this.ctx).getFolderObject(co.getParentFolderID()));
    }

    @Override
    public void updateUserContact(Contact contact, Date lastModified) throws OXException {
        Contact storageVersion = Contacts.getContactById(contact.getObjectID(), this.session);
        Contacts.performUserContactStorageUpdate(contact, lastModified, this.userId, this.memberInGroups, this.ctx, this.userConfiguration);
        EventClient ec = new EventClient(this.session);
        ec.modify(storageVersion, contact, new OXFolderAccess(this.ctx).getFolderObject(contact.getParentFolderID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfContacts(int folderId) throws OXException {
        Connection readCon;
        try {
            readCon = DBPool.pickup(this.ctx);
        }
        catch (OXException e) {
            throw ContactExceptionCodes.INIT_CONNECTION_FROM_DBPOOL.create(e, new Object[0]);
        }
        try {
            FolderObject contactFolder = new OXFolderAccess(readCon, this.ctx).getFolderObject(folderId);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            ContactMySql contactSQL = new ContactMySql(this.session, this.ctx);
            EffectivePermission oclPerm = new OXFolderAccess(readCon, this.ctx).getFolderPermission(folderId, this.userId, this.userConfiguration);
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            if (!oclPerm.canReadAllObjects()) {
                if (oclPerm.canReadOwnObjects()) {
                    contactSQL.setReadOnlyOwnFolder(this.userId);
                } else {
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
                }
            }
            contactSQL.setSelect(contactSQL.iFgetNumberOfContactsString());
            contactSQL.setFolder(folderId);
            int retval = 0;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = contactSQL.getSqlStatement(readCon);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    retval = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                try {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            int n = retval;
            return n;
        }
        finally {
            DBPool.closeReaderSilent(this.ctx, readCon);
        }
    }

    @Override
    public SearchIterator<Contact> getContactsInFolder(int folderId, int from, int to, int order_field, Order orderMechanism, String collation2, int[] cols) throws OXException {
        Object[] contacts2;
        int[] extendedCols = this.checkColumns(cols);
        ContactMySql cs = new ContactMySql(this.session, this.ctx);
        cs.setFolder(folderId);
        OXFolderAccess folderAccess = new OXFolderAccess(this.ctx);
        FolderObject contactFolder = folderAccess.getFolderObject(folderId);
        if (contactFolder.getModule() != 3) {
            throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
        }
        EffectivePermission oclPerm = folderAccess.getFolderPermission(folderId, this.userId, this.userConfiguration);
        if (oclPerm.getFolderPermission() <= 0) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
        }
        if (!oclPerm.canReadAllObjects()) {
            if (oclPerm.canReadOwnObjects()) {
                cs.setReadOnlyOwnFolder(this.userId);
            } else {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
        }
        SuperCollator collation = SuperCollator.get((String)collation2);
        StringBuilder order = new StringBuilder();
        if (order_field > 0 && order_field != 609 && order_field != 607 && !Order.NO_ORDER.equals((Object)orderMechanism)) {
            String orderSQL = this.generateOrder(order_field, orderMechanism, collation);
            if (null != orderSQL) {
                order.append(orderSQL);
            }
        } else {
            extendedCols = Arrays.addUniquely((int[])extendedCols, (int[])new int[]{611, 502, 610, 501, 500, 612, 569, 555, 556, 608});
        }
        if (from != 0 || to != 0) {
            order.append(" LIMIT ");
            order.append(from);
            order.append(',');
            order.append(to - from);
        }
        cs.setOrder(order.toString());
        cs.setSelect(cs.iFgetColsString(extendedCols).toString());
        Connection con = DBPool.pickup(this.ctx);
        ResultSet result = null;
        PreparedStatement stmt = null;
        try {
            stmt = cs.getSqlStatement(con);
            result = stmt.executeQuery();
            ArrayList<Contact> tmp = new ArrayList<Contact>();
            while (result.next()) {
                Contact contact = this.convertResultSet2ContactObject(result, extendedCols, false, con);
                tmp.add(contact);
            }
            contacts2 = tmp.toArray(new Contact[tmp.size()]);
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(this.ctx, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(this.ctx, con);
        if (order_field == 609) {
            java.util.Arrays.sort(contacts2, new UseCountComparator(false, this.getLocale()));
        } else if (collation == null) {
            java.util.Arrays.sort(contacts2, new SpecialAlphanumSortContactComparator(this.getLocale()));
        }
        return new ArrayIterator(contacts2);
    }

    @Override
    public <T> SearchIterator<Contact> getContactsByExtendedSearch(SearchTerm<T> searchterm, int order_field, Order order, String collation, int[] cols) throws OXException, OXException {
        Object[] contacts2;
        ArrayList<Contact> tmp;
        PreparedStatement stmt;
        ResultSet result;
        Connection con;
        boolean specialSort;
        block17: {
            ContactMySql cs = new ContactMySql(this.session, this.ctx);
            ContactSearchtermSqlConverter conv = new ContactSearchtermSqlConverter();
            conv.setCharset(collation);
            conv.parse(searchterm);
            int[] extendedCols = cols;
            if (order_field <= 0 || order_field == 607 || order_field == 609 || Order.NO_ORDER.equals((Object)order)) {
                extendedCols = Arrays.addUniquely((int[])extendedCols, (int[])new int[]{611, 502, 610, 501, 500, 612, 569, 555, 556, 608});
                specialSort = true;
            } else {
                specialSort = false;
            }
            String select = this.generateSelect(extendedCols);
            String whereFolder = this.checkFolderRights(conv, cs);
            String whereConditions = conv.getPreparedWhereString();
            String sqlOrder = specialSort ? null : this.generateOrder(order_field, order, SuperCollator.get((String)collation));
            StringBuilder query = new StringBuilder(select);
            query.append("WHERE (co.cid=").append(this.ctx.getContextId()).append(") ");
            if (whereConditions != null && whereConditions.length() > 0) {
                query.append(" AND ").append(whereConditions);
            }
            if (whereFolder != null && !conv.hasFolders()) {
                query.append(" AND ").append(whereFolder).append(' ');
            }
            if (null != sqlOrder) {
                query.append(sqlOrder).append(' ');
            }
            String queryStr = query.toString();
            con = DBPool.pickup(this.ctx);
            result = null;
            stmt = null;
            stmt = con.prepareStatement(queryStr);
            List<SQLInjector> injectors = conv.getInjectors();
            for (int i = 0; i < injectors.size(); ++i) {
                injectors.get(i).inject(stmt, i + 1);
            }
            result = stmt.executeQuery();
            tmp = new ArrayList<Contact>();
            while (result.next()) {
                Contact contact = this.convertResultSet2ContactObject(result, extendedCols, false, con);
                tmp.add(contact);
            }
            if (!tmp.isEmpty()) break block17;
            SearchIterator searchIterator = SearchIteratorAdapter.emptyIterator();
            DBUtils.closeSQLStuff(result, stmt);
            DBPool.closeReaderSilent(this.ctx, con);
            return searchIterator;
        }
        try {
            if (null != collation) {
                this.sortByCollation(tmp, order_field, order, collation);
            } else if (order_field == 609) {
                Collections.sort(tmp, new UseCountComparator(specialSort, this.getLocale()));
            } else if (specialSort) {
                Collections.sort(tmp, new SpecialAlphanumSortContactComparator(this.getLocale()));
            }
            contacts2 = tmp.toArray(new Contact[tmp.size()]);
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(this.ctx, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(this.ctx, con);
        return new ArrayIterator(contacts2);
    }

    private void sortByCollation(List<Contact> tmp, int orderField, Order order, String collation) {
        if (collation == null) {
            return;
        }
        ContactField field = ContactField.getByValue(orderField);
        SuperCollator mapping = SuperCollator.get((String)collation);
        if (field == null) {
            LOG.error((Object)("Sorting of requested contacts failed, because field #" + orderField + " could not be mapped to a contact field"));
            return;
        }
        if (mapping == null) {
            LOG.error((Object)("Sorting of requested contacts failed, because no collation could be founf for " + orderField));
            return;
        }
        CollationContactComparator comparator = new CollationContactComparator(field, order, mapping.getJavaLocale());
        Collections.sort(tmp, comparator);
    }

    private String generateSelect(int[] cols) {
        StringBuilder fieldsBuilder = new StringBuilder();
        for (int a = 0; a < cols.length; ++a) {
            Contacts.Mapper m = Contacts.mapping[cols[a]];
            if (m == null) continue;
            fieldsBuilder.append("co.").append(m.getDBFieldName()).append(',');
        }
        int len = fieldsBuilder.length();
        if (len > 0) {
            fieldsBuilder.deleteCharAt(len - 1);
        }
        String fields = fieldsBuilder.toString();
        len = fields.length();
        StringAllocator sb = new StringAllocator(len + 256).append("SELECT ");
        sb.append("co.fid,co.cid,co.created_from,co.creating_date,co.changed_from,co.changing_date,co.intfield01");
        if (len > 0) {
            sb.append(',').append(fields);
        }
        sb.append(" FROM prg_contacts AS co ");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchIterator<Contact> getContactsByExtendedSearch(ContactSearchObject searchobject, int order_field, Order order, String collation, int[] cols) throws OXException, OXException {
        ArrayList<Contact> contacts2;
        boolean specialSort;
        block33: {
            int[] extendedCols = cols;
            OXFolderAccess oxfs = new OXFolderAccess(this.ctx);
            ContactMySql cs = new ContactMySql(this.session, this.ctx);
            boolean considerUsersAliases = false;
            if (searchobject.isEmailAutoComplete()) {
                boolean allFolders = Autoboxing.b((Boolean)ContactConfig.getInstance().getBoolean(ContactConfig.Property.ALL_FOLDERS_FOR_AUTOCOMPLETE));
                if (!searchobject.hasFolders() && !allFolders) {
                    searchobject.addFolder(oxfs.getDefaultFolder(this.userId, 3).getObjectID());
                    try {
                        Integer contactCollectFolder = ServerUserSetting.getInstance().getContactCollectionFolder(this.ctx.getContextId(), this.userId);
                        if (null != contactCollectFolder && oxfs.exists(contactCollectFolder)) {
                            searchobject.addFolder(contactCollectFolder);
                        }
                    }
                    catch (OXException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    EffectivePermission oclPerm = oxfs.getFolderPermission(6, this.userId, this.userConfiguration);
                    if (oclPerm.isFolderVisible() && oclPerm.canReadAllObjects()) {
                        searchobject.addFolder(6);
                        considerUsersAliases = true;
                    }
                }
            }
            if (searchobject.hasFolders()) {
                int[] folders2 = searchobject.getFolders();
                OXFolderAccess folderAccess = new OXFolderAccess(this.ctx);
                for (int folderId : folders2) {
                    FolderObject contactFolder = folderAccess.getFolderObject(folderId);
                    if (contactFolder.getModule() != 3) {
                        throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
                    }
                    EffectivePermission oclPerm = oxfs.getFolderPermission(folderId, this.userId, this.userConfiguration);
                    if (oclPerm.getFolderPermission() <= 0) {
                        throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
                    }
                    if (oclPerm.canReadOwnObjects()) continue;
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
                }
                searchobject.setAllFolderSQLINString(cs.buildFolderSearch(this.userId, this.memberInGroups, folders2, this.session));
            } else {
                searchobject.setAllFolderSQLINString(cs.buildAllFolderSearchString(this.userId, this.memberInGroups, this.session).toString());
            }
            Search.checkPatternLength(searchobject);
            StringBuilder sqlOrder = new StringBuilder();
            if (order_field > 0 && order_field != 607 && order_field != 609 && !Order.NO_ORDER.equals((Object)order)) {
                String realOrderMechanism;
                specialSort = false;
                sqlOrder.append(" ORDER BY co.");
                int realOrderField = order_field == 609 ? 608 : order_field;
                sqlOrder.append(Contacts.mapping[realOrderField].getDBFieldName());
                sqlOrder.append(' ');
                String string = realOrderMechanism = order_field == 609 ? "DESC" : DBUtils.forSQLCommand(order);
                if (realOrderMechanism != null && realOrderMechanism.length() > 0) {
                    sqlOrder.append(realOrderMechanism);
                } else {
                    sqlOrder.append("ASC");
                }
                sqlOrder.append(' ');
            } else {
                extendedCols = Arrays.addUniquely((int[])extendedCols, (int[])new int[]{611, 502, 610, 501, 500, 612, 569, 555, 556, 608});
                specialSort = true;
            }
            cs.setOrder(sqlOrder.toString());
            cs.setContactSearchObject(searchobject);
            cs.setSelect(cs.iFgetColsString(extendedCols).toString());
            Connection con = DBPool.pickup(this.ctx);
            contacts2 = new ArrayList<Contact>(32);
            try {
                String email1;
                HashSet<String> foundAddresses = new HashSet<String>();
                ResultSet result = null;
                PreparedStatement stmt = null;
                try {
                    stmt = cs.getSqlStatement(con);
                    result = stmt.executeQuery();
                    while (result.next()) {
                        Contact contact = this.convertResultSet2ContactObject(result, extendedCols, false, con);
                        contacts2.add(contact);
                        foundAddresses.add(contact.getEmail1());
                    }
                }
                catch (SQLException e) {
                    try {
                        throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        DBUtils.closeSQLStuff(result, stmt);
                        result = null;
                        stmt = null;
                        throw throwable;
                    }
                }
                DBUtils.closeSQLStuff(result, stmt);
                result = null;
                stmt = null;
                if (!considerUsersAliases || null == (email1 = searchobject.getEmail1())) break block33;
                try {
                    String aliasColumn = "ua.value";
                    String select = cs.getSelect();
                    StringBuilder sb = new StringBuilder(select.length());
                    int pos = select.indexOf(" FROM");
                    if (pos < 0 && (pos = select.indexOf(" from")) < 0) {
                        throw new SQLException("SELECT statement does not contain \"FROM\".");
                    }
                    select = sb.append(select.substring(0, pos)).append(',').append("ua.value").append(select.substring(pos)).toString();
                    sb.setLength(0);
                    sb.append(select);
                    sb.append(" JOIN user_attribute AS ua ON co.cid = ? AND ua.cid = ? AND co.userid = ua.id");
                    sb.append(" WHERE ua.name = ? AND value LIKE ? AND ua.id != ? AND co.userid IS NOT NULL");
                    stmt = con.prepareStatement(sb.toString());
                    pos = 1;
                    stmt.setInt(pos++, this.ctx.getContextId());
                    stmt.setInt(pos++, this.ctx.getContextId());
                    stmt.setString(pos++, "alias");
                    stmt.setString(pos++, StringCollection.prepareForSearch(email1, false, true, true));
                    stmt.setInt(pos++, this.userId);
                    result = stmt.executeQuery();
                    while (result.next()) {
                        String alias = result.getString("ua.value");
                        if (foundAddresses.contains(alias)) continue;
                        Contact contact = this.convertResultSet2ContactObject(result, extendedCols, false, con);
                        contact.setEmail1(alias);
                        contacts2.add(contact);
                    }
                }
                catch (SQLException e) {
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
                }
                finally {
                    DBUtils.closeSQLStuff(result, stmt);
                    result = null;
                    stmt = null;
                }
            }
            finally {
                DBPool.closeReaderSilent(this.ctx, con);
            }
        }
        if (order_field == 609) {
            Collections.sort(contacts2, new UseCountComparator(specialSort, this.getLocale()));
        } else if (specialSort) {
            Collections.sort(contacts2, new SpecialAlphanumSortContactComparator(this.getLocale()));
        }
        return new SearchIteratorAdapter(contacts2.iterator(), contacts2.size());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SearchIterator<Contact> searchContacts(String searchpattern, int folderId, int order_field, Order order, int[] cols) throws OXException {
        boolean error = false;
        String orderDir = DBUtils.forSQLCommand(order);
        int orderBy = order_field;
        if (orderBy == 0) {
            orderBy = 502;
        }
        if (" ".equals(orderDir)) {
            orderDir = " ASC ";
        }
        Connection readcon = DBPool.pickup(this.ctx);
        OXFolderAccess folderAccess = new OXFolderAccess(readcon, this.ctx);
        try {
            FolderObject contactFolder = folderAccess.getFolderObject(folderId);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
        }
        catch (OXException e) {
            if (readcon == null) throw e;
            DBPool.closeReaderSilent(this.ctx, readcon);
            throw e;
        }
        Search.checkPatternLength(searchpattern);
        ContactObjectIterator si = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ContactMySql cs = new ContactMySql(this.session, this.ctx);
            cs.setFolder(folderId);
            cs.setSearchHabit(" OR ");
            String sqlOrder = new StringAllocator(32).append(" ORDER BY co.").append(Contacts.mapping[orderBy].getDBFieldName()).append(' ').append(orderDir).append(' ').toString();
            cs.setOrder(sqlOrder);
            EffectivePermission oclPerm = folderAccess.getFolderPermission(folderId, this.userId, this.userConfiguration);
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            if (!oclPerm.canReadAllObjects()) {
                if (!oclPerm.canReadOwnObjects()) {
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
                }
                cs.setReadOnlyOwnFolder(this.userId);
            }
            ContactSearchObject cso = new ContactSearchObject();
            cso.setDisplayName(searchpattern);
            cso.setGivenName(searchpattern);
            cso.setSurname(searchpattern);
            cso.setEmail1(searchpattern);
            cso.setEmail2(searchpattern);
            cso.setEmail3(searchpattern);
            cso.setCatgories(searchpattern);
            cs.setContactSearchObject(cso);
            cs.setSelect(cs.iFgetColsString(cols).toString());
            stmt = cs.getSqlStatement(readcon);
            rs = stmt.executeQuery();
            si = new ContactObjectIterator(rs, stmt, cols, false, readcon);
            if (!error) return new PrefetchIterator<Contact>(si);
        }
        catch (SearchIteratorException e) {
            try {
                error = true;
                throw e;
                catch (SQLException e2) {
                    error = true;
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e2, new Object[0]);
                }
                catch (OXException e3) {
                    error = true;
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                if (!error) throw throwable;
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readcon == null) throw throwable;
                    DBPool.closeReaderSilent(this.ctx, readcon);
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)ex);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        try {
            if (readcon == null) return new PrefetchIterator<Contact>(si);
            DBPool.closeReaderSilent(this.ctx, readcon);
            return new PrefetchIterator<Contact>(si);
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to return Connection", (Throwable)ex);
            return new PrefetchIterator<Contact>(si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contact getObjectById(int objectId, int fid) throws OXException {
        Contact co;
        if (objectId <= 0) {
            throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(Autoboxing.I((int)objectId), Autoboxing.I((int)this.ctx.getContextId()));
        }
        FolderObject contactFolder = new OXFolderAccess(this.ctx).getFolderObject(fid);
        if (contactFolder.getModule() != 3) {
            throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)fid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
        }
        Connection con = DBPool.pickup(this.ctx);
        try {
            co = Contacts.getContactById(objectId, this.userId, this.memberInGroups, this.ctx, this.userConfiguration, con);
            if (!Contacts.performContactReadCheck(contactFolder, this.userId, co.getCreatedBy(), this.userConfiguration, con)) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)fid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            Date creationDate = Attachments.getInstance(new SimpleDBProvider(con, null)).getNewestCreationDate(this.ctx, 7, objectId);
            if (null != creationDate) {
                co.setLastModifiedOfNewestAttachment(creationDate);
            }
        }
        finally {
            DBPool.closeReaderSilent(this.ctx, con);
        }
        return co;
    }

    @Override
    public Contact getUserById(int userid) throws OXException {
        return this.getUsersById(new int[]{userid}, true)[0];
    }

    @Override
    public Contact getUserById(int userId, boolean performReadCheck) throws OXException {
        return this.getUsersById(new int[]{userId}, performReadCheck)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contact[] getUsersById(int[] userIds, boolean performReadCheck) throws OXException {
        Contact[] contacts2;
        Connection readCon = null;
        int fid = 6;
        try {
            readCon = DBPool.pickup(this.ctx);
            FolderObject contactFolder = new OXFolderAccess(readCon, this.ctx).getFolderObject(6);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)6), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            for (Contact contact : contacts2 = Contacts.getUsersById(userIds, this.userId, this.memberInGroups, this.ctx, this.userConfiguration, readCon)) {
                if (contact.getParentFolderID() != 6) {
                    throw ContactExceptionCodes.USER_OUTSIDE_GLOBAL.create(Autoboxing.I((int)contact.getParentFolderID()), Autoboxing.I((int)this.ctx.getContextId()));
                }
                if (!performReadCheck || RdbContactSQLImpl.performSecurityReadCheck(6, contact.getCreatedBy(), this.userId, this.session, readCon, this.ctx)) continue;
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)6), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
        }
        finally {
            if (readCon != null) {
                DBPool.closeReaderSilent(this.ctx, readCon);
            }
        }
        return contacts2;
    }

    public Contact getUserById(int userid, boolean performReadCheck, Connection readCon) throws OXException {
        Contact co = null;
        int fid = 6;
        if (userid <= 0) {
            throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(Autoboxing.I((int)this.userId), Autoboxing.I((int)this.ctx.getContextId()));
        }
        co = Contacts.getUserById(userid, this.userId, this.memberInGroups, this.ctx, this.userConfiguration, readCon);
        int folderId = co.getParentFolderID();
        FolderObject contactFolder = new OXFolderAccess(readCon, this.ctx).getFolderObject(folderId);
        if (contactFolder.getModule() != 3) {
            throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)6), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
        }
        if (performReadCheck && !RdbContactSQLImpl.performSecurityReadCheck(folderId, co.getCreatedBy(), this.userId, this.session, readCon, this.ctx)) {
            throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)6), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
        }
        return co;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SearchIterator<Contact> getModifiedContactsInFolder(int folderId, int[] cols, Date since) throws OXException {
        boolean error = false;
        Connection readCon = null;
        try {
            readCon = DBPool.pickup(this.ctx);
        }
        catch (Exception e) {
            throw ContactExceptionCodes.INIT_CONNECTION_FROM_DBPOOL.create(e, new Object[0]);
        }
        OXFolderAccess folderAccess = new OXFolderAccess(readCon, this.ctx);
        try {
            FolderObject contactFolder = folderAccess.getFolderObject(folderId);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
        }
        catch (OXException e) {
            if (readCon == null) throw e;
            DBPool.closeReaderSilent(this.ctx, readCon);
            throw e;
        }
        ContactObjectIterator si = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            ContactMySql cs = new ContactMySql(this.session, this.ctx);
            EffectivePermission oclPerm = folderAccess.getFolderPermission(folderId, this.userId, this.userConfiguration);
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            if (!oclPerm.canReadAllObjects()) {
                if (!oclPerm.canReadOwnObjects()) {
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
                }
                cs.setReadOnlyOwnFolder(this.userId);
            }
            if (folderId == 6) {
                cs.getInternalUsers();
            } else {
                cs.setFolder(folderId);
            }
            cs.getAllChangedSince(since.getTime());
            cs.setSelect(cs.iFgetColsString(cols).toString());
            stmt = cs.getSqlStatement(readCon);
            rs = stmt.executeQuery();
            si = new ContactObjectIterator(rs, stmt, cols, false, readCon);
            if (!error) return new PrefetchIterator<Contact>(si);
        }
        catch (SearchIteratorException e) {
            try {
                error = true;
                throw e;
                catch (SQLException e2) {
                    error = true;
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e2, new Object[0]);
                }
                catch (OXException e3) {
                    error = true;
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                if (!error) throw throwable;
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readCon == null) throw throwable;
                    DBPool.closeReaderSilent(this.ctx, readCon);
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)ex);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        try {
            if (readCon == null) return new PrefetchIterator<Contact>(si);
            DBPool.closeReaderSilent(this.ctx, readCon);
            return new PrefetchIterator<Contact>(si);
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to return Connection", (Throwable)ex);
            return new PrefetchIterator<Contact>(si);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SearchIterator<Contact> getDeletedContactsInFolder(int folderId, int[] cols, Date since) throws OXException {
        boolean error = false;
        ContactObjectIterator si = null;
        Connection readcon = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            readcon = DBPool.pickup(this.ctx);
            ContactMySql cs = new ContactMySql(this.session, this.ctx);
            cs.setFolder(folderId);
            cs.getAllChangedSince(since.getTime());
            cs.setSelect(cs.iFgetColsStringFromDeleteTable(cols).toString());
            cs.setOrder(" ORDER BY co.field02 ");
            stmt = cs.getSqlStatement(readcon);
            rs = stmt.executeQuery();
            si = new ContactObjectIterator(rs, stmt, cols, false, readcon);
            if (!error) return new PrefetchIterator<Contact>(si);
        }
        catch (SearchIteratorException e) {
            try {
                error = true;
                throw e;
                catch (SQLException e2) {
                    error = true;
                    throw ContactExceptionCodes.SQL_PROBLEM.create(e2, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                if (!error) throw throwable;
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readcon == null) throw throwable;
                    DBPool.closeReaderSilent(this.ctx, readcon);
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)ex);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        try {
            if (readcon == null) return new PrefetchIterator<Contact>(si);
            DBPool.closeReaderSilent(this.ctx, readcon);
            return new PrefetchIterator<Contact>(si);
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to return Connection", (Throwable)ex);
            return new PrefetchIterator<Contact>(si);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteContactObject(int oid, int fuid, Date client_date) throws OXException {
        if (6 == fuid) {
            throw ContactExceptionCodes.NO_USER_CONTACT_DELETE.create();
        }
        Connection readcon = null;
        EffectivePermission oclPerm = null;
        int created_from = 0;
        Contact co = new Contact();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            readcon = DBPool.pickup(this.ctx);
            boolean pflag = false;
            Date changing_date = null;
            ContactMySql cs = new ContactMySql(this.session, this.ctx);
            stmt = readcon.createStatement();
            rs = stmt.executeQuery(cs.iFdeleteContactObject(oid, this.ctx.getContextId()));
            if (!rs.next()) {
                throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(Autoboxing.I((int)oid), Autoboxing.I((int)this.ctx.getContextId()));
            }
            created_from = rs.getInt(2);
            co.setCreatedBy(created_from);
            co.setParentFolderID(fuid);
            co.setObjectID(oid);
            long xx = rs.getLong(3);
            changing_date = new Date(xx);
            int pf = rs.getInt(4);
            if (!rs.wasNull() && pf > 0) {
                pflag = true;
            }
            if (client_date != null && client_date.getTime() >= 0L && client_date.before(changing_date)) {
                throw ContactExceptionCodes.OBJECT_HAS_CHANGED.create(Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)fuid), Autoboxing.I((int)this.userId), Autoboxing.I((int)oid));
            }
            OXFolderAccess folderAccess = new OXFolderAccess(readcon, this.ctx);
            FolderObject contactFolder = folderAccess.getFolderObject(fuid);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)fuid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            if (contactFolder.getType() != 1 && pflag) {
                LOG.debug((Object)new StringAllocator("Here is a contact in a non PRIVATE folder with a set private flag -> (cid=").append(this.ctx.getContextId()).append(" fid=").append(fuid).append(" oid=").append(oid).append(')'));
            } else if (contactFolder.getType() == 1 && pflag && created_from != this.userId) {
                throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Autoboxing.I((int)fuid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            oclPerm = folderAccess.getFolderPermission(fuid, this.userId, this.userConfiguration);
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Autoboxing.I((int)fuid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readcon == null) throw throwable;
                    DBPool.closeReaderSilent(this.ctx, readcon);
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Unable to return Connection", (Throwable)ex);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        try {
            if (readcon != null) {
                DBPool.closeReaderSilent(this.ctx, readcon);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to return Connection", (Throwable)ex);
        }
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable(this.ctx);
            int deletePermission = oclPerm.getDeletePermission();
            if (deletePermission >= 4) {
                Contacts.deleteContact(oid, this.ctx.getContextId(), writecon);
            } else {
                if (deletePermission < 2 || created_from != this.userId) {
                    throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(Autoboxing.I((int)fuid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
                }
                Contacts.deleteContact(oid, this.ctx.getContextId(), writecon);
            }
            EventClient ec = new EventClient(this.session);
            ec.delete(co);
            return;
        }
        catch (OXException e) {
            throw e;
        }
        finally {
            if (writecon != null) {
                DBPool.closeWriterSilent(this.ctx, writecon);
            }
        }
    }

    @Override
    public SearchIterator<Contact> getObjectsById(int[][] object_id, int[] cols) throws OXException, OXException {
        int[] myCols = this.checkColumns(cols);
        try {
            int[][] block_object_id;
            ArrayList<Contact> retval = new ArrayList<Contact>(object_id.length);
            int remain = object_id.length;
            int offset = 0;
            int blockSize = 10;
            while (remain > 10) {
                block_object_id = new int[10][];
                System.arraycopy(object_id, offset, block_object_id, 0, block_object_id.length);
                this.addQueriedContacts(myCols, retval, block_object_id);
                remain -= 10;
                offset += 10;
            }
            if (remain > 0) {
                block_object_id = new int[remain][];
                System.arraycopy(object_id, offset, block_object_id, 0, block_object_id.length);
                this.addQueriedContacts(myCols, retval, block_object_id);
            }
            int size = retval.size();
            return new SearchIteratorDelegator(retval.iterator(), size);
        }
        catch (OXException e) {
            throw e;
        }
        catch (SQLException e) {
            throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
        }
    }

    private int[] checkColumns(int[] cols) {
        TIntHashSet tmp = new TIntHashSet();
        for (int col : cols) {
            if (Contacts.mapping[col] != null) {
                tmp.add(col);
                continue;
            }
            if (606 == col) {
                tmp.add(col);
                int imageId = 570;
                if (Arrays.contains((int[])cols, (int)570) && tmp.contains(570)) continue;
                tmp.add(570);
                continue;
            }
            if (105 == col) {
                tmp.add(col);
                continue;
            }
            if (595 == col) {
                tmp.add(103);
                continue;
            }
            if (6 == col) {
                tmp.add(5);
                continue;
            }
            LOG.warn((Object)("UNKNOWN FIELD -> " + col));
        }
        return tmp.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addQueriedContacts(int[] cols, List<Contact> retval, int[][] object_id) throws SQLException, OXException {
        Connection readcon = DBPool.pickup(this.ctx);
        boolean closeCon = true;
        try {
            int n;
            boolean closeStuff;
            ResultSet res;
            PreparedStatement ps;
            block23: {
                ContactObjectIterator searchIterator;
                block21: {
                    int n2;
                    block22: {
                        ContactMySql contactSQL = new ContactMySql(this.session, this.ctx);
                        contactSQL.setSelect(contactSQL.iFgetColsString(cols).toString());
                        contactSQL.setObjectArray(object_id);
                        ps = null;
                        res = null;
                        closeStuff = true;
                        searchIterator = null;
                        ps = contactSQL.getSqlStatement(readcon);
                        res = ps.executeQuery();
                        searchIterator = new ContactObjectIterator(res, ps, cols, true, readcon);
                        if (searchIterator.size() == -1) break block21;
                        int size = searchIterator.size();
                        for (int i = 0; i < size; ++i) {
                            retval.add((Contact)searchIterator.next());
                        }
                        n2 = size;
                        if (searchIterator == null) break block22;
                        try {
                            searchIterator.close();
                            closeCon = false;
                            closeStuff = false;
                        }
                        catch (SearchIteratorException e) {
                            LOG.error((Object)"Unable to close search iterator", (Throwable)e);
                        }
                    }
                    if (closeStuff) {
                        DBUtils.closeSQLStuff(res, ps);
                    }
                    return n2;
                }
                try {
                    int count = 0;
                    while (searchIterator.hasNext()) {
                        retval.add((Contact)searchIterator.next());
                        ++count;
                    }
                    n = count;
                    if (searchIterator == null) break block23;
                }
                catch (Throwable throwable) {
                    if (searchIterator != null) {
                        try {
                            searchIterator.close();
                            closeCon = false;
                            closeStuff = false;
                        }
                        catch (SearchIteratorException e) {
                            LOG.error((Object)"Unable to close search iterator", (Throwable)e);
                        }
                    }
                    if (closeStuff) {
                        DBUtils.closeSQLStuff(res, ps);
                    }
                    throw throwable;
                }
                try {
                    searchIterator.close();
                    closeCon = false;
                    closeStuff = false;
                }
                catch (SearchIteratorException e) {
                    LOG.error((Object)"Unable to close search iterator", (Throwable)e);
                }
            }
            if (closeStuff) {
                DBUtils.closeSQLStuff(res, ps);
            }
            return n;
        }
        finally {
            if (closeCon) {
                DBPool.closeReaderSilent(this.ctx, readcon);
            }
        }
    }

    public static boolean performSecurityReadCheck(int fid, int created_from, int user, Session so, Connection readcon, Context ctx) {
        return Contacts.performContactReadCheck(fid, created_from, user, ctx, UserConfigurationStorage.getInstance().getUserConfigurationSafe(so.getUserId(), ctx), readcon);
    }

    protected Contact convertResultSet2ContactObject(ResultSet rs, int[] cols, boolean check, Connection con) throws OXException {
        Contact co = new Contact();
        Statement stmt = null;
        try {
            Date creationDate;
            stmt = rs.getStatement();
            co.setParentFolderID(rs.getInt(1));
            co.setContextId(rs.getInt(2));
            co.setCreatedBy(rs.getInt(3));
            long xx = rs.getLong(4);
            Date mi = new Date(xx);
            co.setCreationDate(mi);
            co.setModifiedBy(rs.getInt(5));
            long xx2 = rs.getLong(6);
            mi = new Date(xx2);
            co.setLastModified(mi);
            co.setObjectID(rs.getInt(7));
            int cnt = 8;
            for (int a = 0; a < cols.length; ++a) {
                Contacts.Mapper m = Contacts.mapping[cols[a]];
                if (m == null) continue;
                m.addToContactObject(rs, cnt, co, con, this.userId, this.memberInGroups, this.ctx, this.userConfiguration);
                ++cnt;
            }
            if (check && !RdbContactSQLImpl.performSecurityReadCheck(co.getParentFolderID(), co.getCreatedBy(), this.userId, this.session, con, this.ctx)) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)co.getParentFolderID()), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            if (Arrays.contains((int[])cols, (int)105) && null != (creationDate = Attachments.getInstance(new SimpleDBProvider(con, null)).getNewestCreationDate(this.ctx, 7, co.getObjectID()))) {
                co.setLastModifiedOfNewestAttachment(creationDate);
            }
        }
        catch (SQLException e) {
            throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
        }
        return co;
    }

    protected List<Contact> convertResultsetsToContactsLikeAGrownup(ResultSet rs) throws SQLException, OXException {
        LinkedList<Contact> results = new LinkedList<Contact>();
        ResultSetMetaData metaData = rs.getMetaData();
        LinkedList<ContactField> header = new LinkedList<ContactField>();
        int limit = metaData.getColumnCount();
        for (int i = 0; i < limit; ++i) {
            ContactField field = ContactField.getByFieldName(metaData.getColumnName(i + 1));
            header.add(field);
        }
        ContactSwitcherForTimestamp setter = new ContactSwitcherForTimestamp(){
            {
                this.setDelegate(new ContactSetter());
            }
        };
        while (rs.next()) {
            Contact contact = new Contact();
            for (int i = 0; i < limit; ++i) {
                ContactField field = (ContactField)((Object)header.get(i));
                if (field == null) continue;
                field.doSwitch(setter, contact, rs.getObject(i + 1));
            }
        }
        return results;
    }

    @Override
    public int getFolderId() {
        return 0;
    }

    @Override
    public LdapServer getLdapServer() {
        return null;
    }

    private String generateOrder(int order_field, Order order, SuperCollator collation) {
        String realOrderMechanism;
        int realOrderField;
        if (order_field <= 0 || order_field == 607 || order.equals((Object)Order.NO_ORDER)) {
            return null;
        }
        boolean addCollation = collation != null && collation != SuperCollator.DEFAULT;
        StringBuilder sqlOrder = new StringBuilder();
        sqlOrder.append(" ORDER BY ");
        int n = realOrderField = order_field == 609 ? 608 : order_field;
        if (addCollation) {
            sqlOrder.append(" CONVERT(");
        }
        sqlOrder.append(this.generateFieldPart(realOrderField));
        if (addCollation) {
            sqlOrder.append(" USING '").append(collation.getSqlCharset()).append("') COLLATE '").append(collation.getSqlCollation()).append('\'');
        }
        sqlOrder.append(' ');
        String string = realOrderMechanism = order_field == 609 ? "DESC" : DBUtils.forSQLCommand(order);
        if (realOrderMechanism != null && realOrderMechanism.length() > 0) {
            sqlOrder.append(realOrderMechanism);
        } else {
            sqlOrder.append("ASC");
        }
        return sqlOrder.append(' ').toString();
    }

    private String generateFieldPart(int fieldNum) {
        if (607 != fieldNum) {
            return "co." + Contacts.mapping[fieldNum].getDBFieldName();
        }
        String prefix = "co.";
        StringBuffer buffy = new StringBuffer();
        List<ContactField> fieldsToCheck = java.util.Arrays.asList(ContactField.YOMI_LAST_NAME, ContactField.SUR_NAME, ContactField.DISPLAY_NAME, ContactField.YOMI_COMPANY, ContactField.COMPANY, ContactField.EMAIL1, ContactField.EMAIL2);
        for (ContactField field : fieldsToCheck) {
            buffy.append("IFNULL(").append("co.").append(field.getDbName()).append(',');
        }
        buffy.append("NULL");
        for (ContactField field : fieldsToCheck) {
            buffy.append(')');
        }
        return buffy.toString();
    }

    private String checkFolderRights(ContactSearchtermSqlConverter conv, ContactSql cs) throws OXException {
        if (!conv.hasFolders()) {
            return cs.buildAllFolderSearchString(this.userId, this.memberInGroups, this.session).toString();
        }
        OXFolderAccess oxfa = new OXFolderAccess(this.ctx);
        List<String> folders2 = conv.getFolders();
        int[] folders22 = new int[folders2.size()];
        int i = 0;
        OXFolderAccess folderAccess = new OXFolderAccess(this.ctx);
        for (String folderStr : folders2) {
            int folderId;
            try {
                folderId = Integer.parseInt(folderStr);
            }
            catch (NumberFormatException e) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(folderStr, Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            FolderObject contactFolder = folderAccess.getFolderObject(folderId);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            EffectivePermission oclPerm = oxfa.getFolderPermission(folderId, this.userId, this.userConfiguration);
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            if (!oclPerm.canReadOwnObjects()) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId));
            }
            folders22[i++] = folderId;
        }
        return cs.buildFolderSearch(this.userId, this.memberInGroups, folders22, this.session);
    }

    private class ContactObjectIterator
    implements SearchIterator<Contact> {
        private Contact nexto;
        private Contact pre;
        private final ResultSet rs;
        private final Statement stmt;
        private final Connection readcon;
        private final int[] cols;
        private boolean first = true;
        private final boolean securecheck;
        private final List<OXException> warnings = new ArrayList<OXException>(2);

        public ContactObjectIterator(ResultSet rs, Statement stmt, int[] cols, boolean securecheck, Connection readcon) throws OXException {
            this.rs = rs;
            this.stmt = stmt;
            this.cols = cols;
            this.readcon = readcon;
            this.securecheck = securecheck;
            try {
                if (rs.next()) {
                    this.nexto = securecheck ? RdbContactSQLImpl.this.convertResultSet2ContactObject(rs, cols, true, readcon) : RdbContactSQLImpl.this.convertResultSet2ContactObject(rs, cols, false, readcon);
                }
            }
            catch (SQLException e) {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
            catch (OXException e) {
                throw e;
            }
        }

        public void close() throws OXException {
            DBUtils.closeSQLStuff(this.rs, this.stmt);
            if (this.readcon != null) {
                DBPool.closeReaderSilent(RdbContactSQLImpl.this.ctx, this.readcon);
            }
        }

        public boolean hasNext() throws OXException {
            if (!this.first) {
                this.nexto = this.pre;
            }
            return this.nexto != null;
        }

        public Contact next() throws SearchIteratorException, OXException {
            try {
                if (this.rs.next()) {
                    if (this.securecheck) {
                        this.pre = RdbContactSQLImpl.this.convertResultSet2ContactObject(this.rs, this.cols, true, this.readcon);
                    }
                    this.pre = RdbContactSQLImpl.this.convertResultSet2ContactObject(this.rs, this.cols, false, this.readcon);
                } else {
                    this.pre = null;
                }
                if (this.first) {
                    this.first = false;
                }
                return this.nexto;
            }
            catch (SQLException e) {
                throw ContactExceptionCodes.SQL_PROBLEM.create(e, new Object[0]);
            }
        }

        public int size() {
            return -1;
        }

        public boolean hasSize() {
            return false;
        }

        public void addWarning(OXException warning) {
            this.warnings.add(warning);
        }

        public OXException[] getWarnings() {
            return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }
    }
}

