/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.CalendarWriter;
import com.openexchange.ajax.writer.DataWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AppointmentWriter
extends CalendarWriter {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AppointmentWriter.class));
    private CalendarCollectionService calColl;
    private final boolean forTesting;
    private ServerSession session;
    private static final TIntObjectMap<AppointmentFieldWriter> WRITER_MAP;

    public AppointmentWriter(TimeZone timeZone) {
        this(timeZone, false);
    }

    public AppointmentWriter(TimeZone timeZone, boolean forTesting) {
        super(timeZone, null);
        this.forTesting = forTesting;
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    public CalendarCollectionService getCalendarCollectionService() {
        if (null == this.calColl) {
            this.calColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        }
        return this.calColl;
    }

    public void setCalendarCollectionService(CalendarCollectionService calColl) {
        this.calColl = calColl;
    }

    public JSONArray writeArray(Appointment appointmentObj, int[] cols, Date betweenStart, Date betweenEnd, JSONArray jsonArray) throws JSONException {
        if (appointmentObj.getFullTime() && betweenStart != null && betweenEnd != null) {
            if (this.getCalendarCollectionService().inBetween(appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime(), betweenStart.getTime(), betweenEnd.getTime())) {
                return this.writeArray(appointmentObj, cols, jsonArray);
            }
        } else {
            return this.writeArray(appointmentObj, cols, jsonArray);
        }
        return null;
    }

    public JSONArray writeArray(Appointment appointment, int[] columns, JSONArray json) throws JSONException {
        JSONArray array = new JSONArray();
        for (int column : columns) {
            this.writeField(appointment, column, this.timeZone, array);
        }
        json.put((Object)array);
        return array;
    }

    public void writeAppointment(Appointment appointmentObject, JSONObject jsonObj) throws JSONException {
        boolean isFullTime;
        super.writeFields(appointmentObject, this.timeZone, jsonObj);
        if (appointmentObject.containsTitle()) {
            AppointmentWriter.writeParameter("title", appointmentObject.getTitle(), jsonObj);
        }
        if (isFullTime = appointmentObject.getFullTime()) {
            AppointmentWriter.writeParameter("start_date", appointmentObject.getStartDate(), jsonObj);
            AppointmentWriter.writeParameter("end_date", appointmentObject.getEndDate(), jsonObj);
        } else if (appointmentObject.getRecurrenceType() == 0) {
            AppointmentWriter.writeParameter("start_date", appointmentObject.getStartDate(), this.timeZone, jsonObj);
            AppointmentWriter.writeParameter("end_date", appointmentObject.getEndDate(), this.timeZone, jsonObj);
        } else {
            AppointmentWriter.writeParameter("start_date", appointmentObject.getStartDate(), appointmentObject.getStartDate(), this.timeZone, jsonObj);
            AppointmentWriter.writeParameter("end_date", appointmentObject.getEndDate(), appointmentObject.getEndDate(), this.timeZone, jsonObj);
        }
        if (appointmentObject.containsShownAs()) {
            AppointmentWriter.writeParameter("shown_as", appointmentObject.getShownAs(), jsonObj);
        }
        if (appointmentObject.containsLocation()) {
            AppointmentWriter.writeParameter("location", appointmentObject.getLocation(), jsonObj);
        }
        if (appointmentObject.containsNote()) {
            AppointmentWriter.writeParameter("note", appointmentObject.getNote(), jsonObj);
        }
        if (appointmentObject.containsFullTime()) {
            AppointmentWriter.writeParameter("full_time", appointmentObject.getFullTime(), jsonObj);
        }
        if (appointmentObject.containsAlarm()) {
            AppointmentWriter.writeParameter("alarm", appointmentObject.getAlarm(), jsonObj);
        } else if (appointmentObject.containsUserParticipants() && null != this.session && this.isPublicFolder(appointmentObject)) {
            int userId = this.session.getUserId();
            for (UserParticipant userParticipant : appointmentObject.getUsers()) {
                if (userId != userParticipant.getIdentifier() || userParticipant.getAlarmMinutes() <= 0) continue;
                AppointmentWriter.writeParameter("alarm", userParticipant.getAlarmMinutes(), jsonObj);
                break;
            }
        }
        if (appointmentObject.containsRecurrenceType()) {
            AppointmentWriter.writeRecurrenceParameter(appointmentObject, jsonObj);
        } else if (!this.forTesting) {
            AppointmentWriter.writeParameter("recurrence_type", 0, jsonObj);
        }
        if (appointmentObject.containsRecurrenceID()) {
            AppointmentWriter.writeParameter("recurrence_id", appointmentObject.getRecurrenceID(), jsonObj);
        }
        if (appointmentObject.containsRecurrencePosition()) {
            AppointmentWriter.writeParameter("recurrence_position", appointmentObject.getRecurrencePosition(), jsonObj);
        }
        if (appointmentObject.containsRecurrenceDatePosition()) {
            AppointmentWriter.writeParameter("recurrence_date_position", appointmentObject.getRecurrenceDatePosition(), jsonObj);
        }
        if (appointmentObject.containsChangeExceptions() && appointmentObject.getChangeException() != null && appointmentObject.getChangeException().length > 0) {
            jsonObj.put("change_exceptions", (Object)AppointmentWriter.getExceptionAsJSONArray(appointmentObject.getChangeException()));
        }
        if (appointmentObject.containsDeleteExceptions() && appointmentObject.getDeleteException() != null && appointmentObject.getDeleteException().length > 0) {
            jsonObj.put("delete_exceptions", (Object)AppointmentWriter.getExceptionAsJSONArray(appointmentObject.getDeleteException()));
        }
        if (appointmentObject.containsParticipants()) {
            jsonObj.put("participants", (Object)AppointmentWriter.getParticipantsAsJSONArray(appointmentObject));
        }
        if (appointmentObject.containsUserParticipants()) {
            jsonObj.put("users", (Object)AppointmentWriter.getUsersAsJSONArray(appointmentObject));
        }
        if (appointmentObject.getIgnoreConflicts()) {
            AppointmentWriter.writeParameter("ignore_conflicts", true, jsonObj);
        }
        if (appointmentObject.containsTimezone()) {
            AppointmentWriter.writeParameter("timezone", appointmentObject.getTimezoneFallbackUTC(), jsonObj);
        }
        if (appointmentObject.containsRecurringStart()) {
            AppointmentWriter.writeParameter("recurrence_start", appointmentObject.getRecurringStart(), jsonObj);
        }
        if (appointmentObject instanceof CalendarDataObject && ((CalendarDataObject)appointmentObject).isHardConflict()) {
            AppointmentWriter.writeParameter("hard_conflict", true, jsonObj);
        }
    }

    private boolean isPublicFolder(Appointment appointmentObject) {
        try {
            int folderID = appointmentObject.getParentFolderID();
            return folderID > 0 && 2 == new OXFolderAccess(this.session.getContext()).getFolderType(folderID);
        }
        catch (OXException e) {
            return false;
        }
    }

    protected void writeField(Appointment appointment, int column, TimeZone tz, JSONArray json) throws JSONException {
        AppointmentFieldWriter writer = (AppointmentFieldWriter)WRITER_MAP.get(column);
        if (null != writer) {
            writer.write(appointment, json);
            return;
        }
        if (super.writeField(appointment, column, tz, json)) {
            return;
        }
        boolean isFullTime = appointment.getFullTime();
        switch (column) {
            case 201: {
                if (isFullTime) {
                    AppointmentWriter.writeValue(appointment.getStartDate(), json);
                    break;
                }
                if (appointment.getRecurrenceType() == 0) {
                    AppointmentWriter.writeValue(appointment.getStartDate(), this.timeZone, json);
                    break;
                }
                AppointmentWriter.writeValue(appointment.getStartDate(), appointment.getStartDate(), this.timeZone, json);
                break;
            }
            case 202: {
                if (isFullTime) {
                    AppointmentWriter.writeValue(appointment.getEndDate(), json);
                    break;
                }
                if (appointment.getRecurrenceType() == 0) {
                    AppointmentWriter.writeValue(appointment.getEndDate(), this.timeZone, json);
                    break;
                }
                AppointmentWriter.writeValue(appointment.getEndDate(), appointment.getEndDate(), this.timeZone, json);
                break;
            }
            default: {
                LOG.warn((Object)("Column " + column + " is unknown for appointment."));
            }
        }
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(24, 1.0f);
        m.put(200, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getTitle(), jsonArray);
            }
        });
        m.put(402, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getShownAs(), jsonArray, appointmentObject.containsShownAs());
            }
        });
        m.put(400, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getLocation(), jsonArray);
            }
        });
        m.put(401, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getFullTime(), jsonArray, appointmentObject.containsFullTime());
            }
        });
        m.put(203, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getNote(), jsonArray);
            }
        });
        m.put(206, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getRecurrenceID(), jsonArray, appointmentObject.containsRecurrenceID());
            }
        });
        m.put(209, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getRecurrenceType(), jsonArray, appointmentObject.containsRecurrenceType());
            }
        });
        m.put(215, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getInterval(), jsonArray, appointmentObject.containsInterval());
            }
        });
        m.put(212, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getDays(), jsonArray, appointmentObject.containsDays());
            }
        });
        m.put(213, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getDayInMonth(), jsonArray, appointmentObject.containsDayInMonth());
            }
        });
        m.put(214, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getMonth(), jsonArray, appointmentObject.containsMonth());
            }
        });
        m.put(216, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                if (appointmentObject.containsOccurrence()) {
                    jsonArray.put(JSONObject.NULL);
                } else if (appointmentObject.containsUntil()) {
                    DataWriter.writeValue(appointmentObject.getUntil(), jsonArray);
                } else {
                    jsonArray.put(JSONObject.NULL);
                }
            }
        });
        m.put(222, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getOccurrence(), jsonArray, appointmentObject.containsOccurrence());
            }
        });
        m.put(208, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getRecurrenceDatePosition(), jsonArray);
            }
        });
        m.put(211, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                JSONArray jsonDeleteExceptionArray = CalendarWriter.getExceptionAsJSONArray(appointmentObject.getDeleteException());
                if (jsonDeleteExceptionArray == null) {
                    jsonArray.put(JSONObject.NULL);
                } else {
                    jsonArray.put((Object)jsonDeleteExceptionArray);
                }
            }
        });
        m.put(210, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                JSONArray jsonChangeExceptionArray = CalendarWriter.getExceptionAsJSONArray(appointmentObject.getChangeException());
                if (jsonChangeExceptionArray == null) {
                    jsonArray.put(JSONObject.NULL);
                } else {
                    jsonArray.put((Object)jsonChangeExceptionArray);
                }
            }
        });
        m.put(207, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getRecurrencePosition(), jsonArray, appointmentObject.containsRecurrencePosition());
            }
        });
        m.put(408, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getTimezoneFallbackUTC(), jsonArray);
            }
        });
        m.put(410, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getRecurringStart(), jsonArray, appointmentObject.containsRecurringStart());
            }
        });
        m.put(220, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) throws JSONException {
                JSONArray jsonParticipantArray = CalendarWriter.getParticipantsAsJSONArray(appointmentObject);
                if (jsonParticipantArray == null) {
                    jsonArray.put(JSONObject.NULL);
                } else {
                    jsonArray.put((Object)jsonParticipantArray);
                }
            }
        });
        m.put(221, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) throws JSONException {
                JSONArray jsonUserArray = CalendarWriter.getUsersAsJSONArray(appointmentObject);
                if (jsonUserArray == null) {
                    jsonArray.put(JSONObject.NULL);
                } else {
                    jsonArray.put((Object)jsonUserArray);
                }
            }
        });
        m.put(204, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getAlarm(), jsonArray, appointmentObject.containsAlarm());
            }
        });
        m.put(217, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getNotification(), jsonArray, appointmentObject.getNotification());
            }
        });
        m.put(218, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getRecurrenceCalculator(), jsonArray);
            }
        });
        m.put(224, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getOrganizer(), jsonArray, appointmentObject.containsOrganizer());
            }
        });
        m.put(223, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getUid(), jsonArray, appointmentObject.containsUid());
            }
        });
        m.put(225, (Object)new AppointmentFieldWriter(){

            @Override
            public void write(Appointment appointmentObject, JSONArray jsonArray) {
                DataWriter.writeValue(appointmentObject.getSequence(), jsonArray, appointmentObject.containsSequence());
            }
        });
        WRITER_MAP = m;
    }

    private static interface AppointmentFieldWriter {
        public void write(Appointment var1, JSONArray var2) throws JSONException;
    }
}

