/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class BasicTypeJsonConverter
implements ResultConverter {
    private static final String JSON = "json";
    public static final List<ResultConverter> CONVERTERS = Collections.unmodifiableList(Arrays.asList(new BasicTypeJsonConverter("string"), new BasicTypeJsonConverter("int"), new BasicTypeJsonConverter("float"), new BasicTypeJsonConverter("boolean")));
    private final String inputFormat;

    protected BasicTypeJsonConverter(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Override
    public String getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public String getOutputFormat() {
        return JSON;
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        Object resultObject = result.getResultObject();
        if (resultObject instanceof Collection) {
            result.setResultObject(new JSONArray((Collection)resultObject), JSON);
        } else if (resultObject instanceof Map) {
            Map map = (Map)resultObject;
            result.setResultObject(new JSONObject(map), JSON);
        } else if (resultObject instanceof String) {
            result.setResultObject(resultObject, JSON);
        } else if (resultObject instanceof Number) {
            result.setResultObject(resultObject, JSON);
        } else {
            result.setResultObject(BasicTypeJsonConverter.asJSObject(resultObject.toString()), JSON);
        }
    }

    private static Object asJSObject(String propertyValue) {
        if (null == propertyValue) {
            return null;
        }
        try {
            return new JSONTokener(propertyValue).nextValue();
        }
        catch (Exception e) {
            return propertyValue;
        }
    }
}

