/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.Login;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogProperties;
import com.openexchange.log.LogPropertyName;
import com.openexchange.log.PropertiesAppendingLogWrapper;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.session.SessionSecretChecker;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;

public class DispatcherServlet
extends SessionServlet {
    private static final long serialVersionUID = -8060034833311074781L;
    private static final Log LOG = com.openexchange.log.Log.loggerFor(DispatcherServlet.class);
    private static final Session NO_SESSION = new SessionObject(Dispatcher.class.getSimpleName() + "-Fake-Session");
    private static final EnumSet<LogProperties.Name> PROPS_TO_IGNORE = EnumSet.of(LogProperties.Name.SESSION_CONTEXT_ID);
    private static final AtomicReference<Dispatcher> DISPATCHER = new AtomicReference();
    private static final List<ResponseRenderer> RESPONSE_RENDERERS = new CopyOnWriteArrayList<ResponseRenderer>();
    protected final AJAXRequestDataTools defaultRequestDataTools = AJAXRequestDataTools.getInstance();
    protected final String lineSeparator = System.getProperty("line.separator");
    private static final AJAXRequestResult.ResultType ETAG = AJAXRequestResult.ResultType.ETAG;
    private static final AJAXRequestResult.ResultType DIRECT = AJAXRequestResult.ResultType.DIRECT;

    public static void setDispatcher(Dispatcher dispatcher) {
        DISPATCHER.set(dispatcher);
    }

    public static Dispatcher getDispatcher() {
        return DISPATCHER.get();
    }

    public static void setPrefix(String prefix) {
        Dispatcher.PREFIX.set(prefix);
    }

    public static String getPrefix() {
        return Dispatcher.PREFIX.get();
    }

    protected AJAXRequestDataTools getAjaxRequestDataTools() {
        return this.defaultRequestDataTools;
    }

    public static void registerRenderer(ResponseRenderer renderer) {
        RESPONSE_RENDERERS.add(renderer);
    }

    public static void unregisterRenderer(ResponseRenderer renderer) {
        RESPONSE_RENDERERS.remove(renderer);
    }

    public static void clearRenderer() {
        RESPONSE_RENDERERS.clear();
    }

    @Override
    protected void initializeSession(HttpServletRequest req) throws OXException {
        Cookie[] cookies;
        if (null != DispatcherServlet.getSessionObject((ServletRequest)req, true)) {
            return;
        }
        SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (sessiondService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        ServerSession session = null;
        boolean sessionParamFound = false;
        String sSession = req.getParameter("session");
        if (sSession != null && sSession.length() > 0) {
            String sessionId = DispatcherServlet.getSessionId((ServletRequest)req);
            try {
                session = this.getSession(req, sessionId, sessiondService);
            }
            catch (OXException e) {
                if (!SessionExceptionCodes.WRONG_SESSION_SECRET.equals(e)) {
                    throw e;
                }
                String wrongSecret = e.getProperty(SessionExceptionCodes.WRONG_SESSION_SECRET.name());
                if (!"null".equals(wrongSecret)) {
                    throw e;
                }
                session = DispatcherServlet.getSession(hashSource, req, sessionId, sessiondService, new NoSecretCallbackChecker(DISPATCHER.get(), e, this.getAjaxRequestDataTools()));
            }
            this.verifySession(req, sessiondService, sessionId, session);
            DispatcherServlet.rememberSession(req, session);
            sessionParamFound = true;
        }
        boolean mayOmitSession = false;
        if (!sessionParamFound) {
            AJAXRequestDataTools requestDataTools = this.getAjaxRequestDataTools();
            String module = requestDataTools.getModule(Dispatcher.PREFIX.get(), req);
            String action = requestDataTools.getAction(req);
            mayOmitSession = DISPATCHER.get().mayOmitSession(module, action);
        }
        if (!mayOmitSession && (cookies = req.getCookies()) != null) {
            ServerSession simpleSession = null;
            for (Cookie cookie : cookies) {
                if (!Login.PUBLIC_SESSION_NAME.equals(cookie.getName())) continue;
                String altId = cookie.getValue();
                if (null != altId && null != session && altId.equals(session.getParameter(Session.PARAM_ALTERNATIVE_ID))) {
                    simpleSession = session;
                    break;
                }
                simpleSession = ServerSessionAdapter.valueOf(sessiondService.getSessionByAlternativeId(cookie.getValue()));
                break;
            }
            if (simpleSession != null) {
                DispatcherServlet.checkSecret(hashSource, req, simpleSession);
                this.verifySession(req, sessiondService, simpleSession.getSessionID(), simpleSession);
                DispatcherServlet.rememberPublicSession(req, simpleSession);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, false);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, boolean preferStream) throws IOException {
        AJAXRequestResult result;
        AJAXRequestData requestData;
        Dispatcher dispatcher;
        AJAXState state;
        block16: {
            block15: {
                httpResponse.setStatus(200);
                httpResponse.setContentType("text/javascript; charset=UTF-8");
                Tools.disableCaching(httpResponse);
                state = null;
                dispatcher = DISPATCHER.get();
                AJAXRequestDataTools requestDataTools = this.getAjaxRequestDataTools();
                String module = requestDataTools.getModule(Dispatcher.PREFIX.get(), httpRequest);
                String action = requestDataTools.getAction(httpRequest);
                ServerSession session = this.getSession(httpRequest, dispatcher, module, action);
                requestData = requestDataTools.parseRequest(httpRequest, preferStream, Tools.isMultipartContent(httpRequest), session, Dispatcher.PREFIX.get(), httpResponse);
                requestData.setSession(session);
                state = dispatcher.begin();
                result = dispatcher.perform(requestData, state, session);
                if (!ETAG.equals((Object)result.getType())) break block15;
                httpResponse.setStatus(304);
                long expires = result.getExpires();
                Tools.setETag(requestData.getETag(), expires > 0L ? new Date(System.currentTimeMillis() + expires) : null, httpResponse);
                if (null == state) return;
                dispatcher.end(state);
                return;
            }
            if (!DIRECT.equals((Object)result.getType())) break block16;
            if (null == state) return;
            dispatcher.end(state);
            return;
        }
        try {
            this.sendResponse(requestData, result, httpRequest, httpResponse);
            if (null == state) return;
        }
        catch (OXException e) {
            block18: {
                block17: {
                    if (!AjaxExceptionCodes.BAD_REQUEST.equals(e)) break block17;
                    httpResponse.sendError(400, e.getMessage());
                    if (null == state) return;
                    dispatcher.end(state);
                    return;
                }
                if (!AjaxExceptionCodes.HTTP_ERROR.equals(e)) break block18;
                Object[] logArgs = e.getLogArgs();
                Object statusMsg = logArgs.length > 1 ? logArgs[1] : null;
                httpResponse.sendError(((Integer)logArgs[0]).intValue(), null == statusMsg ? null : statusMsg.toString());
                if (null == state) return;
                dispatcher.end(state);
                return;
            }
            if (AjaxExceptionCodes.UNEXPECTED_ERROR.equals(e)) {
                LOG.error((Object)new StringAllocator("Unexpected error: '").append(e.getMessage()).append('\'').toString(), (Throwable)e);
            } else if (e.isLoggable(LogLevel.ERROR)) {
                if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) {
                    this.logException((Exception)((Object)e), LogLevel.DEBUG);
                } else {
                    this.logException((Exception)((Object)e));
                }
            }
            String action = httpRequest.getParameter("action");
            APIResponseRenderer.writeResponse(new Response().setException(e), null == action ? this.toUpperCase(httpRequest.getMethod()) : action, httpRequest, httpResponse);
            if (null == state) return;
            dispatcher.end(state);
            return;
        }
        catch (RuntimeException e2) {
            this.logException(e2);
            OXException exception = AjaxExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
            String action2 = httpRequest.getParameter("action");
            APIResponseRenderer.writeResponse(new Response().setException(exception), null == action2 ? this.toUpperCase(httpRequest.getMethod()) : action2, httpRequest, httpResponse);
            if (null == state) return;
            dispatcher.end(state);
            return;
            {
                catch (Throwable throwable) {
                    if (null == state) throw throwable;
                    dispatcher.end(state);
                    throw throwable;
                }
            }
        }
        dispatcher.end(state);
        return;
    }

    private void logException(Exception e) {
        this.logException(e, null);
    }

    private void logException(Exception e, LogLevel logLevel) {
        String msg;
        if (LogProperties.isEnabled()) {
            StringAllocator logBuilder = new StringAllocator(1024).append("Error processing request:").append(this.lineSeparator);
            if (LOG instanceof PropertiesAppendingLogWrapper) {
                Set nonmatching = ((PropertiesAppendingLogWrapper)LOG).getPropertiesFor(LogPropertyName.LogLevel.ERROR, LogProperties.optLogProperties());
                logBuilder.append(LogProperties.getAndPrettyPrint((Collection)nonmatching));
            } else {
                logBuilder.append(LogProperties.getAndPrettyPrint(PROPS_TO_IGNORE));
            }
            msg = logBuilder.toString();
        } else {
            msg = "Error processing request.";
        }
        if (null == logLevel) {
            LOG.error((Object)msg, (Throwable)e);
        } else {
            switch (logLevel) {
                case TRACE: {
                    LOG.trace((Object)msg, (Throwable)e);
                    break;
                }
                case DEBUG: {
                    LOG.debug((Object)msg, (Throwable)e);
                    break;
                }
                case INFO: {
                    LOG.info((Object)msg, (Throwable)e);
                    break;
                }
                case WARNING: {
                    LOG.warn((Object)msg, (Throwable)e);
                    break;
                }
                default: {
                    LOG.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    private ServerSession getSession(HttpServletRequest httpRequest, Dispatcher dispatcher, String module, String action) throws OXException {
        ServerSession session = DispatcherServlet.getSessionObject((ServletRequest)httpRequest, dispatcher.mayUseFallbackSession(module, action));
        if (session == null) {
            if (!dispatcher.mayOmitSession(module, action)) {
                throw dispatcher.mayUseFallbackSession(module, action) ? AjaxExceptionCodes.MISSING_COOKIE.create(Login.PUBLIC_SESSION_NAME) : AjaxExceptionCodes.MISSING_PARAMETER.create("session");
            }
            session = this.fakeSession();
        }
        return session;
    }

    private ServerSession fakeSession() {
        UserImpl user = new UserImpl();
        user.setAttributes(new HashMap<String, Set<String>>(1));
        return new ServerSessionAdapter(NO_SESSION, new ContextImpl(-1), user);
    }

    protected void sendResponse(AJAXRequestData requestData, AJAXRequestResult result, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        int highest = 0;
        boolean first = true;
        ResponseRenderer candidate = null;
        for (ResponseRenderer renderer : RESPONSE_RENDERERS) {
            if (!first && highest > renderer.getRanking() || !renderer.handles(requestData, result)) continue;
            first = false;
            highest = renderer.getRanking();
            candidate = renderer;
        }
        if (null == candidate) {
            throw new IllegalStateException("No appropriate " + ResponseRenderer.class.getSimpleName() + " for request data/result pair.");
        }
        candidate.write(requestData, result, httpRequest, httpResponse);
    }

    private String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    private static final class NoSecretCallbackChecker
    implements SessionSecretChecker {
        private static final String PARAM_TOKEN = Session.PARAM_TOKEN;
        private final Dispatcher dispatcher;
        private final OXException e;
        private final AJAXRequestDataTools requestDataTools;

        protected NoSecretCallbackChecker(Dispatcher dispatcher, OXException e, AJAXRequestDataTools requestDataTools) {
            this.requestDataTools = requestDataTools;
            this.dispatcher = dispatcher;
            this.e = e;
        }

        public void checkSecret(Session session, HttpServletRequest req, String cookieHashSource) throws OXException {
            String action;
            String module = this.requestDataTools.getModule(Dispatcher.PREFIX.get(), req);
            boolean noSecretCallback = this.dispatcher.noSecretCallback(module, action = this.requestDataTools.getAction(req));
            if (!noSecretCallback) {
                throw this.e;
            }
            String paramToken = PARAM_TOKEN;
            String token = (String)session.getParameter(paramToken);
            session.setParameter(paramToken, null);
            if (null == token || !token.equals(req.getParameter(paramToken))) {
                throw this.e;
            }
        }
    }
}

