/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.Login;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.BrowserDetector;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ClientWhitelist;
import com.openexchange.configuration.CookieHashSource;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.ForceLog;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.session.SessionSecretChecker;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.IPRange;
import com.openexchange.sessiond.impl.SubnetMask;
import com.openexchange.sessiond.impl.ThreadLocalSessionHolder;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.CountingHttpServletRequest;
import com.openexchange.tools.servlet.RateLimitedException;
import com.openexchange.tools.servlet.http.Cookies;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONException;

public abstract class SessionServlet
extends AJAXServlet {
    private static final long serialVersionUID = -8308340875362868795L;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(SessionServlet.class));
    private static final boolean INFO = LOG.isInfoEnabled();
    private static final boolean DEBUG = LOG.isDebugEnabled();
    public static final String SESSION_KEY = "sessionObject";
    public static final String PUBLIC_SESSION_KEY = "publicSessionObject";
    public static final String SESSION_WHITELIST_FILE = "noipcheck.cnf";
    private static final List<IPRange> RANGES = new LinkedList<IPRange>();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private static volatile boolean checkIP = true;
    private static volatile ClientWhitelist clientWhitelist;
    protected static volatile CookieHashSource hashSource;
    private static volatile boolean rangesLoaded;
    private static final Lock RANGE_LOCK;
    private static volatile SubnetMask allowedSubnet;
    private static volatile Integer maxConcurrentRequests;

    protected SessionServlet() {
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (INITIALIZED.compareAndSet(false, true)) {
            checkIP = Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.IP_CHECK.getPropertyName()));
            hashSource = CookieHashSource.parse(config.getInitParameter(ServerConfig.Property.COOKIE_HASH.getPropertyName()));
            clientWhitelist = new ClientWhitelist().add(config.getInitParameter(ServerConfig.Property.IP_CHECK_WHITELIST.getPropertyName()));
            String ipMaskV4 = config.getInitParameter(ServerConfig.Property.IP_MASK_V4.getPropertyName());
            String ipMaskV6 = config.getInitParameter(ServerConfig.Property.IP_MASK_V6.getPropertyName());
            allowedSubnet = new SubnetMask(ipMaskV4, ipMaskV6);
        }
        this.initRanges(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRanges(ServletConfig config) {
        if (rangesLoaded) {
            return;
        }
        if (checkIP) {
            String text = null;
            text = config.getInitParameter(SESSION_WHITELIST_FILE);
            if (text == null) {
                ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                if (configurationService != null) {
                    text = configurationService.getText(SESSION_WHITELIST_FILE);
                } else {
                    return;
                }
            }
            rangesLoaded = true;
            if (text != null) {
                LOG.info((Object)"Exceptions from IP Check have been defined.");
                RANGE_LOCK.lock();
                try {
                    String[] lines;
                    RANGES.clear();
                    for (String line : lines = Strings.splitByCRLF((String)text)) {
                        if ((line = line.replaceAll("\\s", "")).equals("") || line.length() != 0 && line.charAt(0) == '#') continue;
                        RANGES.add(IPRange.parseRange(line));
                    }
                }
                finally {
                    RANGE_LOCK.unlock();
                }
            }
        } else {
            rangesLoaded = true;
        }
    }

    protected void initializeSession(HttpServletRequest req) throws OXException {
        Cookie[] cookies;
        if (null != SessionServlet.getSessionObject((ServletRequest)req, true)) {
            return;
        }
        SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (sessiondService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        ServerSession session = null;
        String sSession = req.getParameter("session");
        if (sSession != null && !sSession.equals("")) {
            String sessionId = SessionServlet.getSessionId((ServletRequest)req);
            session = this.getSession(req, sessionId, sessiondService);
            this.verifySession(req, sessiondService, sessionId, session);
            SessionServlet.rememberSession(req, session);
        }
        if ((cookies = req.getCookies()) != null) {
            ServerSession simpleSession = null;
            for (Cookie cookie : cookies) {
                if (!Login.PUBLIC_SESSION_NAME.equals(cookie.getName())) continue;
                String altId = cookie.getValue();
                if (null != altId && null != session && altId.equals(session.getParameter(Session.PARAM_ALTERNATIVE_ID))) {
                    simpleSession = session;
                    break;
                }
                simpleSession = ServerSessionAdapter.valueOf(sessiondService.getSessionByAlternativeId(cookie.getValue()));
                break;
            }
            if (simpleSession != null) {
                SessionServlet.checkSecret(hashSource, req, simpleSession);
                this.verifySession(req, sessiondService, simpleSession.getSessionID(), simpleSession);
                SessionServlet.rememberPublicSession(req, simpleSession);
            }
        }
    }

    protected void verifySession(HttpServletRequest req, SessiondService sessiondService, String sessionId, ServerSession session) throws OXException {
        if (!sessionId.equals(session.getSessionID())) {
            if (INFO) {
                LOG.info((Object)("Request's session identifier \"" + sessionId + "\" differs from the one indicated by SessionD service \"" + session.getSessionID() + "\"."));
            }
            throw SessionExceptionCodes.WRONG_SESSION.create();
        }
        Context ctx = session.getContext();
        if (!ctx.isEnabled()) {
            sessiondService.removeSession(sessionId);
            if (INFO) {
                LOG.info((Object)("The context " + ctx.getContextId() + " associated with session is locked."));
            }
            throw SessionExceptionCodes.CONTEXT_LOCKED.create();
        }
        this.checkIP(session, req.getRemoteAddr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block22: {
            AtomicInteger counter;
            block21: {
                Tools.disableCaching(resp);
                counter = null;
                SessionThreadCounter threadCounter = (SessionThreadCounter)SessionThreadCounter.REFERENCE.get();
                String sessionId = null;
                ServerSession session = null;
                try {
                    this.initializeSession(req);
                    session = SessionServlet.getSessionObject((ServletRequest)req, true);
                    if (null != session) {
                        int maxConcurrentRequests = SessionServlet.getMaxConcurrentRequests(session);
                        if (maxConcurrentRequests > 0 && null != (counter = (AtomicInteger)session.getParameter(Session.PARAM_COUNTER)) && counter.incrementAndGet() > maxConcurrentRequests) {
                            if (INFO) {
                                LOG.info((Object)("User " + session.getUserId() + " in context " + session.getContextId() + " exceeded max. concurrent requests (" + maxConcurrentRequests + ")."));
                            }
                            throw AjaxExceptionCodes.TOO_MANY_REQUESTS.create();
                        }
                        ThreadLocalSessionHolder.getInstance().setSession(session);
                        if (null != threadCounter) {
                            sessionId = session.getSessionID();
                            threadCounter.increment(sessionId);
                        }
                    }
                    super.service(new CountingHttpServletRequest(req), resp);
                    if (null == sessionId || null == threadCounter) break block21;
                }
                catch (RateLimitedException e) {
                    resp.setContentType("text/plain; charset=UTF-8");
                    resp.sendError(429, "Too Many Requests - Your request is being rate limited.");
                    break block22;
                }
                catch (OXException e2) {
                    block23: {
                        if (SessionExceptionCodes.getErrorPrefix().equals(e2.getPrefix())) {
                            LOG.debug((Object)e2.getMessage(), (Throwable)e2);
                            this.handleSessiondException(e2, req, resp);
                            Response response = new Response();
                            response.setException(e2);
                            resp.setContentType("text/javascript; charset=UTF-8");
                            PrintWriter writer = resp.getWriter();
                            try {
                                ResponseWriter.write(response, writer, SessionServlet.localeFrom(session));
                                writer.flush();
                            }
                            catch (JSONException e1) {
                                this.log("Error while writing response object.", e1);
                                SessionServlet.sendError(resp);
                            }
                        } else {
                            e2.log(LOG);
                            Response response = new Response(SessionServlet.getSessionObject((ServletRequest)req));
                            response.setException(e2);
                            resp.setContentType("text/javascript; charset=UTF-8");
                            PrintWriter writer = resp.getWriter();
                            try {
                                ResponseWriter.write(response, writer, SessionServlet.localeFrom(session));
                                writer.flush();
                            }
                            catch (JSONException e1) {
                                this.log("Error while writing response object.", e1);
                                SessionServlet.sendError(resp);
                            }
                        }
                        if (null == sessionId || null == threadCounter) break block23;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        threadCounter.decrement(sessionId);
                    }
                    ThreadLocalSessionHolder.getInstance().setSession(null);
                    LogProperties.removeSessionProperties();
                    if (null != counter) {
                        counter.getAndDecrement();
                    }
                    break block22;
                }
                finally {
                    if (null != sessionId && null != threadCounter) {
                        threadCounter.decrement(sessionId);
                    }
                    ThreadLocalSessionHolder.getInstance().setSession(null);
                    LogProperties.removeSessionProperties();
                    if (null != counter) {
                        counter.getAndDecrement();
                    }
                }
                threadCounter.decrement(sessionId);
            }
            ThreadLocalSessionHolder.getInstance().setSession(null);
            LogProperties.removeSessionProperties();
            if (null != counter) {
                counter.getAndDecrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getMaxConcurrentRequests(ServerSession session) {
        Integer tmp = maxConcurrentRequests;
        if (null != tmp) return tmp;
        Class<SessionServlet> clazz = SessionServlet.class;
        synchronized (SessionServlet.class) {
            tmp = maxConcurrentRequests;
            if (null != tmp) return tmp;
            tmp = maxConcurrentRequests = Integer.valueOf(SessionServlet.getMaxConcurrentRequests0(session));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tmp;
        }
    }

    private static int getMaxConcurrentRequests0(ServerSession session) {
        if (session == null) {
            return 0;
        }
        Set<String> set = session.getUser().getAttributes().get("ajax.maxCount");
        if (null == set || set.isEmpty()) {
            try {
                return ServerConfig.getInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS);
            }
            catch (OXException e) {
                return Integer.parseInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS.getDefaultValue());
            }
        }
        try {
            return Integer.parseInt(set.iterator().next());
        }
        catch (NumberFormatException e) {
            try {
                return ServerConfig.getInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS);
            }
            catch (OXException oxe) {
                return Integer.parseInt(ServerConfig.Property.DEFAULT_MAX_CONCURRENT_AJAX_REQUESTS.getDefaultValue());
            }
        }
    }

    protected void superService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    private void checkIP(Session session, String actual) throws OXException {
        SessionServlet.checkIP(checkIP, this.getRanges(), session, actual, clientWhitelist);
    }

    private List<IPRange> getRanges() {
        return RANGES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSessiondException(OXException e, HttpServletRequest req, HttpServletResponse resp) {
        if (SessionServlet.isIpCheckError(e)) {
            try {
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                String sessionId = SessionServlet.getSessionId((ServletRequest)req);
                ServerSession session = this.getSession(req, sessionId, sessiondService);
                SessionServlet.removeOXCookies(session.getHash(), req, resp);
                SessionServlet.removeJSESSIONID(req, resp);
                sessiondService.removeSession(sessionId);
            }
            catch (Exception e2) {
                LOG.error((Object)"Cookies could not be removed.", (Throwable)e2);
            }
            finally {
                LogProperties.removeSessionProperties();
            }
        }
    }

    public static boolean isIpCheckError(OXException e) {
        SessionExceptionCodes code = SessionExceptionCodes.WRONG_CLIENT_IP;
        return code.equals(e) && code.getCategory().equals(e.getCategory());
    }

    public static void checkIP(boolean doCheck, List<IPRange> ranges, Session session, String actual, ClientWhitelist whitelist) throws OXException {
        if (null == actual || !actual.equals(session.getLocalIp())) {
            if (doCheck && !SessionServlet.isWhitelistedFromIPCheck(actual, ranges) && !SessionServlet.isWhitelistedClient(session, whitelist) && !allowedSubnet.areInSameSubnet(actual, session.getLocalIp())) {
                if (INFO) {
                    StringBuilder sb = new StringBuilder(96);
                    sb.append("Request to server denied (IP check activated) for session: ");
                    sb.append(session.getSessionID());
                    sb.append(". Client login IP changed from ");
                    sb.append(session.getLocalIp());
                    sb.append(" to ");
                    sb.append(null == actual ? "<missing>" : actual);
                    sb.append(" and is not covered by IP white-list or netmask.");
                    LOG.info((Object)sb.toString());
                }
                throw SessionExceptionCodes.WRONG_CLIENT_IP.create();
            }
            if (null != actual && (!doCheck || SessionServlet.isWhitelistedClient(session, whitelist))) {
                session.setLocalIp(actual);
            }
            if (DEBUG && !SessionServlet.isWhitelistedFromIPCheck(actual, ranges) && !SessionServlet.isWhitelistedClient(session, whitelist)) {
                StringBuilder sb = new StringBuilder(64);
                sb.append("Session ");
                sb.append(session.getSessionID());
                sb.append(" requests now from ");
                sb.append(actual);
                sb.append(" but login came from ");
                sb.append(session.getLocalIp());
                LOG.debug((Object)sb.toString());
            }
        }
    }

    private static boolean isWhitelistedClient(Session session, ClientWhitelist whitelist) {
        return null != whitelist && !whitelist.isEmpty() && whitelist.isAllowed(session.getClient());
    }

    public static boolean isWhitelistedFromIPCheck(String actual, List<IPRange> ranges) {
        for (IPRange range : ranges) {
            if (!range.contains(actual)) continue;
            return true;
        }
        return false;
    }

    protected static String getSessionId(ServletRequest req) throws OXException {
        String retval = req.getParameter("session");
        if (null == retval) {
            if (INFO) {
                StringBuilder sb = new StringBuilder(32);
                sb.append("Parameter \"").append("session").append("\" not found");
                if (DEBUG) {
                    sb.append(": ");
                    Enumeration enm = req.getParameterNames();
                    while (enm.hasMoreElements()) {
                        sb.append(enm.nextElement());
                        sb.append(',');
                    }
                    if (sb.length() > 0) {
                        sb.setCharAt(sb.length() - 1, '.');
                    }
                }
                LOG.info((Object)sb.toString());
            }
            throw SessionExceptionCodes.SESSION_PARAMETER_MISSING.create();
        }
        return retval;
    }

    public ServerSession getSession(HttpServletRequest req, String sessionId, SessiondService sessiondService) throws OXException {
        return SessionServlet.getSession(hashSource, req, sessionId, sessiondService);
    }

    public static ServerSession getSession(CookieHashSource source, HttpServletRequest req, String sessionId, SessiondService sessiondService) throws OXException {
        return SessionServlet.getSession(source, req, sessionId, sessiondService, null);
    }

    public static ServerSession getSession(CookieHashSource source, HttpServletRequest req, String sessionId, SessiondService sessiondService, SessionSecretChecker optChecker) throws OXException {
        Session session = sessiondService.getSession(sessionId);
        if (null == session) {
            if (INFO) {
                LOG.info((Object)("There is no session associated with session identifier: " + sessionId));
            }
            throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
        }
        LogProperties.putSessionProperties((Session)session);
        if (null == optChecker) {
            SessionServlet.checkSecret(source, req, session);
        } else {
            optChecker.checkSecret(session, req, source.name());
        }
        try {
            Context context = ContextStorage.getInstance().getContext(session.getContextId());
            User user = UserStorage.getInstance().getUser(session.getUserId(), context);
            if (!user.isMailEnabled()) {
                if (INFO) {
                    LOG.info((Object)("User " + user.getId() + " in context " + context.getContextId() + " is not activated."));
                }
                throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{session.getSessionID()});
            }
            return ServerSessionAdapter.valueOf(session, context, user);
        }
        catch (OXException e) {
            if (ContextExceptionCodes.NOT_FOUND.equals(e)) {
                sessiondService.removeSession(sessionId);
                if (INFO) {
                    LOG.info((Object)("The context associated with session \"" + sessionId + "\" cannot be found. Obviously an outdated session which is invalidated now."));
                }
                throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
            }
            if (UserExceptionCode.USER_NOT_FOUND.getPrefix().equals(e.getPrefix())) {
                int code = e.getCode();
                if (UserExceptionCode.USER_NOT_FOUND.getNumber() == code || LdapExceptionCode.USER_NOT_FOUND.getNumber() == code) {
                    sessiondService.removeSession(sessionId);
                    if (INFO) {
                        LOG.info((Object)("The user associated with session \"" + sessionId + "\" cannot be found. Obviously an outdated session which is invalidated now."));
                    }
                    throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
                }
            }
            throw e;
        }
        catch (UndeclaredThrowableException e) {
            throw UserExceptionCode.USER_NOT_FOUND.create(e, Autoboxing.I((int)session.getUserId()), Autoboxing.I((int)session.getContextId()));
        }
    }

    public static void checkSecret(CookieHashSource source, HttpServletRequest req, Session session) throws OXException {
        String secret = SessionServlet.extractSecret(source, req, session.getHash(), session.getClient(), (String)session.getParameter("user-agent"));
        if (secret == null || !session.getSecret().equals(secret)) {
            if (INFO && null != secret) {
                LOG.info((Object)("Session secret is different. Given secret \"" + secret + "\" differs from secret in session \"" + session.getSecret() + "\"."));
            }
            OXException oxe = SessionExceptionCodes.WRONG_SESSION_SECRET.create();
            oxe.setProperty(SessionExceptionCodes.WRONG_SESSION_SECRET.name(), null == secret ? "null" : secret);
            throw oxe;
        }
    }

    public static String extractSecret(CookieHashSource cookieHash, HttpServletRequest req, String hash, String client) {
        return SessionServlet.extractSecret(cookieHash, req, hash, client, null);
    }

    public static String extractSecret(CookieHashSource cookieHash, HttpServletRequest req, String hash, String client, String originalUserAgent) {
        Cookie[] cookies = req.getCookies();
        if (null != cookies) {
            BrowserDetector browserDetector;
            String cookieName = Login.SECRET_PREFIX + SessionServlet.getHash(cookieHash, req, hash, client);
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
            String userAgent = req.getHeader("User-Agent");
            if (null != userAgent && null != originalUserAgent && (browserDetector = new BrowserDetector(originalUserAgent)).isSafari() && SessionServlet.toLowerCase(userAgent).startsWith("applecoremedia/")) {
                cookieName = Login.SECRET_PREFIX + hash;
                for (Cookie cookie : cookies) {
                    if (!cookieName.equals(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            if (INFO) {
                LOG.info((Object)("Didn't find an appropriate Cookie for name \"" + cookieName + "\" (CookieHashSource=" + cookieHash.toString() + ") which provides the session secret."));
            }
        } else if (INFO) {
            LOG.info((Object)"Missing Cookies in HTTP request. No session secret can be looked up.");
        }
        return null;
    }

    public static String getHash(CookieHashSource cookieHash, HttpServletRequest req, String hash, String client) {
        if (CookieHashSource.REMEMBER == cookieHash) {
            return hash;
        }
        return HashCalculator.getInstance().getHash(req, client);
    }

    public static void rememberSession(HttpServletRequest req, ServerSession session) {
        req.setAttribute(SESSION_KEY, (Object)session);
        session.setParameter("JSESSIONID", req.getSession().getId());
    }

    public static void rememberPublicSession(HttpServletRequest req, ServerSession session) {
        req.setAttribute(PUBLIC_SESSION_KEY, (Object)session);
        session.setParameter("JSESSIONID", req.getSession().getId());
    }

    public static void removeOXCookies(String hash, HttpServletRequest req, HttpServletResponse resp) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return;
        }
        List<String> cookieNames = Arrays.asList(Login.SESSION_PREFIX + hash, Login.SECRET_PREFIX + hash, Login.PUBLIC_SESSION_NAME);
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            for (String string : cookieNames) {
                if (!name.startsWith(string)) continue;
                String value = cookie.getValue();
                Cookie respCookie = new Cookie(name, value);
                respCookie.setPath("/");
                String domain = Cookies.getDomainValue(req.getServerName());
                if (null != domain) {
                    respCookie.setDomain(domain);
                    Cookie respCookie2 = new Cookie(name, value);
                    respCookie2.setPath("/");
                    respCookie2.setMaxAge(0);
                    resp.addCookie(respCookie2);
                }
                respCookie.setMaxAge(0);
                resp.addCookie(respCookie);
            }
        }
    }

    public static void removeJSESSIONID(HttpServletRequest req, HttpServletResponse resp) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            String name = cookie.getName();
            if (!"JSESSIONID".equals(name)) continue;
            String value = cookie.getValue();
            Cookie respCookie = new Cookie(name, value);
            respCookie.setPath("/");
            String domain = Cookies.extractDomainValue(value);
            if (null != domain) {
                respCookie.setDomain(domain);
                Cookie respCookie2 = new Cookie(name, value);
                respCookie2.setPath("/");
                respCookie2.setMaxAge(0);
                resp.addCookie(respCookie2);
            }
            respCookie.setMaxAge(0);
            resp.addCookie(respCookie);
        }
    }

    protected static ServerSession getSessionObject(ServletRequest req) {
        return SessionServlet.getSessionObject(req, false);
    }

    protected static ServerSession getSessionObject(ServletRequest req, boolean mayUseFallbackSession) {
        Object attribute = req.getAttribute(SESSION_KEY);
        if (attribute != null) {
            return (ServerSession)attribute;
        }
        if (mayUseFallbackSession) {
            return (ServerSession)req.getAttribute(PUBLIC_SESSION_KEY);
        }
        Props props = LogProperties.optLogProperties();
        if (null != props) {
            String queryString;
            HttpServletRequest httpRequest = (HttpServletRequest)req;
            props.put(LogProperties.Name.SERVLET_SERVLET_PATH, (Object)ForceLog.valueOf((Object)httpRequest.getServletPath()));
            String pathInfo = httpRequest.getPathInfo();
            if (null != pathInfo) {
                props.put(LogProperties.Name.SERVLET_PATH_INFO, (Object)ForceLog.valueOf((Object)pathInfo));
            }
            if (null != (queryString = httpRequest.getQueryString())) {
                props.put(LogProperties.Name.SERVLET_QUERY_STRING, (Object)ForceLog.valueOf((Object)queryString));
            }
        }
        return null;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    static {
        RANGE_LOCK = new ReentrantLock();
    }
}

