/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java.forkjoin;

import com.openexchange.java.forkjoin.ForkJoinPool;
import com.openexchange.java.forkjoin.ForkJoinTask;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import sun.misc.Unsafe;

public class ForkJoinWorkerThread
extends Thread {
    private static final int SMASK = 65535;
    private static final int INITIAL_QUEUE_CAPACITY = 8192;
    private static final int MAXIMUM_QUEUE_CAPACITY = 0x1000000;
    ForkJoinTask<?>[] queue;
    final ForkJoinPool pool;
    int queueTop;
    volatile int queueBase;
    int stealHint;
    final int poolIndex;
    int nextWait;
    volatile int eventCount;
    int seed;
    int stealCount;
    volatile boolean terminate;
    volatile boolean parked;
    final boolean locallyFifo;
    ForkJoinTask<?> currentSteal;
    ForkJoinTask<?> currentJoin;
    private static final int MAX_HELP = 16;
    private static final Unsafe UNSAFE;
    private static final long ABASE;
    private static final int ASHIFT;

    protected ForkJoinWorkerThread(ForkJoinPool pool) {
        super(pool.nextWorkerName());
        int k;
        this.pool = pool;
        this.poolIndex = k = pool.registerWorker(this);
        this.eventCount = ~k & 0xFFFF;
        this.locallyFifo = pool.locallyFifo;
        Thread.UncaughtExceptionHandler ueh = pool.ueh;
        if (ueh != null) {
            this.setUncaughtExceptionHandler(ueh);
        }
        this.setDaemon(true);
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.poolIndex;
    }

    private int nextSeed() {
        int r = this.seed;
        r ^= r << 13;
        r ^= r >>> 17;
        r ^= r << 5;
        this.seed = r;
        return this.seed;
    }

    protected void onStart() {
        this.queue = new ForkJoinTask[8192];
        int r = ForkJoinPool.workerSeedGenerator.nextInt();
        this.seed = r == 0 ? 1 : r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTermination(Throwable exception) {
        try {
            this.terminate = true;
            this.cancelTasks();
            this.pool.deregisterWorker(this, exception);
        }
        catch (Throwable ex) {
            if (exception == null) {
                exception = ex;
            }
        }
        finally {
            if (exception != null) {
                UNSAFE.throwException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable exception = null;
        try {
            this.onStart();
            this.pool.work(this);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        finally {
            this.onTermination(exception);
        }
    }

    private static final boolean casSlotNull(ForkJoinTask<?>[] q, int i, ForkJoinTask<?> t) {
        return UNSAFE.compareAndSwapObject(q, (long)(i << ASHIFT) + ABASE, t, null);
    }

    private static final void writeSlot(ForkJoinTask<?>[] q, int i, ForkJoinTask<?> t) {
        UNSAFE.putObjectVolatile(q, (long)(i << ASHIFT) + ABASE, t);
    }

    final void pushTask(ForkJoinTask<?> t) {
        ForkJoinTask<?>[] q = this.queue;
        if (this.queue != null) {
            int s = this.queueTop;
            int m = q.length - 1;
            long u = (long)((s & m) << ASHIFT) + ABASE;
            UNSAFE.putOrderedObject(q, u, t);
            this.queueTop = s + 1;
            if ((s -= this.queueBase) <= 2) {
                this.pool.signalWork();
            } else if (s == m) {
                this.growQueue();
            }
        }
    }

    private void growQueue() {
        int oldMask;
        int size;
        ForkJoinTask<?>[] oldQ = this.queue;
        int n = size = oldQ != null ? oldQ.length << 1 : 8192;
        if (size > 0x1000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        if (size < 8192) {
            size = 8192;
        }
        this.queue = new ForkJoinTask[size];
        ForkJoinTask[] q = this.queue;
        int mask = size - 1;
        int top = this.queueTop;
        if (oldQ != null && (oldMask = oldQ.length - 1) >= 0) {
            for (int b = this.queueBase; b != top; ++b) {
                long u = (long)((b & oldMask) << ASHIFT) + ABASE;
                Object x = UNSAFE.getObjectVolatile(oldQ, u);
                if (x == null || !UNSAFE.compareAndSwapObject(oldQ, u, x, null)) continue;
                UNSAFE.putObjectVolatile(q, (long)((b & mask) << ASHIFT) + ABASE, x);
            }
        }
    }

    final ForkJoinTask<?> deqTask() {
        int b = this.queueBase;
        if (this.queueTop != b) {
            ForkJoinTask<?> t;
            int i;
            ForkJoinTask<?>[] q = this.queue;
            if (this.queue != null && (i = q.length - 1 & b) >= 0 && (t = q[i]) != null && this.queueBase == b && UNSAFE.compareAndSwapObject(q, (long)(i << ASHIFT) + ABASE, t, null)) {
                this.queueBase = b + 1;
                return t;
            }
        }
        return null;
    }

    final ForkJoinTask<?> locallyDeqTask() {
        int m;
        ForkJoinTask<?>[] q = this.queue;
        if (q != null && (m = q.length - 1) >= 0) {
            int b;
            while (this.queueTop != (b = this.queueBase)) {
                int i = m & b;
                ForkJoinTask<?> t = q[i];
                if (t == null || this.queueBase != b || !UNSAFE.compareAndSwapObject(q, (long)(i << ASHIFT) + ABASE, t, null)) continue;
                this.queueBase = b + 1;
                return t;
            }
        }
        return null;
    }

    private ForkJoinTask<?> popTask() {
        int m;
        ForkJoinTask<?>[] q = this.queue;
        if (q != null && (m = q.length - 1) >= 0) {
            int s;
            while ((s = this.queueTop) != this.queueBase) {
                int i = m & --s;
                long u = (long)(i << ASHIFT) + ABASE;
                ForkJoinTask<?> t = q[i];
                if (t == null) break;
                if (!UNSAFE.compareAndSwapObject(q, u, t, null)) continue;
                this.queueTop = s;
                return t;
            }
        }
        return null;
    }

    final boolean unpushTask(ForkJoinTask<?> t) {
        int s;
        ForkJoinTask<?>[] q = this.queue;
        if (this.queue != null && (s = this.queueTop) != this.queueBase && UNSAFE.compareAndSwapObject(q, (long)((q.length - 1 & --s) << ASHIFT) + ABASE, t, null)) {
            this.queueTop = s;
            return true;
        }
        return false;
    }

    final ForkJoinTask<?> peekTask() {
        int m;
        ForkJoinTask<?>[] q = this.queue;
        if (q == null || (m = q.length - 1) < 0) {
            return null;
        }
        int i = this.locallyFifo ? this.queueBase : this.queueTop - 1;
        return q[i & m];
    }

    final void execTask(ForkJoinTask<?> t) {
        this.currentSteal = t;
        while (true) {
            if (t != null) {
                t.doExec();
            }
            if (this.queueTop == this.queueBase) break;
            t = this.locallyFifo ? this.locallyDeqTask() : this.popTask();
        }
        ++this.stealCount;
        this.currentSteal = null;
    }

    final void cancelTasks() {
        ForkJoinTask<?> cs;
        ForkJoinTask<?> cj = this.currentJoin;
        if (cj != null && cj.status >= 0) {
            cj.cancelIgnoringExceptions();
        }
        if ((cs = this.currentSteal) != null && cs.status >= 0) {
            cs.cancelIgnoringExceptions();
        }
        while (this.queueBase != this.queueTop) {
            ForkJoinTask<?> t = this.deqTask();
            if (t == null) continue;
            t.cancelIgnoringExceptions();
        }
    }

    final int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int n = 0;
        while (this.queueBase != this.queueTop) {
            ForkJoinTask<?> t = this.deqTask();
            if (t == null) continue;
            c.add(t);
            ++n;
        }
        return n;
    }

    final int getQueueSize() {
        return this.queueTop - this.queueBase;
    }

    final ForkJoinTask<?> pollLocalTask() {
        return this.locallyFifo ? this.locallyDeqTask() : this.popTask();
    }

    final ForkJoinTask<?> pollTask() {
        ForkJoinWorkerThread[] ws;
        ForkJoinTask<?> t;
        block6: {
            block5: {
                t = this.pollLocalTask();
                if (t != null) break block5;
                ws = this.pool.workers;
                if (this.pool.workers != null) break block6;
            }
            return t;
        }
        int n = ws.length;
        int steps = n << 1;
        int r = this.nextSeed();
        int i = 0;
        while (i < steps) {
            ForkJoinWorkerThread w;
            if ((w = ws[i++ + r & n - 1]) == null || w.queueBase == w.queueTop || w.queue == null) continue;
            t = w.deqTask();
            if (t != null) {
                return t;
            }
            i = 0;
        }
        return null;
    }

    final int joinTask(ForkJoinTask<?> joinMe) {
        ForkJoinTask<?> prevJoin = this.currentJoin;
        this.currentJoin = joinMe;
        int retries = 16;
        while (true) {
            int s;
            if ((s = joinMe.status) < 0) {
                this.currentJoin = prevJoin;
                return s;
            }
            if (retries > 0) {
                if (this.queueTop != this.queueBase) {
                    if (this.localHelpJoinTask(joinMe)) continue;
                    retries = 0;
                    continue;
                }
                if (retries == 8) {
                    --retries;
                    if (this.tryDeqAndExec(joinMe) < 0) continue;
                    Thread.yield();
                    continue;
                }
                retries = this.helpJoinTask(joinMe) ? 16 : retries - 1;
                continue;
            }
            retries = 16;
            this.pool.tryAwaitJoin(joinMe);
        }
    }

    private boolean localHelpJoinTask(ForkJoinTask<?> joinMe) {
        int s = this.queueTop;
        if (s != this.queueBase) {
            ForkJoinTask<?> t;
            int i;
            ForkJoinTask<?>[] q = this.queue;
            if (this.queue != null && (i = q.length - 1 & --s) >= 0 && (t = q[i]) != null) {
                if (t != joinMe && t.status >= 0) {
                    return false;
                }
                if (UNSAFE.compareAndSwapObject(q, (long)(i << ASHIFT) + ABASE, t, null)) {
                    this.queueTop = s;
                    t.doExec();
                }
            }
        }
        return true;
    }

    private boolean helpJoinTask(ForkJoinTask<?> joinMe) {
        boolean helped = false;
        int m = this.pool.scanGuard & 0xFFFF;
        ForkJoinWorkerThread[] ws = this.pool.workers;
        if (ws != null && ws.length > m && joinMe.status >= 0) {
            int levels = 16;
            ForkJoinTask<?> task = joinMe;
            ForkJoinWorkerThread thread = this;
            block0: while (true) {
                ForkJoinWorkerThread v;
                block7: {
                    if ((v = ws[thread.stealHint & m]) == null || v.currentSteal != task) {
                        int j = 0;
                        do {
                            if ((v = ws[j]) == null || v.currentSteal != task) continue;
                            thread.stealHint = j;
                            break block7;
                        } while (++j <= m);
                        break;
                    }
                }
                while (joinMe.status >= 0) {
                    int b = v.queueBase;
                    if (b != v.queueTop) {
                        int i;
                        ForkJoinTask<?>[] q = v.queue;
                        if (v.queue != null && (i = q.length - 1 & b) >= 0) {
                            long u = (long)(i << ASHIFT) + ABASE;
                            ForkJoinTask<?> t = q[i];
                            if (task.status < 0) break block0;
                            if (t == null || v.queueBase != b || !UNSAFE.compareAndSwapObject(q, u, t, null)) continue;
                            v.queueBase = b + 1;
                            v.stealHint = this.poolIndex;
                            ForkJoinTask<?> ps = this.currentSteal;
                            this.currentSteal = t;
                            t.doExec();
                            this.currentSteal = ps;
                            helped = true;
                            continue;
                        }
                    }
                    ForkJoinTask<?> next = v.currentJoin;
                    if (--levels <= 0 || task.status < 0 || next == null || next == task) break block0;
                    task = next;
                    thread = v;
                    continue block0;
                }
                break;
            }
        }
        return helped;
    }

    private int tryDeqAndExec(ForkJoinTask<?> t) {
        int m = this.pool.scanGuard & 0xFFFF;
        ForkJoinWorkerThread[] ws = this.pool.workers;
        if (ws != null && ws.length > m && t.status >= 0) {
            for (int j = 0; j <= m; ++j) {
                int i;
                int b;
                ForkJoinWorkerThread v = ws[j];
                if (v == null || (b = v.queueBase) == v.queueTop) continue;
                ForkJoinTask<?>[] q = v.queue;
                if (v.queue == null || (i = q.length - 1 & b) < 0 || q[i] != t) continue;
                long u = (long)(i << ASHIFT) + ABASE;
                if (v.queueBase != b || !UNSAFE.compareAndSwapObject(q, u, t, null)) break;
                v.queueBase = b + 1;
                v.stealHint = this.poolIndex;
                ForkJoinTask<?> ps = this.currentSteal;
                this.currentSteal = t;
                t.doExec();
                this.currentSteal = ps;
                break;
            }
        }
        return t.status;
    }

    final int getEstimatedSurplusTaskCount() {
        return this.queueTop - this.queueBase - this.pool.idlePerActive();
    }

    final void helpQuiescePool() {
        boolean active = true;
        ForkJoinTask<?> ps = this.currentSteal;
        ForkJoinPool p = this.pool;
        p.addQuiescerCount(1);
        while (true) {
            int n;
            ForkJoinWorkerThread[] ws = p.workers;
            ForkJoinWorkerThread v = null;
            if (this.queueTop != this.queueBase) {
                v = this;
            } else if (ws != null && (n = ws.length) > 1) {
                int r = this.nextSeed();
                int steps = n << 1;
                for (int i = 0; i < steps; ++i) {
                    ForkJoinWorkerThread w = ws[i + r & n - 1];
                    if (w == null || w.queueBase == w.queueTop) continue;
                    v = w;
                    break;
                }
            }
            if (v != null) {
                ForkJoinTask<?> t;
                if (!active) {
                    active = true;
                    p.addActiveCount(1);
                }
                if ((v != this ? v.deqTask() : (t = this.locallyFifo ? this.locallyDeqTask() : this.popTask())) == null) continue;
                this.currentSteal = t;
                t.doExec();
                this.currentSteal = ps;
                continue;
            }
            if (active) {
                active = false;
                p.addActiveCount(-1);
            }
            if (p.isQuiescent()) break;
        }
        p.addActiveCount(1);
        p.addQuiescerCount(-1);
    }

    static {
        int s;
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<ForkJoinTask[]> a = ForkJoinTask[].class;
            ABASE = UNSAFE.arrayBaseOffset(a);
            s = UNSAFE.arrayIndexScale(a);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if ((s & s - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(s);
    }
}

