/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Streams;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public final class CharsetDetector {
    private static final Log LOG = LogFactory.getLog(CharsetDetector.class);
    private static final String STR_US_ASCII = "US-ASCII";
    private static final String FALLBACK = "ISO-8859-1";

    private CharsetDetector() {
    }

    public static String getFallback() {
        return FALLBACK;
    }

    public static boolean isValid(String charset) {
        try {
            return null != charset && CharsetDetector.checkName(charset) && Charset.isSupported(charset);
        }
        catch (RuntimeException rte) {
            LOG.warn((Object)("RuntimeException while checking charset: " + charset), (Throwable)rte);
            return false;
        }
        catch (Error e) {
            CharsetDetector.handleThrowable(e);
            LOG.warn((Object)("Error while checking charset: " + charset), (Throwable)e);
            return false;
        }
        catch (Throwable t) {
            CharsetDetector.handleThrowable(t);
            LOG.warn((Object)("Unexpected error while checking charset: " + charset), t);
            return false;
        }
    }

    private static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            LOG.fatal((Object)" ---=== /!\\ ===--- Thread death ---=== /!\\ ===--- ", t);
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            LOG.fatal((Object)" ---=== /!\\ ===--- The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating. ---=== /!\\ ===--- ", t);
            throw (VirtualMachineError)t;
        }
    }

    public static boolean checkName(String s) {
        if (s == null) {
            throw new NullPointerException("name is null");
        }
        int n = s.length();
        if (n == 0) {
            return false;
        }
        boolean legal = true;
        for (int i = 0; legal && i < n; ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == ':' || c == '_' || c == '.') continue;
            legal = false;
        }
        return legal;
    }

    public static String detectPartCharset(Part p) throws MessagingException {
        try {
            return CharsetDetector.detectCharset(p.getInputStream());
        }
        catch (IOException e) {
            InputStream rawIn;
            if (p instanceof MimeBodyPart) {
                rawIn = ((MimeBodyPart)p).getRawInputStream();
            } else if (p instanceof MimeMessage) {
                rawIn = ((MimeMessage)p).getRawInputStream();
            } else {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                return FALLBACK;
            }
            return CharsetDetector.detectCharset(rawIn);
        }
    }

    public static String detectCharset(byte[] in) {
        return CharsetDetector.detectCharset(in, in.length);
    }

    public static String detectCharset(byte[] in, int len) {
        if (null == in) {
            throw new NullPointerException("byte array input stream is null");
        }
        nsDetector det = new nsDetector(0);
        CharsetDetectionObserver observer = new CharsetDetectionObserver();
        det.Init((nsICharsetDetectionObserver)observer);
        boolean isAscii = det.isAscii(in, len);
        if (!isAscii) {
            det.DoIt(in, len, false);
        }
        det.DataEnd();
        if (isAscii) {
            return STR_US_ASCII;
        }
        String charset = observer.getCharset();
        if (null != charset && Charset.isSupported(charset)) {
            return charset;
        }
        String[] prob = det.getProbableCharsets();
        String firstPossibleCharset = null;
        for (int i = 0; i < prob.length; ++i) {
            if (!Charset.isSupported(prob[i])) continue;
            if ("utf-8".equals(prob[i].toLowerCase(Locale.ENGLISH))) {
                return prob[i];
            }
            if ("windows-1252".equals(prob[i].toLowerCase(Locale.ENGLISH))) {
                return prob[i];
            }
            if (null != firstPossibleCharset) continue;
            firstPossibleCharset = prob[i];
        }
        return null == firstPossibleCharset ? FALLBACK : firstPossibleCharset;
    }

    public static String detectCharset(ByteArrayInputStream in) {
        int len;
        if (null == in) {
            throw new NullPointerException("byte array input stream is null");
        }
        nsDetector det = new nsDetector(0);
        CharsetDetectionObserver observer = new CharsetDetectionObserver();
        det.Init((nsICharsetDetectionObserver)observer);
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = true;
        while ((len = in.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (isAscii || done) continue;
            done = det.DoIt(buf, len, false);
        }
        det.DataEnd();
        if (isAscii) {
            return STR_US_ASCII;
        }
        String charset = observer.getCharset();
        if (null != charset && Charset.isSupported(charset)) {
            return charset;
        }
        String[] prob = det.getProbableCharsets();
        String firstPossibleCharset = null;
        for (int i = 0; i < prob.length; ++i) {
            if (!Charset.isSupported(prob[i])) continue;
            if ("utf-8".equals(prob[i].toLowerCase(Locale.ENGLISH))) {
                return prob[i];
            }
            if ("windows-1252".equals(prob[i].toLowerCase(Locale.ENGLISH))) {
                return prob[i];
            }
            if (null != firstPossibleCharset) continue;
            firstPossibleCharset = prob[i];
        }
        return null == firstPossibleCharset ? FALLBACK : firstPossibleCharset;
    }

    public static String detectCharset(InputStream in) {
        try {
            return CharsetDetector.detectCharsetFailOnError(in);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return FALLBACK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectCharsetFailOnError(InputStream in) throws IOException {
        if (null == in) {
            throw new NullPointerException("input stream is null");
        }
        nsDetector det = new nsDetector(0);
        CharsetDetectionObserver observer = new CharsetDetectionObserver();
        det.Init((nsICharsetDetectionObserver)observer);
        try {
            int len;
            byte[] buf = new byte[1024];
            boolean done = false;
            boolean isAscii = true;
            while ((len = in.read(buf, 0, buf.length)) > 0) {
                if (isAscii) {
                    isAscii = det.isAscii(buf, len);
                }
                if (isAscii || done) continue;
                done = det.DoIt(buf, len, false);
            }
            det.DataEnd();
            if (isAscii) {
                String string = STR_US_ASCII;
                return string;
            }
            String charset = observer.getCharset();
            if (null != charset && Charset.isSupported(charset)) {
                String string = charset;
                return string;
            }
            String[] prob = det.getProbableCharsets();
            String firstPossibleCharset = null;
            for (int i = 0; i < prob.length; ++i) {
                String lcs = prob[i].toLowerCase(Locale.US);
                if (Charset.isSupported(lcs)) {
                    if ("utf-8".equals(lcs)) {
                        String string = prob[i];
                        return string;
                    }
                    if ("windows-1252".equals(lcs)) {
                        String string = prob[i];
                        return string;
                    }
                    if (null != firstPossibleCharset) continue;
                    firstPossibleCharset = prob[i];
                    continue;
                }
                if (!"nomatch".equals(lcs)) continue;
                String string = FALLBACK;
                return string;
            }
            String string = null == firstPossibleCharset ? FALLBACK : firstPossibleCharset;
            return string;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    private static final class CharsetDetectionObserver
    implements nsICharsetDetectionObserver {
        private String charset;

        public void Notify(String charset) {
            this.charset = charset;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

