/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.LogLevelAwareOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ServiceExceptionCode implements LogLevelAwareOXExceptionCode
{
    SERVICE_UNAVAILABLE("The required service %1$s is temporary not available. Please try again later.", Category.CATEGORY_TRY_AGAIN, 1, LogLevel.ERROR),
    IO_ERROR("An I/O error occurred", Category.CATEGORY_ERROR, 2, LogLevel.ERROR),
    SERVICE_INITIALIZATION_FAILED("Service initialization failed", Category.CATEGORY_ERROR, 3, LogLevel.ERROR);

    private static final String PREFIX = "SRV";
    private final String message;
    private final int detailNumber;
    private final Category category;
    private final LogLevel logLevel;

    public static boolean hasPrefix(OXException e) {
        if (null == e) {
            return false;
        }
        return PREFIX.equals(e.getPrefix());
    }

    private ServiceExceptionCode(String message, Category category, int detailNumber, LogLevel logLevel) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.logLevel = logLevel;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public int getNumber() {
        return this.detailNumber;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

