/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.ForceLog;
import com.openexchange.log.Log;
import com.openexchange.log.LogProperties;
import com.openexchange.log.LogPropertyName;
import com.openexchange.log.PropertiesAware;
import com.openexchange.log.Props;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PropertiesAppendingLogWrapper
implements org.apache.commons.logging.Log,
PropertiesAware {
    private final String lineSeparator = System.getProperty("line.separator");
    private final org.apache.commons.logging.Log delegate;
    private final boolean delegateAppending;

    protected PropertiesAppendingLogWrapper(org.apache.commons.logging.Log delegate) {
        this.delegate = delegate;
        this.delegateAppending = delegate instanceof com.openexchange.exception.Log || delegate instanceof Log;
    }

    public void debug(Object message, Throwable t) {
        if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(this.appendProperties(message, LogPropertyName.LogLevel.DEBUG, Thread.currentThread()), t);
        }
    }

    public void debug(Object message) {
        if (this.delegate.isDebugEnabled()) {
            this.delegate.debug(this.appendProperties(message, LogPropertyName.LogLevel.DEBUG, Thread.currentThread()));
        }
    }

    public void error(Object message, Throwable t) {
        if (this.delegate.isErrorEnabled()) {
            this.delegate.error(this.appendProperties(message, LogPropertyName.LogLevel.ERROR, Thread.currentThread()), t);
        }
    }

    public void error(Object message) {
        if (this.delegate.isErrorEnabled()) {
            this.delegate.error(this.appendProperties(message, LogPropertyName.LogLevel.ERROR, Thread.currentThread()));
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.delegate.isFatalEnabled()) {
            this.delegate.fatal(this.appendProperties(message, LogPropertyName.LogLevel.FATAL, Thread.currentThread()), t);
        }
    }

    public void fatal(Object message) {
        if (this.delegate.isFatalEnabled()) {
            this.delegate.fatal(this.appendProperties(message, LogPropertyName.LogLevel.FATAL, Thread.currentThread()));
        }
    }

    public void info(Object message, Throwable t) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(this.appendProperties(message, LogPropertyName.LogLevel.INFO, Thread.currentThread()), t);
        }
    }

    public void info(Object message) {
        if (this.delegate.isInfoEnabled()) {
            this.delegate.info(this.appendProperties(message, LogPropertyName.LogLevel.INFO, Thread.currentThread()));
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(this.appendProperties(message, LogPropertyName.LogLevel.TRACE, Thread.currentThread()), t);
        }
    }

    public void trace(Object message) {
        if (this.delegate.isTraceEnabled()) {
            this.delegate.trace(this.appendProperties(message, LogPropertyName.LogLevel.TRACE, Thread.currentThread()));
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(this.appendProperties(message, LogPropertyName.LogLevel.WARNING, Thread.currentThread()), t);
        }
    }

    public void warn(Object message) {
        if (this.delegate.isWarnEnabled()) {
            this.delegate.warn(this.appendProperties(message, LogPropertyName.LogLevel.WARNING, Thread.currentThread()));
        }
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.delegate.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    protected Object appendProperties(Object message, LogPropertyName.LogLevel logLevel, Thread thread) {
        if (!LogProperties.isEnabled()) {
            return message;
        }
        Props props = LogProperties.optLogProperties(thread);
        if (this.delegateAppending) {
            return new PropertiesAwareMessage(null == message ? "null" : message, logLevel, props, this);
        }
        return this.innerAppendProperties(null == message ? "null" : message, this.getPropertiesFor(logLevel, props), props);
    }

    protected Object innerAppendProperties(Object notNullMessage, Set<LogProperties.Name> propertiesToLog, Props logProps) {
        if (null == propertiesToLog || propertiesToLog.isEmpty()) {
            return notNullMessage;
        }
        if (logProps == null) {
            return notNullMessage;
        }
        Map<LogProperties.Name, Object> properties = logProps.getMap();
        if (properties == null) {
            return notNullMessage;
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        boolean isEmpty = true;
        for (LogProperties.Name propertyName : propertiesToLog) {
            Object value = properties.get((Object)propertyName);
            if (null == value) continue;
            sorted.put(propertyName.getName(), value.toString());
            isEmpty = false;
        }
        StringAllocator sb = new StringAllocator(256);
        if (!isEmpty) {
            String lineSeparator = this.lineSeparator;
            boolean first = true;
            for (Map.Entry entry : sorted.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(lineSeparator);
                }
                sb.append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
            sb.append(lineSeparator).append(lineSeparator);
        }
        sb.append(notNullMessage);
        return sb.toString();
    }

    public Set<LogProperties.Name> getPropertiesFor(LogPropertyName.LogLevel logLevel, Props logProps) {
        if (!LogProperties.isEnabled()) {
            return Collections.emptySet();
        }
        if (logProps == null) {
            return Collections.emptySet();
        }
        Map<LogProperties.Name, Object> properties = logProps.getMap();
        if (properties == null) {
            return Collections.emptySet();
        }
        EnumSet<LogProperties.Name> propertiesToLog = EnumSet.noneOf(LogProperties.Name.class);
        List<LogPropertyName> names = LogProperties.getPropertyNames();
        if (!names.isEmpty()) {
            for (LogPropertyName name : names) {
                if (!name.implies(logLevel)) continue;
                propertiesToLog.add(name.getPropertyName());
            }
        }
        for (Map.Entry<LogProperties.Name, Object> entry : properties.entrySet()) {
            LogProperties.Name propertyName = entry.getKey();
            if (!(entry.getValue() instanceof ForceLog)) continue;
            propertiesToLog.add(propertyName);
        }
        return propertiesToLog;
    }

    private static final class PropertiesAwareMessage
    implements PropertiesAware {
        final Object notNullMessage;
        final PropertiesAppendingLogWrapper appender;
        final Props props;
        final LogPropertyName.LogLevel logLevel;

        PropertiesAwareMessage(Object notNullMessage, LogPropertyName.LogLevel logLevel, Props props, PropertiesAppendingLogWrapper appender) {
            this.notNullMessage = notNullMessage;
            this.appender = appender;
            this.props = props;
            this.logLevel = logLevel;
        }

        public String toString() {
            try {
                return this.appender.innerAppendProperties(this.notNullMessage, this.appender.getPropertiesFor(this.logLevel, this.props), this.props).toString();
            }
            catch (Exception e) {
                return null == this.notNullMessage ? "null" : this.notNullMessage.toString();
            }
        }
    }
}

