/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.fasterxml.jackson.core.io.CharTypes;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class JSONStringOutputStream
extends OutputStream {
    private static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    private static final byte[] HEX_CHARS = CharTypes.copyHexBytes();
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final byte BYTE_u = 117;
    private static final byte BYTE_0 = 48;
    private static final byte BYTE_BACKSLASH = 92;
    private static final int SURR1_FIRST = 55296;
    private static final int SURR2_LAST = 57343;
    private final OutputStream out;

    public JSONStringOutputStream(OutputStream out) {
        this.out = out instanceof BufferedOutputStream || out instanceof ByteArrayOutputStream ? out : new BufferedOutputStream(out, 8184);
    }

    @Override
    public void write(int ch) throws IOException {
        this.writeChar(ch, 127, sOutputEscapes);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int[] escCodes = sOutputEscapes;
        int maxUnescaped = 127;
        int offset = off;
        int end = offset + len;
        int prev = 0;
        while (offset < end) {
            int ch;
            if ((ch = b[offset++]) < 0) {
                if (prev == 0) {
                    prev = ch;
                    continue;
                }
                ch = new String(new byte[]{(byte)prev, (byte)ch}, UTF8_CHARSET).charAt(0);
                prev = 0;
            } else if (prev != 0) {
                this.writeChar(prev, 127, escCodes);
                prev = 0;
            }
            this.writeChar(ch, 127, escCodes);
        }
        if (prev != 0) {
            this.writeChar(prev, 127, escCodes);
            prev = 0;
        }
    }

    private void writeChar(int c, int maxUnescaped, int[] escCodes) throws IOException {
        int ch = c;
        if (ch < 0) {
            ch &= 0xFF;
        }
        if (ch <= 127) {
            if (escCodes[ch] == 0) {
                this.out.write(ch);
                return;
            }
            int escape = escCodes[ch];
            if (escape > 0) {
                this.out.write(92);
                this.out.write((byte)escape);
            } else {
                this._writeGenericEscape(ch);
            }
            return;
        }
        if (ch > maxUnescaped) {
            this._writeGenericEscape(ch);
            return;
        }
        if (ch <= 2047) {
            this.out.write((byte)(0xC0 | ch >> 6));
            this.out.write((byte)(0x80 | ch & 0x3F));
        } else {
            this._outputMultiByteChar(ch);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void _writeGenericEscape(int charToEscape) throws IOException {
        int c = charToEscape;
        this.out.write(92);
        this.out.write(117);
        if (c > 255) {
            int hi = c >> 8 & 0xFF;
            this.out.write(HEX_CHARS[hi >> 4]);
            this.out.write(HEX_CHARS[hi & 0xF]);
            c &= 0xFF;
        } else {
            this.out.write(48);
            this.out.write(48);
        }
        this.out.write(HEX_CHARS[c >> 4]);
        this.out.write(HEX_CHARS[c & 0xF]);
    }

    private void _outputMultiByteChar(int ch) throws IOException {
        if (ch >= 55296 && ch <= 57343) {
            this.out.write(92);
            this.out.write(117);
            this.out.write(HEX_CHARS[ch >> 12 & 0xF]);
            this.out.write(HEX_CHARS[ch >> 8 & 0xF]);
            this.out.write(HEX_CHARS[ch >> 4 & 0xF]);
            this.out.write(HEX_CHARS[ch & 0xF]);
        } else {
            this.out.write((byte)(0xE0 | ch >> 12));
            this.out.write((byte)(0x80 | ch >> 6 & 0x3F));
            this.out.write((byte)(0x80 | ch & 0x3F));
        }
    }
}

