/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONValue;
import org.json.helpers.StringAllocator;
import org.json.helpers.UnsynchronizedByteArrayOutputStream;

public final class JSONInputStream
extends InputStream {
    private static final int BUFSIZE = 8192;
    protected final String charset;
    private final Bufferer bufferer;
    protected int pos;
    protected int count;
    protected boolean finished = false;
    protected boolean first = true;
    protected final UnsynchronizedByteArrayOutputStream out;
    protected InputStream nested;

    public JSONInputStream(JSONValue jsonValue, String charset) {
        this.charset = charset;
        this.out = new UnsynchronizedByteArrayOutputStream(8192);
        if (jsonValue.isArray()) {
            this.bufferer = new ArrayBufferer(jsonValue.toArray().iterator());
            this.out.write(91);
        } else {
            this.bufferer = new ObjectBufferer(jsonValue.toObject().entrySet().iterator());
            this.out.write(123);
        }
        this.count = 1;
        this.pos = 0;
    }

    private boolean hasBytes() {
        return this.pos < this.count || this.nested != null;
    }

    private boolean writeMoreBytes() throws IOException {
        return this.bufferer.writeMoreBytes();
    }

    @Override
    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        if (!this.hasBytes() && !this.writeMoreBytes()) {
            return this.out.getBuf()[this.pos++];
        }
        if (this.pos < this.count) {
            return this.out.getBuf()[this.pos++];
        }
        int read = this.nested.read();
        if (read >= 0) {
            return read;
        }
        this.nested = null;
        return this.read();
    }

    private final class ObjectBufferer
    extends AbstractBufferer {
        private final Iterator<Map.Entry<String, Object>> objIterator;

        ObjectBufferer(Iterator<Map.Entry<String, Object>> objIterator) {
            this.objIterator = objIterator;
        }

        @Override
        public char getClosing() {
            return '}';
        }

        @Override
        public boolean hasNext() {
            return this.objIterator.hasNext();
        }

        @Override
        public Object next() throws IOException {
            Map.Entry<String, Object> entry = this.objIterator.next();
            JSONInputStream.this.out.write(34);
            JSONInputStream.this.out.write(this.toAsciiBytes(entry.getKey()));
            JSONInputStream.this.out.write(34);
            JSONInputStream.this.out.write(58);
            return entry.getValue();
        }
    }

    private final class ArrayBufferer
    extends AbstractBufferer {
        private final Iterator<Object> arrIterator;

        ArrayBufferer(Iterator<Object> arrIterator) {
            this.arrIterator = arrIterator;
        }

        @Override
        public char getClosing() {
            return ']';
        }

        @Override
        public boolean hasNext() {
            return this.arrIterator.hasNext();
        }

        @Override
        public Object next() {
            return this.arrIterator.next();
        }
    }

    private abstract class AbstractBufferer
    implements Bufferer {
        protected AbstractBufferer() {
        }

        @Override
        public boolean writeMoreBytes() throws IOException {
            JSONInputStream.this.out.reset();
            if (!this.hasNext()) {
                JSONInputStream.this.out.write(this.getClosing());
                JSONInputStream.this.count = 1;
                JSONInputStream.this.pos = 0;
                JSONInputStream.this.finished = true;
                JSONInputStream.this.nested = null;
                return false;
            }
            if (JSONInputStream.this.first) {
                JSONInputStream.this.first = false;
            } else {
                JSONInputStream.this.out.write(44);
            }
            this.writeValue(this.next());
            JSONInputStream.this.pos = 0;
            JSONInputStream.this.count = JSONInputStream.this.out.getCount();
            return true;
        }

        private void writeValue(Object value) throws IOException {
            if (value instanceof JSONValue) {
                JSONInputStream.this.nested = new JSONInputStream((JSONValue)value, JSONInputStream.this.charset);
            } else if (value instanceof String) {
                JSONInputStream.this.out.write(34);
                JSONInputStream.this.out.write(this.toAsciiBytes(this.toAscii(value.toString())));
                JSONInputStream.this.out.write(34);
            } else {
                JSONInputStream.this.out.write(this.toAsciiBytes(null == value ? "null" : value.toString()));
            }
        }

        protected byte[] toAsciiBytes(String str) {
            if (null == str) {
                return null;
            }
            int length = str.length();
            if (0 == length) {
                return new byte[0];
            }
            byte[] ret = new byte[length];
            str.getBytes(0, length, ret, 0);
            return ret;
        }

        protected String toAscii(String str) {
            if (null == str) {
                return str;
            }
            int length = str.length();
            if (0 == length || this.isAscii(str, length)) {
                return str;
            }
            StringAllocator sa = new StringAllocator(length * 3 / 2 + 1);
            for (int i = 0; i < length; ++i) {
                char c = str.charAt(i);
                if (c > '\u007f') {
                    this.appendAsJsonUnicode(c, sa);
                    continue;
                }
                sa.append(c);
            }
            return sa.toString();
        }

        private void appendAsJsonUnicode(int ch, StringAllocator sa) {
            sa.append("\\u");
            String hex = Integer.toString(ch, 16);
            for (int i = hex.length(); i < 4; ++i) {
                sa.append('0');
            }
            sa.append(hex);
        }

        private boolean isAscii(String s, int length) {
            boolean isAscci = true;
            for (int i = 0; i < length && isAscci; ++i) {
                isAscci = s.charAt(i) < '\u0080';
            }
            return isAscci;
        }
    }

    private static interface Bufferer {
        public char getClosing();

        public boolean hasNext();

        public Object next() throws IOException;

        public boolean writeMoreBytes() throws IOException;
    }
}

