/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.CharArray;
import org.json.ICharArray;

public final class CharArrayPool {
    private static final AtomicInteger NUMBER_OF_SMALL = new AtomicInteger(100000);
    private static final AtomicInteger NUMBER_OF_MEDIUM = new AtomicInteger(10000);
    private static final AtomicInteger NUMBER_OF_LARGE = new AtomicInteger(1000);
    private static final AtomicInteger LENGTH_OF_SMALL = new AtomicInteger(1024);
    private static final AtomicInteger LENGTH_OF_MEDIUM = new AtomicInteger(102400);
    private static final AtomicInteger LENGTH_OF_LARGE = new AtomicInteger(1024000);
    private static volatile CharArrayPool instance;
    private static final AtomicLong MISSES;
    private final BlockingQueue<CharArray> smallQueue;
    private final BlockingQueue<CharArray> mediumQueue;
    private final BlockingQueue<CharArray> largeQueue;
    private final int lengthOfSmall;
    private final int lengthOfMedium;
    private final int lengthOfLarge;

    public static void setCapacities(int numberOfSmall, int numberOfMedium, int numberOfLarge) {
        if (numberOfSmall < 0 || numberOfMedium < 0 || numberOfLarge < 0) {
            throw new IllegalArgumentException("smallCapacity < 0 OR mediumCapacity < 0 OR largeCapacity < 0: " + Arrays.toString(new int[]{numberOfSmall, numberOfMedium, numberOfLarge}));
        }
        NUMBER_OF_SMALL.set(numberOfSmall);
        NUMBER_OF_MEDIUM.set(numberOfMedium);
        NUMBER_OF_LARGE.set(numberOfLarge);
    }

    public static void setLengths(int lengthOfSmall, int lengthOfMedium, int lengthOfLarge) {
        if (lengthOfSmall < 0 || lengthOfMedium < 0 || lengthOfLarge < 0) {
            throw new IllegalArgumentException("smallSize < 0 OR mediumSize < 0 OR largeSize < 0: " + Arrays.toString(new int[]{lengthOfSmall, lengthOfMedium, lengthOfLarge}));
        }
        if (lengthOfLarge < lengthOfMedium || lengthOfLarge < lengthOfSmall) {
            throw new IllegalArgumentException("largeSize < mediumSize OR largeSize < smallSize: " + Arrays.toString(new int[]{lengthOfSmall, lengthOfMedium, lengthOfLarge}));
        }
        if (lengthOfMedium < lengthOfSmall) {
            throw new IllegalArgumentException("mediumSize < largeSize: " + Arrays.toString(new int[]{lengthOfSmall, lengthOfMedium, lengthOfLarge}));
        }
        LENGTH_OF_SMALL.set(lengthOfSmall);
        LENGTH_OF_MEDIUM.set(lengthOfMedium);
        LENGTH_OF_LARGE.set(lengthOfLarge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static CharArrayPool getInstance() {
        CharArrayPool tmp = instance;
        if (null != tmp) return tmp;
        Class<CharArrayPool> clazz = CharArrayPool.class;
        synchronized (CharArrayPool.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            instance = tmp = new CharArrayPool(LENGTH_OF_SMALL.get(), LENGTH_OF_MEDIUM.get(), LENGTH_OF_LARGE.get());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static long getMisses() {
        return MISSES.get();
    }

    public static int getTotal(Part part) {
        if (null == instance) {
            return 0;
        }
        if (Part.SMALL.equals((Object)part)) {
            return NUMBER_OF_SMALL.get();
        }
        if (Part.MEDIUM.equals((Object)part)) {
            return NUMBER_OF_MEDIUM.get();
        }
        return NUMBER_OF_LARGE.get();
    }

    public static int getInUse(Part part) {
        CharArrayPool tmp = instance;
        if (null == tmp) {
            return 0;
        }
        if (Part.SMALL.equals((Object)part)) {
            return NUMBER_OF_SMALL.get() - tmp.smallQueue.size();
        }
        if (Part.MEDIUM.equals((Object)part)) {
            return NUMBER_OF_MEDIUM.get() - tmp.mediumQueue.size();
        }
        return NUMBER_OF_LARGE.get() - tmp.largeQueue.size();
    }

    public static int getPooled(Part part) {
        CharArrayPool tmp = instance;
        if (null == tmp) {
            return 0;
        }
        if (Part.SMALL.equals((Object)part)) {
            return tmp.smallQueue.size();
        }
        if (Part.MEDIUM.equals((Object)part)) {
            return tmp.mediumQueue.size();
        }
        return tmp.largeQueue.size();
    }

    private CharArrayPool(int lengthOfSmall, int lengthOfMedium, int lengthOfLarge) {
        this.lengthOfSmall = lengthOfSmall;
        this.lengthOfMedium = lengthOfMedium;
        this.lengthOfLarge = lengthOfLarge;
        class QueueCreator {
            QueueCreator() {
            }

            BlockingQueue<CharArray> newQueue(int numberOfArrays, int lengthOfArrays) {
                if (numberOfArrays <= 0 || lengthOfArrays <= 0) {
                    return null;
                }
                ArrayBlockingQueue<CharArray> q = new ArrayBlockingQueue<CharArray>(numberOfArrays);
                for (int i = 0; i < numberOfArrays; ++i) {
                    q.offer(new CharArray(lengthOfArrays));
                }
                return q;
            }
        }
        QueueCreator qr = new QueueCreator();
        this.smallQueue = qr.newQueue(NUMBER_OF_SMALL.get(), lengthOfSmall);
        this.mediumQueue = qr.newQueue(NUMBER_OF_MEDIUM.get(), lengthOfMedium);
        this.largeQueue = qr.newQueue(NUMBER_OF_LARGE.get(), lengthOfLarge);
    }

    protected int getCharArrayLength(int capacity) {
        if (capacity <= this.lengthOfSmall) {
            return this.lengthOfSmall;
        }
        if (capacity <= this.lengthOfMedium) {
            return this.lengthOfMedium;
        }
        if (capacity <= this.lengthOfLarge) {
            return this.lengthOfLarge;
        }
        return capacity;
    }

    protected int getSmallLength() {
        return this.lengthOfSmall;
    }

    protected int getMediumLength() {
        return this.lengthOfMedium;
    }

    protected int getLargeLength() {
        return this.lengthOfLarge;
    }

    protected ICharArray getSmallCharArray() {
        return this.getCharArrayFor(Part.SMALL);
    }

    protected ICharArray getMediumCharArray() {
        return this.getCharArrayFor(Part.MEDIUM);
    }

    protected ICharArray getLargeCharArray() {
        return this.getCharArrayFor(Part.LARGE);
    }

    protected ICharArray getCharArrayFor(Part part) {
        ICharArray ret = null;
        switch (part) {
            case SMALL: {
                ret = (ICharArray)this.smallQueue.poll();
                if (null != ret) {
                    return ret;
                }
            }
            case MEDIUM: {
                ret = (ICharArray)this.mediumQueue.poll();
                if (null != ret) {
                    return ret;
                }
            }
            case LARGE: {
                ret = (ICharArray)this.largeQueue.poll();
                if (null == ret) break;
                return ret;
            }
        }
        MISSES.incrementAndGet();
        return ret;
    }

    protected CharArray getCharArrayFor(int capacity) {
        CharArray ret = null;
        if (capacity <= this.lengthOfSmall && null != (ret = (CharArray)this.smallQueue.poll())) {
            return ret;
        }
        if (capacity <= this.lengthOfMedium && null != (ret = (CharArray)this.mediumQueue.poll())) {
            return ret;
        }
        if (capacity <= this.lengthOfLarge && null != (ret = (CharArray)this.largeQueue.poll())) {
            return ret;
        }
        MISSES.incrementAndGet();
        return ret;
    }

    protected boolean offer(CharArray charArray) {
        if (null == charArray) {
            return false;
        }
        charArray.reset();
        int capacity = charArray.capacity();
        if (capacity <= this.lengthOfSmall) {
            return this.smallQueue.offer(charArray);
        }
        if (capacity <= this.lengthOfMedium) {
            return this.mediumQueue.offer(charArray);
        }
        if (capacity <= this.lengthOfLarge) {
            return this.largeQueue.offer(charArray);
        }
        return false;
    }

    static {
        MISSES = new AtomicLong();
    }

    public static enum Part {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

