/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.contact;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.webdav.xml.ContactTest;
import java.util.Date;
import java.util.Locale;

public class DeleteTest
extends ContactTest {
    public DeleteTest(String name) {
        super(name);
    }

    public void testDelete() throws Exception {
        Contact contactObj = this.createContactObject("testDelete");
        int objectId1 = DeleteTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        int objectId2 = DeleteTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        int[][] objectIdAndFolderId = new int[][]{{objectId1, this.contactFolderId}, {objectId2, this.contactFolderId}};
        DeleteTest.deleteContact(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDeleteConcurentConflict() throws Exception {
        Contact contactObj = this.createContactObject("testDeleteConcurentConflict");
        int objectId = DeleteTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            DeleteTest.deleteContact(this.webCon, objectId, this.contactFolderId, new Date(1L), "http://" + this.hostName, this.login, this.password, this.context);
            DeleteTest.fail((String)"expected concurent modification exception!");
        }
        catch (OXException exc) {
            DeleteTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1000);
        }
        DeleteTest.deleteContact(this.webCon, objectId, this.contactFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDeleteNotFound() throws Exception {
        Contact contactObj = this.createContactObject("testUpdateContactNotFound");
        int objectId = DeleteTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            DeleteTest.deleteContact(this.webCon, objectId + 1000, this.contactFolderId, "http://" + this.hostName, this.login, this.password, this.context);
            DeleteTest.fail((String)"expected object not found exception!");
        }
        catch (OXException exc) {
            DeleteTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        DeleteTest.deleteContact(this.webCon, objectId, this.contactFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }
}

