/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bug8196Test
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(Bug8196Test.class);

    public Bug8196Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug8196() throws Exception {
        FolderObject folderObj = FolderTest.getAppointmentDefaultFolder(this.getSecondWebConversation(), this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        int secondAppointmentFolderId = folderObj.getObjectID();
        int secondUserId = folderObj.getCreatedBy();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug8196");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setAlarmFlag(true);
        appointmentObj.setAlarm(15);
        UserParticipant[] userParticipant = new UserParticipant[2];
        userParticipant[0] = new UserParticipant();
        userParticipant[0].setIdentifier(this.userId);
        userParticipant[1] = new UserParticipant();
        userParticipant[1].setIdentifier(secondUserId);
        appointmentObj.setParticipants((Participant[])userParticipant);
        int objectId = Bug8196Test.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(objectId);
        appointmentObj.removeAlarm();
        Bug8196Test.updateAppointment(this.getWebConversation(), appointmentObj, objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.removeAlarm();
        appointmentObj.setAlarmFlag(false);
        appointmentObj.setParentFolderID(secondAppointmentFolderId);
        Appointment loadAppointment = Bug8196Test.loadAppointment(this.getSecondWebConversation(), objectId, secondAppointmentFolderId, this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        Bug8196Test.compareObject(appointmentObj, loadAppointment);
        Date modified = new Date(loadAppointment.getLastModified().getTime() - 1000L);
        loadAppointment = Bug8196Test.loadAppointment(this.getSecondWebConversation(), objectId, secondAppointmentFolderId, modified, this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        Bug8196Test.compareObject(appointmentObj, loadAppointment);
        Bug8196Test.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

