/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.LinkEntryObject;
import com.openexchange.test.TestException;
import com.openexchange.webdav.xml.AbstractWebdavXMLTest;
import com.openexchange.webdav.xml.ContactWriter;
import com.openexchange.webdav.xml.FolderTest;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.parser.ResponseParser;
import com.openexchange.webdav.xml.request.PropFindMethod;
import com.openexchange.webdav.xml.types.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

public class ContactTest
extends AbstractWebdavXMLTest {
    protected int contactFolderId = -1;
    private static final String CONTACT_URL = "/servlet/webdav.contacts";
    private long dateTime = 0L;

    public ContactTest(String name) {
        super(name);
    }

    protected static Date decrementDate(Date date) {
        return new Date(date.getTime() - 1L);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FolderObject folderObj = FolderTest.getContactDefaultFolder(this.webCon, "http://" + this.hostName, this.login, this.password, this.context);
        this.contactFolderId = folderObj.getObjectID();
        this.userId = folderObj.getCreatedBy();
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.dateTime = c.getTimeInMillis();
    }

    public static void compareObject(Contact contactObj1, Contact contactObj2) throws Exception {
        ContactTest.assertEquals((String)"id is not equals", (int)contactObj1.getObjectID(), (int)contactObj2.getObjectID());
        ContactTest.assertEquals((String)"folder id is not equals", (int)contactObj1.getParentFolderID(), (int)contactObj2.getParentFolderID());
        ContactTest.assertEquals((String)"private flag is not equals", (boolean)contactObj1.getPrivateFlag(), (boolean)contactObj2.getPrivateFlag());
        ContactTest.assertEqualsAndNotNull("categories is not equals", contactObj1.getCategories(), contactObj2.getCategories());
        ContactTest.assertEqualsAndNotNull("given name is not equals", contactObj1.getGivenName(), contactObj2.getGivenName());
        ContactTest.assertEqualsAndNotNull("surname is not equals", contactObj1.getSurName(), contactObj2.getSurName());
        ContactTest.assertEqualsAndNotNull("anniversary is not equals", contactObj1.getAnniversary(), contactObj2.getAnniversary());
        ContactTest.assertEqualsAndNotNull("assistant name is not equals", contactObj1.getAssistantName(), contactObj2.getAssistantName());
        ContactTest.assertEqualsAndNotNull("birthday is not equals", contactObj1.getBirthday(), contactObj2.getBirthday());
        ContactTest.assertEqualsAndNotNull("branches is not equals", contactObj1.getBranches(), contactObj2.getBranches());
        ContactTest.assertEqualsAndNotNull("business categorie is not equals", contactObj1.getBusinessCategory(), contactObj2.getBusinessCategory());
        ContactTest.assertEqualsAndNotNull("cellular telephone1 is not equals", contactObj1.getCellularTelephone1(), contactObj2.getCellularTelephone1());
        ContactTest.assertEqualsAndNotNull("cellular telephone2 is not equals", contactObj1.getCellularTelephone2(), contactObj2.getCellularTelephone2());
        ContactTest.assertEqualsAndNotNull("city business is not equals", contactObj1.getCityBusiness(), contactObj2.getCityBusiness());
        ContactTest.assertEqualsAndNotNull("city home is not equals", contactObj1.getCityHome(), contactObj2.getCityHome());
        ContactTest.assertEqualsAndNotNull("city other is not equals", contactObj1.getCityOther(), contactObj2.getCityOther());
        ContactTest.assertEqualsAndNotNull("commercial register is not equals", contactObj1.getCommercialRegister(), contactObj2.getCommercialRegister());
        ContactTest.assertEqualsAndNotNull("company is not equals", contactObj1.getCompany(), contactObj2.getCompany());
        ContactTest.assertEqualsAndNotNull("country business is not equals", contactObj1.getCountryBusiness(), contactObj2.getCountryBusiness());
        ContactTest.assertEqualsAndNotNull("country home is not equals", contactObj1.getCountryHome(), contactObj2.getCountryHome());
        ContactTest.assertEqualsAndNotNull("country other is not equals", contactObj1.getCountryOther(), contactObj2.getCountryOther());
        ContactTest.assertEqualsAndNotNull("department is not equals", contactObj1.getDepartment(), contactObj2.getDepartment());
        ContactTest.assertEqualsAndNotNull("email1 is not equals", contactObj1.getEmail1(), contactObj2.getEmail1());
        ContactTest.assertEqualsAndNotNull("email2 is not equals", contactObj1.getEmail2(), contactObj2.getEmail2());
        ContactTest.assertEqualsAndNotNull("email3 is not equals", contactObj1.getEmail3(), contactObj2.getEmail3());
        ContactTest.assertEqualsAndNotNull("employee type is not equals", contactObj1.getEmployeeType(), contactObj2.getEmployeeType());
        ContactTest.assertEqualsAndNotNull("fax business is not equals", contactObj1.getFaxBusiness(), contactObj2.getFaxBusiness());
        ContactTest.assertEqualsAndNotNull("fax home is not equals", contactObj1.getFaxHome(), contactObj2.getFaxHome());
        ContactTest.assertEqualsAndNotNull("fax other is not equals", contactObj1.getFaxOther(), contactObj2.getFaxOther());
        ContactTest.assertEqualsAndNotNull("info is not equals", contactObj1.getInfo(), contactObj2.getInfo());
        ContactTest.assertEqualsAndNotNull("image1 is not equals", contactObj1.getImage1(), contactObj2.getImage1());
        ContactTest.assertEqualsAndNotNull("instant messenger1 is not equals", contactObj1.getInstantMessenger1(), contactObj2.getInstantMessenger1());
        ContactTest.assertEqualsAndNotNull("instant messenger2 is not equals", contactObj1.getInstantMessenger2(), contactObj2.getInstantMessenger2());
        ContactTest.assertEqualsAndNotNull("instant messenger2 is not equals", contactObj1.getInstantMessenger2(), contactObj2.getInstantMessenger2());
        ContactTest.assertEqualsAndNotNull("marital status is not equals", contactObj1.getMaritalStatus(), contactObj2.getMaritalStatus());
        ContactTest.assertEqualsAndNotNull("manager name is not equals", contactObj1.getManagerName(), contactObj2.getManagerName());
        ContactTest.assertEqualsAndNotNull("middle name is not equals", contactObj1.getMiddleName(), contactObj2.getMiddleName());
        ContactTest.assertEqualsAndNotNull("nickname is not equals", contactObj1.getNickname(), contactObj2.getNickname());
        ContactTest.assertEqualsAndNotNull("note is not equals", contactObj1.getNote(), contactObj2.getNote());
        ContactTest.assertEqualsAndNotNull("number of children is not equals", contactObj1.getNumberOfChildren(), contactObj2.getNumberOfChildren());
        ContactTest.assertEqualsAndNotNull("number of employee is not equals", contactObj1.getNumberOfEmployee(), contactObj2.getNumberOfEmployee());
        ContactTest.assertEqualsAndNotNull("position is not equals", contactObj1.getPosition(), contactObj2.getPosition());
        ContactTest.assertEqualsAndNotNull("postal code business is not equals", contactObj1.getPostalCodeBusiness(), contactObj2.getPostalCodeBusiness());
        ContactTest.assertEqualsAndNotNull("postal code home is not equals", contactObj1.getPostalCodeHome(), contactObj2.getPostalCodeHome());
        ContactTest.assertEqualsAndNotNull("postal code other is not equals", contactObj1.getPostalCodeOther(), contactObj2.getPostalCodeOther());
        ContactTest.assertEqualsAndNotNull("profession is not equals", contactObj1.getProfession(), contactObj2.getProfession());
        ContactTest.assertEqualsAndNotNull("room number is not equals", contactObj1.getRoomNumber(), contactObj2.getRoomNumber());
        ContactTest.assertEqualsAndNotNull("sales volume is not equals", contactObj1.getSalesVolume(), contactObj2.getSalesVolume());
        ContactTest.assertEqualsAndNotNull("spouse name is not equals", contactObj1.getSpouseName(), contactObj2.getSpouseName());
        ContactTest.assertEqualsAndNotNull("state business is not equals", contactObj1.getStateBusiness(), contactObj2.getStateBusiness());
        ContactTest.assertEqualsAndNotNull("state home is not equals", contactObj1.getStateHome(), contactObj2.getStateHome());
        ContactTest.assertEqualsAndNotNull("state other is not equals", contactObj1.getStateOther(), contactObj2.getStateOther());
        ContactTest.assertEqualsAndNotNull("street business is not equals", contactObj1.getStreetBusiness(), contactObj2.getStreetBusiness());
        ContactTest.assertEqualsAndNotNull("street home is not equals", contactObj1.getStreetHome(), contactObj2.getStreetHome());
        ContactTest.assertEqualsAndNotNull("street other is not equals", contactObj1.getStreetOther(), contactObj2.getStreetOther());
        ContactTest.assertEqualsAndNotNull("suffix is not equals", contactObj1.getSuffix(), contactObj2.getSuffix());
        ContactTest.assertEqualsAndNotNull("tax id is not equals", contactObj1.getTaxID(), contactObj2.getTaxID());
        ContactTest.assertEqualsAndNotNull("telephone assistant is not equals", contactObj1.getTelephoneAssistant(), contactObj2.getTelephoneAssistant());
        ContactTest.assertEqualsAndNotNull("telephone business1 is not equals", contactObj1.getTelephoneBusiness1(), contactObj2.getTelephoneBusiness1());
        ContactTest.assertEqualsAndNotNull("telephone business2 is not equals", contactObj1.getTelephoneBusiness2(), contactObj2.getTelephoneBusiness2());
        ContactTest.assertEqualsAndNotNull("telephone callback is not equals", contactObj1.getTelephoneCallback(), contactObj2.getTelephoneCallback());
        ContactTest.assertEqualsAndNotNull("telephone car is not equals", contactObj1.getTelephoneCar(), contactObj2.getTelephoneCar());
        ContactTest.assertEqualsAndNotNull("telehpone company is not equals", contactObj1.getTelephoneCompany(), contactObj2.getTelephoneCompany());
        ContactTest.assertEqualsAndNotNull("telephone home1 is not equals", contactObj1.getTelephoneHome1(), contactObj2.getTelephoneHome1());
        ContactTest.assertEqualsAndNotNull("telephone home2 is not equals", contactObj1.getTelephoneHome2(), contactObj2.getTelephoneHome2());
        ContactTest.assertEqualsAndNotNull("telehpone ip is not equals", contactObj1.getTelephoneIP(), contactObj2.getTelephoneIP());
        ContactTest.assertEqualsAndNotNull("telehpone isdn is not equals", contactObj1.getTelephoneISDN(), contactObj2.getTelephoneISDN());
        ContactTest.assertEqualsAndNotNull("telephone other is not equals", contactObj1.getTelephoneOther(), contactObj2.getTelephoneOther());
        ContactTest.assertEqualsAndNotNull("telephone pager is not equals", contactObj1.getTelephonePager(), contactObj2.getTelephonePager());
        ContactTest.assertEqualsAndNotNull("telephone primary is not equals", contactObj1.getTelephonePrimary(), contactObj2.getTelephonePrimary());
        ContactTest.assertEqualsAndNotNull("telephone radio is not equals", contactObj1.getTelephoneRadio(), contactObj2.getTelephoneRadio());
        ContactTest.assertEqualsAndNotNull("telephone telex is not equals", contactObj1.getTelephoneTelex(), contactObj2.getTelephoneTelex());
        ContactTest.assertEqualsAndNotNull("telephone ttytdd is not equals", contactObj1.getTelephoneTTYTTD(), contactObj2.getTelephoneTTYTTD());
        ContactTest.assertEqualsAndNotNull("title is not equals", contactObj1.getTitle(), contactObj2.getTitle());
        ContactTest.assertEqualsAndNotNull("url is not equals", contactObj1.getURL(), contactObj2.getURL());
        ContactTest.assertEqualsAndNotNull("userfield01 is not equals", contactObj1.getUserField01(), contactObj2.getUserField01());
        ContactTest.assertEqualsAndNotNull("userfield02 is not equals", contactObj1.getUserField02(), contactObj2.getUserField02());
        ContactTest.assertEqualsAndNotNull("userfield03 is not equals", contactObj1.getUserField03(), contactObj2.getUserField03());
        ContactTest.assertEqualsAndNotNull("userfield04 is not equals", contactObj1.getUserField04(), contactObj2.getUserField04());
        ContactTest.assertEqualsAndNotNull("userfield05 is not equals", contactObj1.getUserField05(), contactObj2.getUserField05());
        ContactTest.assertEqualsAndNotNull("userfield06 is not equals", contactObj1.getUserField06(), contactObj2.getUserField06());
        ContactTest.assertEqualsAndNotNull("userfield07 is not equals", contactObj1.getUserField07(), contactObj2.getUserField07());
        ContactTest.assertEqualsAndNotNull("userfield08 is not equals", contactObj1.getUserField08(), contactObj2.getUserField08());
        ContactTest.assertEqualsAndNotNull("userfield09 is not equals", contactObj1.getUserField09(), contactObj2.getUserField09());
        ContactTest.assertEqualsAndNotNull("userfield10 is not equals", contactObj1.getUserField10(), contactObj2.getUserField10());
        ContactTest.assertEqualsAndNotNull("userfield11 is not equals", contactObj1.getUserField11(), contactObj2.getUserField11());
        ContactTest.assertEqualsAndNotNull("userfield12 is not equals", contactObj1.getUserField12(), contactObj2.getUserField12());
        ContactTest.assertEqualsAndNotNull("userfield13 is not equals", contactObj1.getUserField13(), contactObj2.getUserField13());
        ContactTest.assertEqualsAndNotNull("userfield14 is not equals", contactObj1.getUserField14(), contactObj2.getUserField14());
        ContactTest.assertEqualsAndNotNull("userfield15 is not equals", contactObj1.getUserField15(), contactObj2.getUserField15());
        ContactTest.assertEqualsAndNotNull("userfield16 is not equals", contactObj1.getUserField16(), contactObj2.getUserField16());
        ContactTest.assertEqualsAndNotNull("userfield17 is not equals", contactObj1.getUserField17(), contactObj2.getUserField17());
        ContactTest.assertEqualsAndNotNull("userfield18 is not equals", contactObj1.getUserField18(), contactObj2.getUserField18());
        ContactTest.assertEqualsAndNotNull("userfield19 is not equals", contactObj1.getUserField19(), contactObj2.getUserField19());
        ContactTest.assertEqualsAndNotNull("userfield20 is not equals", contactObj1.getUserField20(), contactObj2.getUserField20());
        ContactTest.assertEqualsAndNotNull("number of attachments is not equals", contactObj1.getNumberOfAttachments(), contactObj2.getNumberOfAttachments());
        ContactTest.assertEqualsAndNotNull("default address is not equals", contactObj1.getDefaultAddress(), contactObj2.getDefaultAddress());
        ContactTest.assertEqualsAndNotNull("distribution list is not equals", ContactTest.distributionlist2String(contactObj1.getDistributionList()), ContactTest.distributionlist2String(contactObj2.getDistributionList()));
    }

    protected Contact createContactObject(String displayname) {
        Contact contactObj = new Contact();
        contactObj.setSurName("Meier");
        contactObj.setGivenName("Herbert");
        contactObj.setDisplayName(displayname);
        contactObj.setStreetBusiness("Franz-Meier Weg 17");
        contactObj.setCityBusiness("Test Stadt");
        contactObj.setStateBusiness("NRW");
        contactObj.setCountryBusiness("Deutschland");
        contactObj.setTelephoneBusiness1("+49112233445566");
        contactObj.setCompany("Internal Test AG");
        contactObj.setEmail1("hebert.meier@open-xchange.com");
        contactObj.setParentFolderID(this.contactFolderId);
        return contactObj;
    }

    protected Contact createCompleteContactObject() throws Exception {
        Contact contactObj = new Contact();
        contactObj.setPrivateFlag(true);
        contactObj.setCategories("categories");
        contactObj.setGivenName("given name");
        contactObj.setSurName("surname");
        contactObj.setAnniversary(new Date(this.dateTime));
        contactObj.setAssistantName("assistant name");
        contactObj.setBirthday(new Date(this.dateTime));
        contactObj.setBranches("branches");
        contactObj.setBusinessCategory("business categorie");
        contactObj.setCellularTelephone1("cellular telephone1");
        contactObj.setCellularTelephone2("cellular telephone2");
        contactObj.setCityBusiness("city business");
        contactObj.setCityHome("city home");
        contactObj.setCityOther("city other");
        contactObj.setCommercialRegister("commercial register");
        contactObj.setCompany("company");
        contactObj.setCountryBusiness("country business");
        contactObj.setCountryHome("country home");
        contactObj.setCountryOther("country other");
        contactObj.setDepartment("department");
        contactObj.setDisplayName("display name");
        contactObj.setEmail1("email1@test.de");
        contactObj.setEmail2("email2@test.de");
        contactObj.setEmail3("email3@test.de");
        contactObj.setEmployeeType("employee type");
        contactObj.setFaxBusiness("fax business");
        contactObj.setFaxHome("fax home");
        contactObj.setFaxOther("fax other");
        contactObj.setInfo("info");
        contactObj.setInstantMessenger1("instant messenger1");
        contactObj.setInstantMessenger2("instant messenger2");
        contactObj.setManagerName("manager name");
        contactObj.setMaritalStatus("marital status");
        contactObj.setMiddleName("middle name");
        contactObj.setNickname("nickname");
        contactObj.setNote("note");
        contactObj.setNumberOfChildren("number of children");
        contactObj.setNumberOfEmployee("number of employee");
        contactObj.setPosition("position");
        contactObj.setPostalCodeBusiness("postal code business");
        contactObj.setPostalCodeHome("postal code home");
        contactObj.setPostalCodeOther("postal code other");
        contactObj.setProfession("profession");
        contactObj.setRoomNumber("room number");
        contactObj.setSalesVolume("sales volume");
        contactObj.setSpouseName("spouse name");
        contactObj.setStateBusiness("state business");
        contactObj.setStateHome("state home");
        contactObj.setStateOther("state other");
        contactObj.setStreetBusiness("street business");
        contactObj.setStreetHome("street home");
        contactObj.setStreetOther("street other");
        contactObj.setSuffix("suffix");
        contactObj.setTaxID("tax id");
        contactObj.setTelephoneAssistant("telephone assistant");
        contactObj.setTelephoneBusiness1("telephone business1");
        contactObj.setTelephoneBusiness2("telephone business2");
        contactObj.setTelephoneCallback("telephone callback");
        contactObj.setTelephoneCar("telephone car");
        contactObj.setTelephoneCompany("telehpone company");
        contactObj.setTelephoneHome1("telephone home1");
        contactObj.setTelephoneHome2("telephone home2");
        contactObj.setTelephoneIP("telehpone ip");
        contactObj.setTelephoneISDN("telehpone isdn");
        contactObj.setTelephoneOther("telephone other");
        contactObj.setTelephonePager("telephone pager");
        contactObj.setTelephonePrimary("telephone primary");
        contactObj.setTelephoneRadio("telephone radio");
        contactObj.setTelephoneTelex("telephone telex");
        contactObj.setTelephoneTTYTTD("telephone ttytdd");
        contactObj.setTitle("title");
        contactObj.setURL("url");
        contactObj.setUserField01("userfield01");
        contactObj.setUserField02("userfield02");
        contactObj.setUserField03("userfield03");
        contactObj.setUserField04("userfield04");
        contactObj.setUserField05("userfield05");
        contactObj.setUserField06("userfield06");
        contactObj.setUserField07("userfield07");
        contactObj.setUserField08("userfield08");
        contactObj.setUserField09("userfield09");
        contactObj.setUserField10("userfield10");
        contactObj.setUserField11("userfield11");
        contactObj.setUserField12("userfield12");
        contactObj.setUserField13("userfield13");
        contactObj.setUserField14("userfield14");
        contactObj.setUserField15("userfield15");
        contactObj.setUserField16("userfield16");
        contactObj.setUserField17("userfield17");
        contactObj.setUserField18("userfield18");
        contactObj.setUserField19("userfield19");
        contactObj.setUserField20("userfield20");
        contactObj.setParentFolderID(this.contactFolderId);
        Contact link1 = this.createContactObject("link1");
        Contact link2 = this.createContactObject("link2");
        int linkId1 = ContactTest.insertContact(this.webCon, link1, "http://" + this.hostName, this.login, this.password, this.context);
        link1.setObjectID(linkId1);
        int linkId2 = ContactTest.insertContact(this.webCon, link2, "http://" + this.hostName, this.login, this.password, this.context);
        link2.setObjectID(linkId2);
        LinkEntryObject[] links = new LinkEntryObject[2];
        links[0] = new LinkEntryObject();
        links[0].setLinkID(link1.getObjectID());
        links[0].setLinkDisplayname(link1.getDisplayName());
        links[1] = new LinkEntryObject();
        links[1].setLinkID(link2.getObjectID());
        links[1].setLinkDisplayname(link2.getDisplayName());
        contactObj.setLinks(links);
        DistributionListEntryObject[] entry = new DistributionListEntryObject[]{new DistributionListEntryObject("displayname a", "a@a.de", 0), new DistributionListEntryObject(link1.getDisplayName(), link1.getEmail1(), 1)};
        entry[1].setEntryID(link1.getObjectID());
        contactObj.setDistributionList(entry);
        return contactObj;
    }

    public static int insertContact(WebConversation webCon, Contact contactObj, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        contactObj.removeObjectID();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        ContactWriter contactWriter = new ContactWriter();
        contactWriter.addContent2PropElement(eProp, contactObj, false, true);
        Document doc = ContactTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + CONTACT_URL, (InputStream)bais, "text/xml");
        req.setHeaderField("authorization", "Basic " + ContactTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        ContactTest.assertEquals((int)207, (int)resp.getResponseCode());
        InputStream input = resp.getInputStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(input), 7);
        ContactTest.assertEquals((String)"Response of insert strangely contains more than 1 response entities.", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        ContactTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
        Contact contactObj2 = (Contact)response[0].getDataObject();
        int objectId = contactObj2.getObjectID();
        ContactTest.assertNotNull((String)"last modified is null", (Object)contactObj2.getLastModified());
        ContactTest.assertTrue((String)"last modified is not > 0", (contactObj2.getLastModified().getTime() > 0L ? 1 : 0) != 0);
        ContactTest.assertTrue((String)"check objectId", (objectId > 0 ? 1 : 0) != 0);
        return objectId;
    }

    public static void updateContact(WebConversation webCon, Contact contactObj, int objectId, int inFolder, String host, String login, String password, String context) throws OXException, Exception {
        ContactTest.updateContact(webCon, contactObj, objectId, inFolder, new Date(System.currentTimeMillis() + 1000000L), host, login, password, context);
    }

    public static void updateContact(WebConversation webCon, Contact contactObj, int objectId, int inFolder, Date lastModified, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        contactObj.setObjectID(objectId);
        contactObj.setLastModified(lastModified);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Element eProp = new Element("prop", webdav);
        ContactWriter appointmentWriter = new ContactWriter();
        appointmentWriter.addContent2PropElement(eProp, contactObj, false, true);
        Element eInFolder = new Element("infolder", XmlServlet.NS);
        eInFolder.addContent(String.valueOf(inFolder));
        eProp.addContent((Content)eInFolder);
        Document doc = ContactTest.addProp2Document(eProp);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + CONTACT_URL, (InputStream)bais, "text/javascript");
        req.setHeaderField("authorization", "Basic " + ContactTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResponse((WebRequest)req);
        ContactTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 7);
        ContactTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        contactObj = (Contact)response[0].getDataObject();
        objectId = contactObj.getObjectID();
        ContactTest.assertNotNull((String)"last modified is null", (Object)contactObj.getLastModified());
        ContactTest.assertTrue((String)"last modified is not > 0", (contactObj.getLastModified().getTime() > 0L ? 1 : 0) != 0);
        ContactTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
    }

    public static int[] deleteContact(WebConversation webCon, int[][] objectIdAndFolderId, String host, String login, String password, String context) throws Exception {
        new ArrayList();
        for (int a = 0; a < objectIdAndFolderId.length; ++a) {
            ContactTest.deleteContact(webCon, objectIdAndFolderId[a][0], objectIdAndFolderId[a][1], host, login, password, context);
        }
        return new int[0];
    }

    @Deprecated
    public static void deleteContact(WebConversation webCon, int objectId, int inFolder, String host, String login, String password, String context) throws OXException, Exception {
        ContactTest.deleteContact(webCon, objectId, inFolder, new Date(System.currentTimeMillis() + 1000000L), host, login, password, context);
    }

    public static void deleteContact(WebConversation webCon, int objectId, int inFolder, Date lastModified, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element rootElement = new Element("multistatus", webdav);
        rootElement.addNamespaceDeclaration(XmlServlet.NS);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Contact contactObj = new Contact();
        contactObj.setObjectID(objectId);
        contactObj.setParentFolderID(inFolder);
        contactObj.setLastModified(lastModified);
        Element eProp = new Element("prop", webdav);
        ContactWriter contactWriter = new ContactWriter();
        contactWriter.addContent2PropElement(eProp, contactObj, false, true);
        Element eMethod = new Element("method", XmlServlet.NS);
        eMethod.addContent("DELETE");
        eProp.addContent((Content)eMethod);
        rootElement.addContent((Content)ContactTest.addProp2PropertyUpdate(eProp));
        Document doc = new Document(rootElement);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PutMethodWebRequest req = new PutMethodWebRequest(host + CONTACT_URL, (InputStream)bais, "text/xml");
        req.setHeaderField("authorization", "Basic " + ContactTest.getAuthData(login, password, context));
        WebResponse resp = webCon.getResource((WebRequest)req);
        ContactTest.assertEquals((int)207, (int)resp.getResponseCode());
        bais = new ByteArrayInputStream(resp.getText().getBytes());
        Response[] response = ResponseParser.parse(new SAXBuilder().build((InputStream)bais), 7);
        ContactTest.assertEquals((String)"Response of delete strangely contains more than 1 response entities.", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        ContactTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
    }

    public static int[] listContact(WebConversation webCon, int inFolder, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        Element eObjectmode = new Element("objectmode", XmlServlet.NS);
        eFolderId.addContent(String.valueOf(inFolder));
        eObjectmode.addContent("LIST");
        eProp.addContent((Content)eFolderId);
        eProp.addContent((Content)eObjectmode);
        ePropfind.addContent((Content)eProp);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, ContactTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + CONTACT_URL);
        propFindMethod.setDoAuthentication(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        propFindMethod.setRequestBody(bais);
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        ContactTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream body = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(body), 7, true);
        ContactTest.assertEquals((String)"response length not is 1", (int)1, (int)response.length);
        return (int[])response[0].getDataObject();
    }

    private static Credentials getCredentials(String login, String password, String context) {
        return new UsernamePasswordCredentials(context == null || context.equals("") ? login : login + "@" + context, password);
    }

    public static Contact[] listContact(WebConversation webCon, int inFolder, Date modified, boolean changed, boolean deleted, String host, String login, String password, String context) throws Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        if (!changed && !deleted) {
            return new Contact[0];
        }
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        ePropfind.addContent((Content)eProp);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        eProp.addContent((Content)eFolderId);
        eFolderId.addContent(String.valueOf(inFolder));
        Element eLastSync = new Element("lastsync", XmlServlet.NS);
        eProp.addContent((Content)eLastSync);
        eLastSync.addContent(String.valueOf(modified.getTime()));
        Element eObjectmode = new Element("objectmode", XmlServlet.NS);
        eProp.addContent((Content)eObjectmode);
        StringBuilder objectMode = new StringBuilder();
        if (changed) {
            objectMode.append("NEW_AND_MODIFIED");
        }
        if (deleted) {
            if (objectMode.length() > 0) {
                objectMode.append(',');
            }
            objectMode.append("DELETED");
        }
        eObjectmode.addContent(objectMode.toString());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, ContactTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + CONTACT_URL);
        propFindMethod.setDoAuthentication(true);
        propFindMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(baos.toByteArray(), "text/xml"));
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        ContactTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream input = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(input), 7);
        Contact[] contactArray = new Contact[response.length];
        for (int a = 0; a < contactArray.length; ++a) {
            if (response[a].hasError()) {
                ContactTest.fail((String)("xml error: " + response[a].getErrorMessage()));
            }
            contactArray[a] = (Contact)response[a].getDataObject();
            ContactTest.assertNotNull((String)"last modified is null", (Object)contactArray[a].getLastModified());
        }
        return contactArray;
    }

    public static Contact loadContact(WebConversation webCon, int objectId, int inFolder, String host, String login, String password, String context) throws OXException, Exception {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        Element ePropfind = new Element("propfind", webdav);
        Element eProp = new Element("prop", webdav);
        ePropfind.addContent((Content)eProp);
        Element eFolderId = new Element("folder_id", XmlServlet.NS);
        eProp.addContent((Content)eFolderId);
        eFolderId.addContent(String.valueOf(inFolder));
        Element eObjectId = new Element("object_id", XmlServlet.NS);
        eProp.addContent((Content)eObjectId);
        eObjectId.addContent(String.valueOf(objectId));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document doc = new Document(ePropfind);
        XMLOutputter xo = new XMLOutputter();
        xo.output(doc, (OutputStream)baos);
        baos.flush();
        HttpClient httpclient = new HttpClient();
        httpclient.getState().setCredentials(AuthScope.ANY, ContactTest.getCredentials(login, password, context));
        PropFindMethod propFindMethod = new PropFindMethod(host + CONTACT_URL);
        propFindMethod.setDoAuthentication(true);
        propFindMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(baos.toByteArray(), "text/xml"));
        int status = httpclient.executeMethod((HttpMethod)propFindMethod);
        ContactTest.assertEquals((String)"check propfind response", (int)207, (int)status);
        InputStream input = propFindMethod.getResponseBodyAsStream();
        Response[] response = ResponseParser.parse(new SAXBuilder().build(input), 7);
        ContactTest.assertEquals((String)"check response", (int)1, (int)response.length);
        if (response[0].hasError()) {
            throw new TestException(response[0].getErrorMessage());
        }
        ContactTest.assertEquals((String)"check response status", (int)200, (int)response[0].getStatus());
        return (Contact)response[0].getDataObject();
    }

    private static HashSet links2String(LinkEntryObject[] linkEntryObject) throws Exception {
        if (linkEntryObject == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < linkEntryObject.length; ++a) {
            hs.add(ContactTest.link2String(linkEntryObject[a]));
        }
        return hs;
    }

    private static String link2String(LinkEntryObject linkEntryObject) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("ID" + linkEntryObject.getLinkID());
        sb.append("DISPLAYNAME" + linkEntryObject.getLinkDisplayname());
        return sb.toString();
    }

    private static HashSet distributionlist2String(DistributionListEntryObject[] distributionListEntry) throws Exception {
        if (distributionListEntry == null) {
            return null;
        }
        HashSet<String> hs = new HashSet<String>();
        for (int a = 0; a < distributionListEntry.length; ++a) {
            hs.add(ContactTest.entry2String(distributionListEntry[a]));
        }
        return hs;
    }

    private static String entry2String(DistributionListEntryObject entry) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("ID" + entry.getEntryID());
        sb.append("D" + entry.getDisplayname());
        sb.append("F" + entry.getEmailfield());
        sb.append("E" + entry.getEmailaddress());
        return sb.toString();
    }
}

