/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.webdav.protocol.AbstractResourceTest;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.TestWebdavFactoryBuilder;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.protocol.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ResourceTest
extends AbstractResourceTest {
    public static final int SKEW = 1000;
    protected static WebdavFactory FACTORY = null;

    @Override
    public void setUp() throws Exception {
        try {
            TestWebdavFactoryBuilder.setUp();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        FACTORY = TestWebdavFactoryBuilder.buildFactory();
        FACTORY.beginRequest();
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        FACTORY.endRequest(200);
        TestWebdavFactoryBuilder.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBody() throws Exception {
        WebdavResource res = this.createResource();
        String content = "Hello, I'm the content!";
        byte[] bytes = "Hello, I'm the content!".getBytes(Charsets.UTF_8);
        res.putBody((InputStream)new ByteArrayInputStream(bytes));
        InputStream in = null;
        ByteArrayInputStream in2 = null;
        try {
            in = res.getBody();
            in2 = new ByteArrayInputStream(bytes);
            int b = -1;
            while ((b = in.read()) != -1) {
                ResourceTest.assertEquals((int)b, (int)((InputStream)in2).read());
            }
            ResourceTest.assertEquals((int)-1, (int)((InputStream)in2).read());
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (in2 != null) {
                ((InputStream)in2).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMove() throws Exception {
        WebdavResource res = this.createResource();
        Date lastModified = res.getLastModified();
        res.getCreationDate();
        WebdavProperty prop = new WebdavProperty();
        prop.setName("myvalue");
        prop.setNamespace("ox");
        prop.setValue("gnaaa!");
        res.putProperty(prop);
        String content = "Hello, I'm the content!";
        byte[] bytes = "Hello, I'm the content!".getBytes(Charsets.UTF_8);
        res.putBody((InputStream)new ByteArrayInputStream(bytes));
        Thread.sleep(1000L);
        WebdavPath url = res.getUrl();
        res.move(this.testCollection.dup().append(new String[]{"moved"}));
        res = FACTORY.resolveResource(url);
        ResourceTest.assertFalse((boolean)res.exists());
        res = this.resourceManager.resolveResource(this.testCollection.dup().append(new String[]{"moved"}));
        ResourceTest.assertTrue((boolean)res.exists());
        ResourceTest.assertFalse((boolean)lastModified.equals(res.getLastModified()));
        ResourceTest.assertEquals((String)"gnaaa!", (String)res.getProperty("ox", "myvalue").getValue());
        InputStream in = null;
        ByteArrayInputStream in2 = null;
        try {
            in = res.getBody();
            in2 = new ByteArrayInputStream(bytes);
            int b = -1;
            while ((b = in.read()) != -1) {
                ResourceTest.assertEquals((int)b, (int)((InputStream)in2).read());
            }
            ResourceTest.assertEquals((int)-1, (int)((InputStream)in2).read());
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (in2 != null) {
                ((InputStream)in2).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopy() throws Exception {
        WebdavResource res = this.createResource();
        Date lastModified = res.getLastModified();
        Date creationDate = res.getCreationDate();
        WebdavProperty prop = new WebdavProperty();
        prop.setName("myvalue");
        prop.setNamespace("ox");
        prop.setValue("gnaaa!");
        res.putProperty(prop);
        String content = "Hello, I'm the content!";
        byte[] bytes = "Hello, I'm the content!".getBytes(Charsets.UTF_8);
        res.putBody((InputStream)new ByteArrayInputStream(bytes));
        Thread.sleep(1000L);
        WebdavPath url = res.getUrl();
        res.copy(this.testCollection.dup().append(new String[]{"copy"}));
        res = FACTORY.resolveResource(url);
        ResourceTest.assertTrue((boolean)res.exists());
        res = this.resourceManager.resolveResource(this.testCollection.dup().append(new String[]{"copy"}));
        ResourceTest.assertTrue((boolean)res.exists());
        ResourceTest.assertFalse((boolean)lastModified.equals(res.getLastModified()));
        ResourceTest.assertFalse((boolean)creationDate.equals(res.getCreationDate()));
        ResourceTest.assertEquals((String)"gnaaa!", (String)res.getProperty("ox", "myvalue").getValue());
        InputStream in = null;
        ByteArrayInputStream in2 = null;
        try {
            in = res.getBody();
            in2 = new ByteArrayInputStream(bytes);
            int b = -1;
            while ((b = in.read()) != -1) {
                ResourceTest.assertEquals((int)b, (int)((InputStream)in2).read());
            }
            ResourceTest.assertEquals((int)-1, (int)((InputStream)in2).read());
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (in2 != null) {
                ((InputStream)in2).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOriginalRemainsWhenCopyDisappears() throws Exception {
        WebdavResource res = this.createResource();
        String content = "Hello, I'm the content!";
        byte[] bytes = "Hello, I'm the content!".getBytes(Charsets.UTF_8);
        res.putBody((InputStream)new ByteArrayInputStream(bytes));
        WebdavPath url = res.getUrl();
        res.copy(this.testCollection.dup().append(new String[]{"copy"}));
        res = FACTORY.resolveResource(url);
        ResourceTest.assertTrue((boolean)res.exists());
        WebdavResource copy = this.resourceManager.resolveResource(this.testCollection.dup().append(new String[]{"copy"}));
        copy.delete();
        ResourceTest.assertFalse((boolean)copy.exists());
        ResourceTest.assertTrue((boolean)res.exists());
        InputStream in = null;
        ByteArrayInputStream in2 = null;
        try {
            in = res.getBody();
            in2 = new ByteArrayInputStream(bytes);
            int b = -1;
            boolean readAntyhing = false;
            while ((b = in.read()) != -1) {
                readAntyhing = true;
                ResourceTest.assertEquals((int)b, (int)((InputStream)in2).read());
            }
            ResourceTest.assertTrue((boolean)readAntyhing);
            ResourceTest.assertEquals((int)-1, (int)((InputStream)in2).read());
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (in2 != null) {
                ((InputStream)in2).close();
            }
        }
    }

    @Override
    protected List<Protocol.Property> getPropertiesToTest() {
        return this.resourceManager.getProtocol().getKnownProperties();
    }

    @Override
    protected WebdavResource createResource() throws WebdavProtocolException {
        WebdavResource resource = FACTORY.resolveResource(this.testCollection + "/testResource" + Math.random());
        ResourceTest.assertFalse((boolean)resource.exists());
        resource.create();
        resource = this.resourceManager.resolveResource(resource.getUrl());
        ResourceTest.assertTrue((boolean)resource.exists());
        return resource;
    }

    @Override
    protected WebdavFactory getWebdavFactory() {
        return FACTORY;
    }

    public void testLock() throws Exception {
        WebdavLock lock = new WebdavLock();
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setTimeout(10000L);
        ResourceTest.assertNull((Object)lock.getToken());
        WebdavResource res = this.createResource();
        res.lock(lock);
        res.save();
        ResourceTest.assertNotNull((Object)lock.getToken());
        ResourceTest.assertNotNull((Object)res.getProperty("DAV:", "lockdiscovery"));
        ResourceTest.assertNotNull((Object)res.getProperty("DAV:", "lockdiscovery").getValue());
        ResourceTest.assertTrue((boolean)res.getProperty("DAV:", "lockdiscovery").isXML());
        List locks = res.getLocks();
        ResourceTest.assertEquals((int)1, (int)locks.size());
        ResourceTest.assertEquals((Object)lock, locks.get(0));
        ResourceTest.assertEquals((Object)lock, (Object)res.getLock(lock.getToken()));
        res.unlock(lock.getToken());
        res.save();
        locks = res.getLocks();
        ResourceTest.assertEquals((int)0, (int)locks.size());
        lock.setTimeout(22L);
        res.lock(lock);
        res.save();
        Thread.sleep(23L);
        locks = res.getLocks();
        ResourceTest.assertEquals((int)0, (int)locks.size());
        lock.setTimeout(1000L);
        res.lock(lock);
        res.save();
        WebdavLock lock2 = new WebdavLock();
        lock2.setType(WebdavLock.Type.WRITE_LITERAL);
        lock2.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock2.setDepth(0);
        lock2.setOwner("me");
        lock2.setTimeout(-1L);
        lock2.setToken(lock.getToken());
        res.lock(lock2);
        locks = res.getLocks();
        ResourceTest.assertEquals((int)1, (int)locks.size());
        lock = res.getLock(lock.getToken());
        res.unlock(lock.getToken());
        res.save();
    }

    public void testConflict() throws Exception {
        WebdavResource res = this.createResource();
        try {
            this.resourceManager.resolveResource(res.getUrl() + "/resource").create();
            ResourceTest.fail();
        }
        catch (WebdavProtocolException x) {
            ResourceTest.assertTrue((String)("" + x.getStatus()), (409 == x.getStatus() || 412 == x.getStatus() ? 1 : 0) != 0);
        }
    }

    public void testOptions() throws Exception {
        WebdavResource res = this.createResource();
        ResourceTest.assertOptions(Arrays.asList(res.getOptions()), Protocol.WEBDAV_METHOD.GET, Protocol.WEBDAV_METHOD.PUT, Protocol.WEBDAV_METHOD.DELETE, Protocol.WEBDAV_METHOD.HEAD, Protocol.WEBDAV_METHOD.OPTIONS, Protocol.WEBDAV_METHOD.TRACE, Protocol.WEBDAV_METHOD.PROPPATCH, Protocol.WEBDAV_METHOD.PROPFIND, Protocol.WEBDAV_METHOD.MOVE, Protocol.WEBDAV_METHOD.COPY, Protocol.WEBDAV_METHOD.LOCK, Protocol.WEBDAV_METHOD.UNLOCK, Protocol.WEBDAV_METHOD.REPORT, Protocol.WEBDAV_METHOD.ACL, Protocol.WEBDAV_METHOD.MKCALENDAR);
    }

    public Object creationDate() throws WebdavProtocolException {
        Date now = new Date();
        WebdavResource res = this.createResource();
        ResourceTest.assertEquals((String)Utils.convert((Date)res.getCreationDate()), (String)res.getProperty("DAV:", "creationdate").getValue());
        ResourceTest.assertEquals(now, res.getCreationDate(), 1000);
        try {
            Thread.sleep(1010L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        res.save();
        res = res.reload();
        ResourceTest.assertEquals(now, res.getCreationDate(), 1000);
        return null;
    }

    public Object displayName() throws WebdavProtocolException {
        return null;
    }

    public Object contentLanguage() throws WebdavProtocolException {
        return null;
    }

    public Object contentLength() throws WebdavProtocolException {
        WebdavResource res = this.createResource();
        Long defaultLength = 0L;
        ResourceTest.assertEquals((String)("" + res.getLength()), (String)res.getProperty("DAV:", "getcontentlength").getValue());
        ResourceTest.assertEquals((Object)defaultLength, (Object)res.getLength());
        try {
            res.setLength(Long.valueOf(1L));
        }
        catch (OXException e) {
            e.printStackTrace();
            ResourceTest.fail((String)e.toString());
        }
        res.save();
        res = res.reload();
        ResourceTest.assertEquals((String)("" + res.getLength()), (String)res.getProperty("DAV:", "getcontentlength").getValue());
        ResourceTest.assertEquals((Object)1L, (Object)res.getLength());
        WebdavProperty prop = Protocol.GETCONTENTLENGTH_LITERAL.getWebdavProperty();
        prop.setValue("2");
        res.putProperty(prop);
        ResourceTest.assertEquals((String)("" + res.getLength()), (String)res.getProperty("DAV:", "getcontentlength").getValue());
        ResourceTest.assertEquals((Object)2L, (Object)res.getLength());
        String content = "Hello, I'm the content!";
        byte[] bytes = "Hello, I'm the content!".getBytes(Charsets.UTF_8);
        res.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(bytes));
        ResourceTest.assertEquals((int)bytes.length, (int)((int)res.getLength().longValue()));
        return null;
    }

    public Object contentType() throws WebdavProtocolException {
        WebdavResource res = this.createResource();
        res.setContentType("text/plain");
        res.save();
        res = res.reload();
        ResourceTest.assertEquals((String)"text/plain", (String)res.getContentType());
        ResourceTest.assertEquals((String)res.getContentType(), (String)res.getProperty("DAV:", "getcontenttype").getValue());
        WebdavProperty prop = Protocol.GETCONTENTTYPE_LITERAL.getWebdavProperty();
        prop.setValue("text/html");
        res.putProperty(prop);
        ResourceTest.assertEquals((String)"text/html", (String)res.getContentType());
        ResourceTest.assertEquals((String)res.getContentType(), (String)res.getProperty("DAV:", "getcontenttype").getValue());
        return null;
    }

    public Object etag() throws WebdavProtocolException {
        WebdavResource res = this.createResource();
        ResourceTest.assertEquals((String)res.getETag(), (String)res.getProperty("DAV:", "getetag").getValue());
        res.setDisplayName("one");
        String eTag = res.getETag();
        res.save();
        res = res.reload();
        ResourceTest.assertEquals((String)res.getETag(), (String)res.getProperty("DAV:", "getetag").getValue());
        ResourceTest.assertEquals((String)eTag, (String)res.getETag());
        String text = "Hallo";
        byte[] bytes = "Hallo".getBytes(Charsets.UTF_8);
        try {
            res.putBody((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (OXException e) {
            e.printStackTrace();
            ResourceTest.fail((String)e.toString());
        }
        res.save();
        ResourceTest.assertFalse((boolean)eTag.equals(res.getETag()));
        return null;
    }

    public Object lastModified() throws WebdavProtocolException {
        Date now = new Date();
        WebdavResource res = this.createResource();
        ResourceTest.assertEquals((String)Utils.convert((Date)res.getLastModified()), (String)res.getProperty("DAV:", "getlastmodified").getValue());
        ResourceTest.assertEquals(now, res.getLastModified(), 1000);
        try {
            Thread.sleep(1010L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        now = new Date();
        res.setDisplayName(res.getDisplayName());
        res.save();
        ResourceTest.assertEquals(now, res.getLastModified(), 1000);
        return null;
    }

    public Object resourceType() throws WebdavProtocolException {
        WebdavResource res = this.createResource();
        ResourceTest.assertNotNull((Object)res.getProperty("DAV:", "resourcetype"));
        ResourceTest.assertNull((Object)res.getProperty("DAV:", "resourcetype").getValue());
        ResourceTest.assertEquals(null, (String)res.getResourceType());
        return null;
    }

    public Object lockDiscovery() throws WebdavProtocolException {
        return null;
    }

    public Object supportedLock() throws WebdavProtocolException {
        return null;
    }

    public Object source() throws WebdavProtocolException {
        return null;
    }
}

