/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockAction;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavIfAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.util.List;
import java.util.Map;

public class IfTest
extends ActionTestCase {
    private MockAction mockAction;
    private WebdavPath INDEX_HTML_URL;

    public void testETag() throws Exception {
        String etag = this.factory.resolveResource(this.INDEX_HTML_URL).getETag();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "([" + etag + "])");
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfTest.assertTrue((boolean)this.mockAction.wasActivated());
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "([i_don_t_match])");
        this.mockAction.setActivated(false);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfTest.fail((String)"Expected Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            IfTest.assertEquals((int)412, (int)x.getStatus());
            IfTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testLockedResource() throws Exception {
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        WebdavLock lock = new WebdavLock();
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setTimeout(-1L);
        resource.lock(lock);
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "(<" + lock.getToken() + ">)");
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfTest.assertTrue((boolean)this.mockAction.wasActivated());
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "(<" + lock.getToken() + ">)");
        this.mockAction.setActivated(false);
        resource.unlock(lock.getToken());
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfTest.fail((String)"Expected Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            IfTest.assertEquals((int)412, (int)x.getStatus());
            IfTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testCaptureLocks() throws Exception {
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        WebdavLock lock = new WebdavLock();
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setTimeout(-1L);
        resource.lock(lock);
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "(<" + lock.getToken() + ">)");
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        resource.unlock(lock.getToken());
        IfTest.assertTrue((boolean)this.mockAction.wasActivated());
        Map<String, Object> userInfo = req.getUserInfo();
        List mentionedLocks = (List)userInfo.get("mentionedLocks");
        IfTest.assertNotNull((Object)mentionedLocks);
        IfTest.assertEquals((int)1, (int)mentionedLocks.size());
        IfTest.assertEquals((String)lock.getToken(), (String)((String)mentionedLocks.get(0)));
    }

    public void testOr() throws Exception {
        String etag = this.factory.resolveResource(this.INDEX_HTML_URL).getETag();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "(<no-lock>) ([" + etag + "])");
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testTrue() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "(<opaquelocktoken:blabla>) (Not <no-lock>)");
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testFalse() throws Exception {
        String etag = this.factory.resolveResource(this.INDEX_HTML_URL).getETag();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "([" + etag + "] [no-etag])");
        this.mockAction.setActivated(false);
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.setNext((WebdavAction)this.mockAction);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfTest.fail((String)"Expected Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            IfTest.assertEquals((int)412, (int)x.getStatus());
            IfTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testLockedCollection() throws Exception {
        WebdavCollection collection = this.factory.resolveCollection(this.testCollection);
        WebdavLock lock = new WebdavLock();
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setTimeout(-1L);
        collection.lock(lock);
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.testCollection);
        req.setHeader("If", "(<" + lock.getToken() + ">)");
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfTest.assertTrue((boolean)this.mockAction.wasActivated());
        action.setDefaultDepth(1);
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        res = new MockWebdavResponse();
        this.mockAction.setActivated(false);
        req.setUrl(this.testCollection);
        req.setHeader("If", "(<" + lock.getToken() + ">)");
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfTest.fail((String)"Expected Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            IfTest.assertEquals((int)412, (int)x.getStatus());
            IfTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
        collection.unlock(lock.getToken());
    }

    public void testTagged() throws Exception {
        String etag = this.factory.resolveResource(this.INDEX_HTML_URL).getETag();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.testCollection);
        req.setHeader("If", "<http://localhost/" + this.INDEX_HTML_URL + "> ([" + etag + "])");
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(1);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfTest.assertTrue((boolean)this.mockAction.wasActivated());
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        res = new MockWebdavResponse();
        this.mockAction.setActivated(false);
        req.setUrl(this.testCollection);
        req.setHeader("If", "<http://localhost/" + this.INDEX_HTML_URL + "> ([i_don_t_match])");
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfTest.fail((String)"Expected Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            IfTest.assertEquals((int)412, (int)x.getStatus());
            IfTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testMissingLockToken() throws Exception {
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        WebdavLock lock = new WebdavLock();
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setTimeout(-1L);
        resource.lock(lock);
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.checkSourceLocks(true);
        action.setNext((WebdavAction)this.mockAction);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfTest.fail((String)"Expected Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            IfTest.assertEquals((int)423, (int)x.getStatus());
            IfTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If", "(<12345>) (Not <no-lock>)");
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfTest.fail((String)"Expected Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            IfTest.assertEquals((int)423, (int)x.getStatus());
            IfTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
        WebdavResource r = this.factory.resolveResource(this.INDEX_HTML_URL);
        r.unlock(lock.getToken());
        r.save();
    }

    public void testMissingLockTokenDestination() throws Exception {
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        WebdavLock lock = new WebdavLock();
        lock.setDepth(0);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        lock.setTimeout(-1L);
        resource.lock(lock);
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.testCollection);
        req.setHeader("destination", this.INDEX_HTML_URL.toString());
        WebdavIfAction action = new WebdavIfAction();
        action.setDefaultDepth(0);
        action.checkDestinationLocks(true);
        action.setNext((WebdavAction)this.mockAction);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfTest.fail((String)"Expected Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            IfTest.assertEquals((int)423, (int)x.getStatus());
            IfTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
        WebdavResource r = this.factory.resolveResource(this.INDEX_HTML_URL);
        r.unlock(lock.getToken());
        r.save();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mockAction = new MockAction();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
    }
}

