/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.tx.AbstractActionTest;
import com.openexchange.java.Charsets;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.SaveFileAction;
import com.openexchange.tools.file.external.FileStorageFactory;
import com.openexchange.tools.file.internal.LocalFileStorageFactory;
import com.openexchange.tx.UndoableAction;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;

public class SaveFileActionTest
extends AbstractActionTest {
    private static final String content = "I am the test content";
    private File tempFile;
    private SaveFileAction saveFile = null;
    private FileStorage storage = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.tempFile = File.createTempFile("filestorage", ".tmp");
        this.tempFile.delete();
        FileStorage.setFileStorageStarter((FileStorageFactory)new LocalFileStorageFactory());
    }

    protected void tearDown() throws Exception {
        SaveFileActionTest.rmdir(this.tempFile);
        FileStorage.setFileStorageStarter(null);
        super.tearDown();
    }

    private static void rmdir(File tempFile) {
        if (tempFile.isDirectory()) {
            for (File f : tempFile.listFiles()) {
                SaveFileActionTest.rmdir(f);
            }
        }
        tempFile.delete();
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        this.storage = FileStorage.getInstance((URI)this.tempFile.toURI());
        this.saveFile = new SaveFileAction();
        this.saveFile.setStorage(this.storage);
        this.saveFile.setIn((InputStream)new ByteArrayInputStream(content.getBytes(Charsets.UTF_8)));
        return this.saveFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verifyPerformed() throws Exception {
        SaveFileActionTest.assertTrue((null != this.saveFile.getId() ? 1 : 0) != 0);
        InputStream in = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            in = new BufferedInputStream(this.storage.getFile(this.saveFile.getId()));
            int b = 0;
            while ((b = in.read()) != -1) {
                out.write(b);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            out.close();
        }
        String got = new String(out.toByteArray(), Charsets.UTF_8);
        SaveFileActionTest.assertEquals((String)content, (String)got);
    }

    @Override
    protected void verifyUndone() throws Exception {
        try {
            this.storage.getFile(this.saveFile.getId());
            SaveFileActionTest.fail((String)"Expected Exception");
        }
        catch (OXException x) {
            SaveFileActionTest.assertTrue((boolean)true);
        }
    }
}

