/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.osgi;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.LoginTest;
import com.openexchange.test.osgi.AbstractBundleTest;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public final class BundleTestConfigJump
extends AbstractBundleTest {
    private static final Log LOG = LogFactory.getLog(BundleTestConfigJump.class);
    private static final String BUNDLE_ID = "com.openexchange.configjump.generic";
    private static final String CONTROL_URL = "/ajax/control";

    public BundleTestConfigJump(String name) {
        super(name);
    }

    public void testConfighJumpAbsence() {
        try {
            LoginTest loginTest = new LoginTest("LoginTest");
            JSONObject jsonObject = BundleTestConfigJump.login(this.getWebConversation(), loginTest.getHostName(), loginTest.getLogin(), loginTest.getPassword());
            BundleTestConfigJump.assertTrue((String)"Error contained in returned JSON object", (!jsonObject.has("error") || jsonObject.isNull("error") ? 1 : 0) != 0);
            BundleTestConfigJump.assertTrue((String)"Missing session ID", (jsonObject.has("session") && !jsonObject.isNull("session") ? 1 : 0) != 0);
            String sessionId = jsonObject.getString("session");
            JSONObject configJumpObject = BundleTestConfigJump.readURL(this.getWebConversation(), loginTest.getHostName(), sessionId);
            BundleTestConfigJump.assertTrue((String)"No error contained in returned JSON object", (configJumpObject.has("error") && !configJumpObject.isNull("error") ? 1 : 0) != 0);
            BundleTestConfigJump.assertTrue((String)"Missing error code", (configJumpObject.has("code") && !configJumpObject.isNull("code") ? 1 : 0) != 0);
            BundleTestConfigJump.assertTrue((String)("Unexpected error code: " + configJumpObject.get("code")), (boolean)"LGI-0008".equals(configJumpObject.get("code")));
        }
        catch (Exception e) {
            e.printStackTrace();
            BundleTestConfigJump.fail((String)e.getMessage());
        }
    }

    private static JSONObject readURL(WebConversation conversation, String hostName, String sessionId) throws IOException, SAXException, JSONException {
        JSONObject json;
        LOG.trace((Object)"Reading control center URL.");
        GetMethodWebRequest req = new GetMethodWebRequest("http://" + hostName + CONTROL_URL);
        req.setParameter("session", sessionId);
        WebResponse resp = conversation.getResponse((WebRequest)req);
        BundleTestConfigJump.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        LOG.trace((Object)("Response body: \"" + body + "\""));
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            LOG.error((Object)("Can't parse this body to JSON: \"" + body + '\"'));
            throw e;
        }
        return json;
    }

    @Override
    protected String getBundleName() {
        return BUNDLE_ID;
    }
}

