/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.push.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import junit.framework.TestCase;

public class PushResponseTest
extends TestCase {
    private static String host = "localhost";
    private static int port = 44335;
    private DatagramSocket datagramSocket = null;
    private int folderId = 0;
    private int contextId = 0;

    public PushResponseTest(String name) {
        super(name);
    }

    public PushResponseTest(String name, DatagramSocket datagramSocket, int folderId, int contextId) {
        super(name);
        this.datagramSocket = datagramSocket;
        this.folderId = folderId;
        this.contextId = contextId;
    }

    public void testPushResponse() throws Exception {
        if (this.datagramSocket == null) {
            throw new Exception("DatagramSocket is null");
        }
        PushResponseTest.getResponse(this.datagramSocket, this.folderId, this.contextId);
    }

    public static void getResponse(DatagramSocket datagramSocket, int folderId, int contextId) throws Exception {
        byte[] responseByte = new byte[1024];
        DatagramPacket datagramPacket = new DatagramPacket(responseByte, responseByte.length);
        datagramSocket.receive(datagramPacket);
        responseByte = datagramPacket.getData();
        byte[] responseData = new byte[datagramPacket.getLength()];
        System.arraycopy(responseByte, 0, responseData, 0, responseData.length);
        PushResponseTest.assertEquals((String)"unexpected response", (String)(folderId + "\u0001"), (String)new String(responseData));
    }
}

