/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.tools.file.QuotaFileStorage;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.SortedSet;
import junit.framework.TestCase;

public abstract class UpdateTest
extends TestCase {
    protected Schema schema = null;
    protected int existing_ctx_id = 0;
    protected int user_id = -1;
    protected Context ctx;
    protected User user;
    protected SessionObject session;
    private DBProvider provider;

    public void setUp() throws Exception {
        Init.startServer();
        this.existing_ctx_id = ContextStorage.getInstance().getContextId("defaultcontext");
        this.ctx = ContextStorage.getInstance().getContext(this.existing_ctx_id);
        this.schema = SchemaStore.getInstance().getSchema(this.ctx);
        this.user_id = this.ctx.getMailadmin();
        this.user = UserStorage.getInstance().getUser(this.user_id, this.ctx);
        this.session = SessionObjectWrapper.createSessionObject((int)this.user_id, (int)this.ctx.getContextId(), (String)String.valueOf(System.currentTimeMillis()));
    }

    public void tearDown() throws Exception {
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exec(String sql, Object ... args) throws OXException, SQLException {
        Connection con = null;
        Statement stmt = null;
        try {
            con = Database.get((int)this.existing_ctx_id, (boolean)true);
            stmt = con.prepareStatement(sql);
            int count = 1;
            for (Object o : args) {
                stmt.setObject(count++, o);
            }
            stmt.execute();
        }
        finally {
            if (null != stmt) {
                stmt.close();
            }
            Database.back((int)this.existing_ctx_id, (boolean)true, (Connection)con);
        }
    }

    protected final void execSafe(String sql, Object ... args) {
        try {
            this.exec(sql, args);
        }
        catch (OXException x) {
            x.printStackTrace();
        }
        catch (SQLException x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertNoResults(String sql, Object ... args) throws OXException, SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = Database.get((int)this.existing_ctx_id, (boolean)true);
            stmt = con.prepareStatement(sql);
            int count = 1;
            for (Object o : args) {
                stmt.setObject(count++, o);
            }
            rs = stmt.executeQuery();
            UpdateTest.assertFalse((String)("'" + stmt.toString() + "' shouldn't select anything"), (boolean)rs.next());
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            Database.back((int)this.existing_ctx_id, (boolean)true, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertResult(String sql, Object ... args) throws OXException, SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = Database.get((int)this.existing_ctx_id, (boolean)true);
            stmt = con.prepareStatement(sql);
            int count = 1;
            for (Object o : args) {
                stmt.setObject(count++, o);
            }
            rs = stmt.executeQuery();
            UpdateTest.assertTrue((String)("'" + stmt.toString() + "' should select something"), (boolean)rs.next());
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != stmt) {
                stmt.close();
            }
            Database.back((int)this.existing_ctx_id, (boolean)true, (Connection)con);
        }
    }

    protected final void assertNotInFilestorage(List<String> paths) throws OXException, OXException {
        QuotaFileStorage fs = QuotaFileStorage.getInstance((URI)FilestoreStorage.createURI((Context)this.ctx), (Context)this.ctx);
        SortedSet existingPaths = fs.getFileList();
        for (String path : paths) {
            UpdateTest.assertFalse((boolean)existingPaths.contains(path));
        }
    }

    protected DBProvider getProvider() {
        if (this.provider != null) {
            return this.provider;
        }
        this.provider = this.createProvider();
        return this.provider;
    }

    private DBProvider createProvider() {
        return new UpdateTaskDBProvider();
    }

    private class UpdateTaskDBProvider
    implements DBProvider {
        private UpdateTaskDBProvider() {
        }

        public Connection getReadConnection(Context ctx) throws OXException {
            return Database.get((Context)ctx, (boolean)false);
        }

        public void releaseReadConnection(Context ctx, Connection con) {
            Database.back((Context)ctx, (boolean)false, (Connection)con);
        }

        public Connection getWriteConnection(Context ctx) throws OXException {
            return Database.get((Context)ctx, (boolean)true);
        }

        public void releaseWriteConnection(Context ctx, Connection con) {
            Database.back((Context)ctx, (boolean)true, (Connection)con);
        }
    }
}

