/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.configuration.AJAXConfig;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.event.CommonEvent;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.downgrade.DowngradeEvent;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreDowngrade;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.events.TestEventAdmin;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class InfostoreDowngradeTest
extends TestCase {
    private Context ctx;
    private int folderId;
    private int userId;
    private InfostoreFacade database;
    private ServerSession session;
    private UserConfiguration userConfig;
    private User user;
    private final List<DocumentMetadata> clean = new ArrayList<DocumentMetadata>();

    public void setUp() throws Exception {
        Init.startServer();
        AJAXConfig.init();
        this.ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId("defaultcontext"));
        this.userId = UserStorage.getInstance().getUserId(AJAXConfig.getProperty(AJAXConfig.Property.LOGIN), this.ctx);
        this.user = UserStorage.getInstance().getUser(this.userId, this.ctx);
        this.userConfig = UserConfigurationStorage.getInstance().getUserConfiguration(this.userId, this.ctx);
        OXFolderAccess access = new OXFolderAccess(this.ctx);
        FolderObject fo = access.getDefaultFolder(this.userId, 8);
        this.folderId = fo.getObjectID();
        this.database = new InfostoreFacadeImpl((DBProvider)new DBPoolProvider());
        this.database.setTransactional(true);
        this.session = ServerSessionFactory.createServerSession(this.userId, this.ctx, "Blubb");
        TestEventAdmin.getInstance().clearEvents();
    }

    public void tearDown() throws Exception {
        this.deleteAll();
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelete() {
        UserConfiguration config = new UserConfiguration(0, this.userId, this.userConfig.getGroups(), this.ctx);
        Connection con = null;
        try {
            con = DBPool.pickupWriteable((Context)this.ctx);
            DowngradeEvent event = new DowngradeEvent(config, con, this.ctx);
            new InfostoreDowngrade().downgradePerformed(event);
        }
        catch (OXException x) {
            x.printStackTrace();
            InfostoreDowngradeTest.fail((String)x.getMessage());
        }
        finally {
            if (con != null) {
                DBPool.pushWrite((Context)this.ctx, (Connection)con);
            }
        }
    }

    public void testDowngrade() throws OXException {
        DocumentMetadata dm = this.createDocumentInStandardFolder();
        this.runDelete();
        this.assertNotFound(dm.getId());
        this.assertDeletedEvent(dm.getId());
    }

    private void deleteAll() throws OXException {
        for (DocumentMetadata document : this.clean) {
            this.database.removeDocument(new int[]{document.getId()}, Long.MAX_VALUE, this.session);
        }
    }

    private void assertDeletedEvent(int id) {
        CommonEvent event = TestEventAdmin.getInstance().getNewest();
        InfostoreDowngradeTest.assertEquals((int)3, (int)event.getAction());
        DocumentMetadata dm = (DocumentMetadata)event.getActionObj();
        InfostoreDowngradeTest.assertEquals((int)id, (int)dm.getId());
    }

    private void assertNotFound(int id) {
        try {
            this.database.getDocumentMetadata(id, -1, this.ctx, this.user, this.userConfig);
            InfostoreDowngradeTest.fail((String)"The document still exists!");
        }
        catch (OXException e) {
            InfostoreDowngradeTest.assertEquals((String)e.getMessage(), (int)300, (int)e.getCode());
        }
    }

    private DocumentMetadata createDocumentInStandardFolder() throws OXException {
        DocumentMetadataImpl dm = new DocumentMetadataImpl();
        dm.setTitle("documentInStandardFolder");
        dm.setFolderId((long)this.folderId);
        dm.setId(-1);
        this.database.saveDocumentMetadata((DocumentMetadata)dm, Long.MAX_VALUE, this.session);
        this.clean.add((DocumentMetadata)dm);
        return dm;
    }
}

