/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreDelete;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionFactory;
import java.sql.Connection;
import junit.framework.TestCase;

public class InfostoreDeleteTest
extends TestCase {
    ServerSession session = null;
    DBProvider provider = new DBPoolProvider();
    InfostoreFacade database;
    int myFolder = 0;
    private Context ctx;

    public void setUp() throws Exception {
        Init.startServer();
        TestConfig config = new TestConfig();
        String userName = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        int user = tools.resolveUser(userName, this.ctx);
        this.session = ServerSessionFactory.createServerSession(user, this.ctx, "Blubb");
        this.database = new InfostoreFacadeImpl(this.provider);
        this.database.setTransactional(true);
        OXFolderAccess oxfa = new OXFolderAccess(this.ctx);
        this.myFolder = oxfa.getDefaultFolder(this.session.getUserId(), 8).getObjectID();
    }

    public void tearDown() throws Exception {
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteUser() throws Exception {
        DocumentMetadataImpl metadata = this.createMetadata();
        DeleteEvent delEvent = new DeleteEvent((Object)this, this.session.getUserId(), 1, ContextStorage.getInstance().getContext(this.session.getContextId()));
        Connection con = null;
        try {
            con = this.provider.getWriteConnection(ContextStorage.getInstance().getContext(this.session.getContextId()));
            new InfostoreDelete().deletePerformed(delEvent, con, con);
        }
        finally {
            if (con != null) {
                this.provider.releaseWriteConnection(ContextStorage.getInstance().getContext(this.session.getContextId()), con);
            }
        }
        UserStorage userStorage = UserStorage.getInstance();
        UserConfigurationStorage userConfigStorage = UserConfigurationStorage.getInstance();
        InfostoreDeleteTest.assertFalse((boolean)this.database.exists(metadata.getId(), -1, ContextStorage.getInstance().getContext(this.session.getContextId()), userStorage.getUser(this.session.getUserId(), this.ctx), userConfigStorage.getUserConfiguration(this.session.getUserId(), this.ctx)));
    }

    private DocumentMetadataImpl createMetadata() throws Exception {
        DocumentMetadataImpl metadata = new DocumentMetadataImpl();
        metadata.setTitle("Nice Infoitem");
        metadata.setFolderId((long)this.myFolder);
        this.database.startTransaction();
        try {
            this.database.saveDocumentMetadata((DocumentMetadata)metadata, Long.MAX_VALUE, this.session);
            this.database.commit();
            DocumentMetadataImpl documentMetadataImpl = metadata;
            return documentMetadataImpl;
        }
        catch (Exception x) {
            this.database.rollback();
            throw x;
        }
        finally {
            this.database.finish();
        }
    }
}

