/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.server.services.ServerServiceRegistry;

public class Bug24682Test
extends CalendarSqlTest {
    private int sharedFolderId1;
    private CalendarCollectionService calendarCollectionService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId);
        this.folders.sharePrivateFolder(this.session, this.ctx, this.thirdUserId);
        this.sharedFolderId1 = this.folders.getStandardFolder(this.userId, this.ctx);
        this.calendarCollectionService = (CalendarCollectionService)ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
    }

    public void testBug24682() throws Exception {
        this.appointments.switchUser(this.secondUser);
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.fourthUser);
        appointment.setStartDate(TimeTools.D("01.01.2013 08:00"));
        appointment.setEndDate(TimeTools.D("01.01.2013 10:00"));
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setOccurrence(10);
        appointment.setParentFolderID(this.sharedFolderId1);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject exception = this.appointments.createIdentifyingCopy(appointment);
        exception.setStartDate(TimeTools.D("03.01.2013 09:00"));
        exception.setEndDate(TimeTools.D("03.01.2013 11:00"));
        exception.setTitle("Exception");
        exception.setRecurrencePosition(3);
        this.appointments.save(exception);
        this.appointments.switchUser(this.thirdUser);
        int[] columns = new int[]{1, 20};
        CalendarDataObject[] changeExceptionsByRecurrence = this.calendarCollectionService.getChangeExceptionsByRecurrence(appointment.getObjectID(), columns, this.appointments.getSession());
        Bug24682Test.assertEquals((String)("Wrong folder id" + System.getProperty("line.separator") + changeExceptionsByRecurrence.toString()), (int)this.sharedFolderId1, (int)changeExceptionsByRecurrence[0].getParentFolderID());
    }

    @Override
    public void tearDown() throws Exception {
        this.folders.unsharePrivateFolder(this.session, this.ctx);
        super.tearDown();
    }
}

