/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;
import java.util.Map;

public class Bug23078Test
extends CardDAVTest {
    public Bug23078Test(String name) {
        super(name);
    }

    public void testReportItemsFromDeletedFolder() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String folderName = "testfolder_" + Bug23078Test.randomUID();
        FolderObject subFolder = super.createFolder(folderName);
        super.rememberForCleanUp(subFolder);
        String uid = Bug23078Test.randomUID();
        String firstName = "doktor";
        String lastName = "horst";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, subFolder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug23078Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = Bug23078Test.assertContains(uid, addressData);
        Bug23078Test.assertEquals((String)"N wrong", (String)firstName, (String)contactCard.getGivenName());
        Bug23078Test.assertEquals((String)"N wrong", (String)lastName, (String)contactCard.getFamilyName());
        Bug23078Test.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)contactCard.getFN());
        super.deleteFolder(subFolder);
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        Bug23078Test.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        boolean found = false;
        for (String href : syncCollectionResponse.getHrefsStatusNotFound()) {
            if (null == href || !href.contains(uid)) continue;
            found = true;
            break;
        }
        Bug23078Test.assertTrue((String)"contact not reported as deleted", (boolean)found);
    }
}

