/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.w3c.dom.Node;

public class Bug22689Test
extends CalDAVTest {
    public Bug22689Test(String name) {
        super(name);
    }

    public void testDefaultAlarms() throws Exception {
        String expected = "BEGIN:VALARM\r\nEND:VALARM";
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.DEFAULT_ALARM_VEVENT_DATE);
        props.add(PropertyNames.DEFAULT_ALARM_VEVENT_DATETIME);
        props.add(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SET);
        PropFindMethod propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + "/caldav/", 0, props, 1);
        MultiStatusResponse[] responses = this.getWebDAVClient().doPropFind(propFind);
        Bug22689Test.assertNotNull((String)"got no response", (Object)responses);
        Bug22689Test.assertTrue((String)"got no responses", (0 < responses.length ? 1 : 0) != 0);
        for (MultiStatusResponse response : responses) {
            Node node;
            if (!response.getProperties(200).contains(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SET) || null == (node = this.extractNodeValue(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SET, response)) || null == node.getAttributes() || null == node.getAttributes().getNamedItem("name") || !"VEVENT".equals(node.getAttributes().getNamedItem("name").getTextContent())) continue;
            String defaultAlarmVEventDate = this.extractTextContent(PropertyNames.DEFAULT_ALARM_VEVENT_DATE, response);
            Bug22689Test.assertNotNull((String)"no default alarm", (Object)defaultAlarmVEventDate);
            Bug22689Test.assertEquals((String)"wrong default alarm", (String)"BEGIN:VALARM\r\nEND:VALARM", (String)defaultAlarmVEventDate.trim());
            String defaultAlarmVEventDatetime = this.extractTextContent(PropertyNames.DEFAULT_ALARM_VEVENT_DATETIME, response);
            Bug22689Test.assertNotNull((String)"no default alarm", (Object)defaultAlarmVEventDatetime);
            Bug22689Test.assertEquals((String)"wrong default alarm", (String)"BEGIN:VALARM\r\nEND:VALARM", (String)defaultAlarmVEventDatetime.trim());
        }
    }
}

