/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ICalFile {
    private final List<String[]> lines = new ArrayList<String[]>();

    public ICalFile(Reader reader) throws IOException {
        BufferedReader lines = new BufferedReader(reader);
        String line = null;
        while ((line = lines.readLine()) != null) {
            this.addLine(line);
        }
    }

    private void addLine(String line) {
        String value;
        String parameter;
        String key;
        int colonPos = line.indexOf(58);
        if (-1 == colonPos) {
            key = line;
            parameter = "";
            value = "";
        } else {
            String tmp = line.substring(0, colonPos);
            int semicolonPos = tmp.indexOf(59);
            if (semicolonPos != -1) {
                key = tmp.substring(0, semicolonPos);
                parameter = tmp.substring(semicolonPos + 1);
            } else {
                key = tmp;
                parameter = "";
            }
            value = line.substring(colonPos + 1);
        }
        this.lines.add(new String[]{key, parameter, value});
    }

    public List<String[]> getLines() {
        return this.lines;
    }

    public String getValue(String key) {
        for (String[] line : this.lines) {
            if (!line[0].equals(key)) continue;
            return line[2];
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String[] line : this.lines) {
            String key = line[0];
            String parameter = line[1];
            String value = line[2];
            sb.append(key);
            if (!"".equals(parameter)) {
                sb.append(';');
                sb.append(parameter);
            }
            if (!"".equals(value)) {
                sb.append(':');
                sb.append(value);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public boolean containsPair(String name, String value) {
        for (String[] line : this.lines) {
            String key = line[0];
            String val = line[2];
            if (!key.equals(name) || !val.equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntry(String name, String parameter, String value) {
        for (String[] line : this.lines) {
            String key = line[0];
            String param = line[1];
            String val = line[2];
            if (!key.equals(name) || !param.equals(parameter) || !val.equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsLine(String line) {
        for (String[] l : this.lines) {
            String key = l[0];
            if (!key.equals(line)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String key) {
        return this.containsLine(key);
    }
}

