/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import com.openexchange.data.conversion.ical.ICalFile;
import com.openexchange.data.conversion.ical.Tools;
import java.util.Date;
import java.util.TimeZone;

public class Assert
extends junit.framework.Assert {
    private Assert() {
    }

    public static void assertStandardAppFields(ICalFile ical, Date start, Date end, TimeZone tz) {
        Assert.assertProperty(ical, "DTSTART", "TZID=" + tz.getID(), Tools.formatForICalWithoutTimezone(start));
        Assert.assertProperty(ical, "DTEND", "TZID=" + tz.getID(), Tools.formatForICalWithoutTimezone(end));
    }

    public static void assertStandardTaskFields(ICalFile ical, Date start, Date end, TimeZone tz) {
        Assert.assertProperty(ical, "DTSTART", "TZID=" + tz.getID(), Tools.formatForICalWithoutTimezone(start));
        Assert.assertProperty(ical, "DUE", "TZID=" + tz.getID(), Tools.formatForICalWithoutTimezone(end));
    }

    public static void assertStandardAppFields(ICalFile ical, Date start, Date end) {
        Assert.assertProperty(ical, "DTSTART", Tools.formatForICal(start));
        Assert.assertProperty(ical, "DTEND", Tools.formatForICal(end));
    }

    public static void assertStandardTaskFields(ICalFile ical, Date start, Date end) {
        Assert.assertProperty(ical, "DTSTART", Tools.formatForICal(start));
        Assert.assertProperty(ical, "DUE", Tools.formatForICal(end));
    }

    public static void assertProperty(ICalFile ical, String name, String value) {
        Assert.assertTrue((String)(name + " missing in: \n" + ical.toString()), (boolean)ical.containsPair(name, value));
    }

    public static void assertProperty(ICalFile ical, String name, String parameter, String value) {
        Assert.assertTrue((String)(name + " missing in: \n" + ical.toString()), (boolean)ical.containsEntry(name, parameter, value));
    }

    public static void assertNoProperty(ICalFile ical, String name) {
        Assert.assertFalse((String)("Didn't expect to find " + name + " in: \n" + ical.toString()), (boolean)ical.containsKey(name));
    }

    public static void assertLine(ICalFile ical, String line) {
        Assert.assertTrue((String)(line + " missing in: \n" + ical.toString()), (boolean)ical.containsLine(line));
    }
}

