/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.groupware.tasks.Task;
import java.util.TimeZone;
import junit.framework.AssertionFailedError;

public class TaskDurationAndCostsTest
extends AbstractAJAXSession {
    private AJAXClient client;
    private Task task;
    private TimeZone tz;

    public TaskDurationAndCostsTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.task = new Task();
        this.task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        this.task.setTitle("Set task duration and costs test");
        this.task.setActualDuration(Long.valueOf(2L));
        this.task.setActualCosts(Float.valueOf(2.0f));
        this.task.setTargetDuration(Long.valueOf(10L));
        this.task.setTargetCosts(Float.valueOf(10.0f));
        InsertRequest request = new InsertRequest(this.task, this.tz);
        InsertResponse response = this.client.execute(request);
        response.fillTask(this.task);
    }

    @Override
    public void tearDown() throws Exception {
        DeleteRequest req = new DeleteRequest(this.task);
        this.client.execute(req);
    }

    public void testDurationAndCosts() throws Exception {
        this.task.setTargetCosts(Float.valueOf(11.5f));
        this.task.setActualCosts(Float.valueOf(4.728f));
        this.task.setActualDuration(Long.valueOf(7L));
        this.task.setTargetDuration(Long.valueOf(15L));
        UpdateRequest req = new UpdateRequest(this.task, this.tz, false);
        try {
            UpdateResponse response = this.client.execute(req);
            this.task.setLastModified(response.getTimestamp());
        }
        catch (AssertionFailedError e) {
            TaskDurationAndCostsTest.fail((String)"Setting costs and duration failed!");
        }
        GetRequest request = new GetRequest(this.task);
        GetResponse response = this.client.execute(request);
        this.task.setLastModified(response.getTimestamp());
        Task test = response.getTask(this.tz);
        TaskDurationAndCostsTest.assertEquals((String)"Actual costs not equal", (float)test.getActualCosts().floatValue(), (float)this.task.getActualCosts().floatValue(), (float)0.01f);
        TaskDurationAndCostsTest.assertEquals((String)"Target costs not equal", (float)test.getTargetCosts().floatValue(), (float)this.task.getTargetCosts().floatValue(), (float)0.01f);
        TaskDurationAndCostsTest.assertEquals((String)"Actual duration not equal", (Object)test.getActualDuration(), (Object)this.task.getActualDuration());
        TaskDurationAndCostsTest.assertEquals((String)"Target duration not equal", (Object)test.getTargetDuration(), (Object)this.task.getTargetDuration());
    }
}

