/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount;

import com.openexchange.ajax.mailaccount.AbstractMailAccountTest;
import com.openexchange.ajax.mailaccount.actions.MailAccountValidateRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountValidateResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.MailAccountDescription;
import java.io.IOException;
import org.json.JSONException;

public class MailAccountValidateTest
extends AbstractMailAccountTest {
    public MailAccountValidateTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.mailAccountDescription && 0 != this.mailAccountDescription.getId()) {
            this.deleteMailAccount();
        }
        super.tearDown();
    }

    public void testValidate() throws OXException, IOException, JSONException, OXException {
        MailAccountDescription mailAccountDescription = MailAccountValidateTest.createMailAccountObject();
        MailAccountValidateResponse response = this.getClient().execute(new MailAccountValidateRequest(mailAccountDescription));
        MailAccountValidateTest.assertFalse((String)"Invalid IP/hostname in mail account succesfully passed validation but shouldn't", (boolean)response.isValidated());
        mailAccountDescription.setMailServer("imap.open-xchange.com");
        mailAccountDescription.setMailPort(143);
        response = this.getClient().execute(new MailAccountValidateRequest(mailAccountDescription));
        MailAccountValidateTest.assertFalse((String)"Invalid credentials in mail account succesfully passed validation but shouldn't", (boolean)response.isValidated());
        mailAccountDescription.setMailServer("imap.googlemail.com");
        mailAccountDescription.setMailPort(993);
        mailAccountDescription.setMailProtocol("imap");
        mailAccountDescription.setMailSecure(true);
        response = this.getClient().execute(new MailAccountValidateRequest(mailAccountDescription));
        MailAccountValidateTest.assertFalse((String)"Invalid credentials in mail account succesfully passed validation but shouldn't", (boolean)response.isValidated());
        try {
            MailConfig.init();
        }
        catch (OXException e) {
            e.printStackTrace();
            MailAccountValidateTest.fail((String)e.getMessage());
        }
        mailAccountDescription.setMailServer(MailConfig.getProperty(MailConfig.Property.SERVER));
        mailAccountDescription.setMailPort(Integer.parseInt(MailConfig.getProperty(MailConfig.Property.PORT)));
        mailAccountDescription.setMailProtocol("imap");
        mailAccountDescription.setMailSecure(false);
        mailAccountDescription.setLogin(MailConfig.getProperty(MailConfig.Property.LOGIN));
        mailAccountDescription.setPassword(MailConfig.getProperty(MailConfig.Property.PASSWORD));
        mailAccountDescription.setTransportServer((String)null);
        response = this.getClient().execute(new MailAccountValidateRequest(mailAccountDescription));
        MailAccountValidateTest.assertTrue((String)"Valid access data in mail account do not pass validation but should", (boolean)response.isValidated());
        mailAccountDescription.setMailServer(MailConfig.getProperty(MailConfig.Property.SERVER));
        mailAccountDescription.setMailPort(Integer.parseInt(MailConfig.getProperty(MailConfig.Property.PORT)));
        mailAccountDescription.setMailProtocol("imap");
        mailAccountDescription.setMailSecure(false);
        mailAccountDescription.setLogin(MailConfig.getProperty(MailConfig.Property.LOGIN));
        mailAccountDescription.setPassword(MailConfig.getProperty(MailConfig.Property.PASSWORD));
        mailAccountDescription.setTransportServer(MailConfig.getProperty(MailConfig.Property.SERVER));
        mailAccountDescription.setTransportPort(25);
        mailAccountDescription.setTransportProtocol("smtp");
        mailAccountDescription.setTransportSecure(false);
        response = this.getClient().execute(new MailAccountValidateRequest(mailAccountDescription));
        MailAccountValidateTest.assertTrue((String)"Valid access data in mail/transport account do not pass validation but should", (boolean)response.isValidated());
    }
}

