/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.UpdateMailResponse;
import java.util.LinkedList;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateMailRequest
extends AbstractMailRequest<UpdateMailResponse> {
    private String folderID;
    private String mailID;
    private int flags;
    private int color;
    private boolean removeFlags;
    private boolean failOnError;
    private boolean messageId;

    public UpdateMailRequest setMessageId(boolean messageId) {
        this.messageId = messageId;
        return this;
    }

    public boolean doesFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public String getFolderID() {
        return this.folderID;
    }

    public void setFolderID(String folderID) {
        this.folderID = folderID;
    }

    public String getMailID() {
        return this.mailID;
    }

    public void setMailID(String mailID) {
        this.mailID = mailID;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public boolean doesRemoveFlags() {
        return this.removeFlags;
    }

    public void removeFlags() {
        this.removeFlags = true;
    }

    public boolean doesUpdateFlags() {
        return !this.removeFlags;
    }

    public void updateFlags() {
        this.removeFlags = false;
    }

    public UpdateMailRequest(String folderID) {
        this.folderID = folderID;
    }

    public UpdateMailRequest(String folderID, String mailID) {
        this.folderID = folderID;
        this.mailID = mailID;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("color_label", this.color);
        json.put("flags", this.flags);
        json.put("value", !this.removeFlags);
        return json;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", "update"));
        list.add(new AJAXRequest.Parameter("folder", this.folderID));
        if (null != this.mailID) {
            list.add(new AJAXRequest.Parameter(this.messageId ? "message_id" : "id", this.mailID));
        }
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends UpdateMailResponse> getParser() {
        return new AbstractAJAXParser<UpdateMailResponse>(this.failOnError){

            @Override
            protected UpdateMailResponse createResponse(Response response) throws JSONException {
                return new UpdateMailResponse(response);
            }
        };
    }
}

