/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.MailFlag;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug16141Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private String folder;
    private UserValues values;
    private final String[][] ids = null;
    private String testMailDir;
    private String address;

    public Bug16141Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.values = this.client.getValues();
        this.folder = this.values.getInboxFolder();
        this.address = this.client.getValues().getSendAddress();
        this.testMailDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
    }

    public void testMailImport() throws Exception {
        InputStream[] is = this.createABunchOfMails();
        ImportMailRequest importReq = new ImportMailRequest(this.folder, MailFlag.SEEN.getValue(), is);
        ImportMailResponse importResp = this.client.execute(importReq);
        JSONArray json = (JSONArray)importResp.getData();
        int err = 0;
        System.out.println("Huhuhuhuhuhuhuhu1234");
        System.out.println(importResp.getData());
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jo = json.getJSONObject(i);
            if (!jo.has("Error")) continue;
            ++err;
        }
        if (err != 1) {
            Bug16141Test.fail((String)"Number of corrupt mails is wrong");
        }
        if (json.length() - err != 3) {
            Bug16141Test.fail((String)"Import did not run til end.");
        }
    }

    private InputStream[] createABunchOfMails() {
        ArrayList<InputStream> retval = new ArrayList<InputStream>(4);
        for (String fileName : new String[]{"bug16141_1.eml", "bug16141_2.eml", "bug16141_3.eml", "bug16141_4.eml"}) {
            try {
                retval.add(this.getMailAndReplaceAddress(fileName));
            }
            catch (IOException e) {
                Bug16141Test.fail((String)e.getMessage());
            }
        }
        return retval.toArray(new InputStream[retval.size()]);
    }

    private InputStream getMailAndReplaceAddress(String fileName) throws IOException {
        int length;
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(new File(this.testMailDir, fileName)), "UTF-8");
        char[] buf = new char[512];
        StringBuilder sb = new StringBuilder();
        while ((length = isr.read(buf)) != -1) {
            sb.append(buf, 0, length);
        }
        return new ByteArrayInputStream(TestMails.replaceAddresses(sb.toString(), this.address).getBytes(Charsets.UTF_8));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.ids != null) {
            this.client.execute(new DeleteRequest(this.ids));
        }
        super.tearDown();
    }
}

