/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.attach.actions.AttachRequest;
import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import java.io.ByteArrayInputStream;

public class NewTest
extends AbstractContactTest {
    public NewTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testNew() throws Exception {
        Contact contactObj = this.createContactObject("testNew");
        this.insertContact(contactObj);
    }

    public void testNewWithDistributionList() throws Exception {
        Contact contactEntry = this.createContactObject("internal contact");
        contactEntry.setEmail1("internalcontact@x.de");
        int contactId = this.insertContact(contactEntry);
        contactEntry.setObjectID(contactId);
        this.createContactWithDistributionList("testNewWithDistributionList", contactEntry);
    }

    public void testNewWithLinks() throws Exception {
        Contact link1 = this.createContactObject("link1");
        Contact link2 = this.createContactObject("link2");
        int linkId1 = this.insertContact(link1);
        link1.setObjectID(linkId1);
        int linkId2 = this.insertContact(link2);
        link2.setObjectID(linkId2);
        this.createContactWithLinks("testNewWithLinks", link1, link2);
    }

    public void testNewContactWithAttachment() throws Exception {
        Contact contactObj = this.createContactObject("testNewContactWithAttachment");
        int objectId = this.insertContact(contactObj);
        contactObj.setObjectID(objectId);
        AttachmentImpl attachmentObj = new AttachmentImpl();
        attachmentObj.setFilename(System.currentTimeMillis() + "test1.txt");
        attachmentObj.setModuleId(7);
        attachmentObj.setAttachedId(objectId);
        attachmentObj.setFolderId(this.contactFolderId);
        attachmentObj.setRtfFlag(false);
        attachmentObj.setFileMIMEType("plain/text");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("t1".getBytes());
        AttachRequest request1 = new AttachRequest((CommonObject)contactObj, System.currentTimeMillis() + "test1.txt", byteArrayInputStream, "plain/text");
        this.client.execute(request1);
        contactObj.setNumberOfAttachments(1);
        byteArrayInputStream = new ByteArrayInputStream("t2".getBytes());
        AttachRequest request2 = new AttachRequest((CommonObject)contactObj, System.currentTimeMillis() + "test1.txt", byteArrayInputStream, "plain/text");
        this.client.execute(request2);
        contactObj.setNumberOfAttachments(2);
        Contact loadContact = this.loadContact(objectId, this.contactFolderId);
        this.compareObject(contactObj, loadContact);
    }
}

