/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.appointment.action.UpdatesRequest;
import com.openexchange.ajax.appointment.action.UpdatesResponse;
import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class SharedFoldersShowOwnersPrivateAppointmentsAsBlocks
extends ManagedAppointmentTest {
    private static final int[] COLUMNS = new int[]{1, 20, 200, 201, 202};
    private AJAXClient client1;
    private AJAXClient client2;
    private FolderObject sharedFolder;
    private Date start;
    private Date end;
    private Date startRange;
    private Date endRange;
    private String privateAppointmentTitle;
    private String publicAppointmentTitle;
    private int privateAppointmentID;
    private int publicAppointmentID;
    private Appointment privateAppointment;
    private Appointment publicAppointment;

    public SharedFoldersShowOwnersPrivateAppointmentsAsBlocks(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client1 = this.getClient();
        AJAXClient.User user2 = AJAXClient.User.User2;
        this.client2 = new AJAXClient(user2);
        UserValues values = this.client1.getValues();
        int module = Module.CALENDAR.getFolderConstant();
        this.sharedFolder = this.folderManager.generateSharedFolder("us1601_shared_" + new Date().getTime(), module, values.getPrivateAppointmentFolder(), values.getUserId(), this.client2.getValues().getUserId());
        this.folderManager.insertFolderOnServer(this.sharedFolder);
        this.start = this.D("13.01.2010 07:00");
        this.end = this.D("13.01.2010 07:30");
        this.startRange = this.D("12.01.2010 07:00");
        this.endRange = this.D("14.01.2010 07:30");
        this.privateAppointmentTitle = "This should be private";
        this.privateAppointment = new Appointment();
        this.privateAppointment.setParentFolderID(this.sharedFolder.getObjectID());
        this.privateAppointment.setTitle(this.privateAppointmentTitle);
        this.privateAppointment.setStartDate(this.start);
        this.privateAppointment.setEndDate(this.end);
        this.privateAppointment.setPrivateFlag(true);
        this.calendarManager.insert(this.privateAppointment);
        this.privateAppointmentID = this.privateAppointment.getObjectID();
        this.publicAppointmentTitle = "This should be public";
        this.publicAppointment = new Appointment();
        this.publicAppointment.setParentFolderID(this.sharedFolder.getObjectID());
        this.publicAppointment.setTitle(this.publicAppointmentTitle);
        this.publicAppointment.setStartDate(this.start);
        this.publicAppointment.setEndDate(this.end);
        this.publicAppointment.setPrivateFlag(false);
        this.calendarManager.insert(this.publicAppointment);
        this.publicAppointmentID = this.publicAppointment.getObjectID();
    }

    public void testShouldFindABlockForAPrivateAppointmentViaAll() throws Exception {
        CommonAllResponse response = this.client2.execute(new AllRequest(this.sharedFolder.getObjectID(), COLUMNS, this.startRange, this.endRange, TimeZone.getDefault(), true, true));
        int namePos = response.getColumnPos(200);
        Object[][] objects = response.getArray();
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertEquals((String)"Should find two elements, a private and a public one", (int)2, (int)objects.length);
        Object[] app1 = objects[0];
        Object[] app2 = objects[1];
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertTrue((String)"One of the two should be the public one", (app1[namePos].equals(this.publicAppointmentTitle) || app2[namePos].equals(this.publicAppointmentTitle) ? 1 : 0) != 0);
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertFalse((String)"None of the two should be the private title", (app1[namePos].equals(this.privateAppointmentTitle) || app2[namePos].equals(this.privateAppointmentTitle) ? 1 : 0) != 0);
    }

    public void testShouldFindABlockForAPrivateAppointmentViaList() throws Exception {
        CommonListResponse response = this.client2.execute(new ListRequest(ListIDs.l({this.sharedFolder.getObjectID(), this.publicAppointmentID}, {this.sharedFolder.getObjectID(), this.privateAppointmentID}), COLUMNS, true));
        int namePos = response.getColumnPos(200);
        Object[][] objects = response.getArray();
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertEquals((String)"Should find two elements, a private and a public one", (int)2, (int)objects.length);
        Object[] app1 = objects[0];
        Object[] app2 = objects[1];
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertTrue((String)"One of the two should be the public one", (app1[namePos].equals(this.publicAppointmentTitle) || app2[namePos].equals(this.publicAppointmentTitle) ? 1 : 0) != 0);
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertFalse((String)"None of the two should be the private title", (app1[namePos].equals(this.privateAppointmentTitle) || app2[namePos].equals(this.privateAppointmentTitle) ? 1 : 0) != 0);
    }

    public void testShouldFindABlockForAPrivateAppointmentViaUpdates() throws Exception {
        UpdatesResponse response = this.client2.execute(new UpdatesRequest(this.sharedFolder.getObjectID(), COLUMNS, new Date(this.privateAppointment.getLastModified().getTime() - 1L), true, true));
        int namePos = response.getColumnPos(200);
        Object[][] objects = response.getArray();
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertEquals((String)"Should find two elements, a private and a public one", (int)2, (int)objects.length);
        Object[] app1 = objects[0];
        Object[] app2 = objects[1];
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertTrue((String)"One of the two should be the public one", (app1[namePos].equals(this.publicAppointmentTitle) || app2[namePos].equals(this.publicAppointmentTitle) ? 1 : 0) != 0);
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertFalse((String)"None of the two should be the private title", (app1[namePos].equals(this.privateAppointmentTitle) || app2[namePos].equals(this.privateAppointmentTitle) ? 1 : 0) != 0);
    }

    public void testShouldNotAnonymizeOwnPrivateAppointments() throws OXException, IOException, SAXException, JSONException {
        CommonListResponse response = this.client1.execute(new ListRequest(ListIDs.l({this.sharedFolder.getObjectID(), this.publicAppointmentID}, {this.sharedFolder.getObjectID(), this.privateAppointmentID}), COLUMNS, true));
        int namePos = response.getColumnPos(200);
        Object[][] objects = response.getArray();
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertEquals((String)"Should find two elements, a private and a public one", (int)2, (int)objects.length);
        Object[] app1 = objects[0];
        Object[] app2 = objects[1];
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertTrue((String)"One of the two should be the public one", (app1[namePos].equals(this.publicAppointmentTitle) || app2[namePos].equals(this.publicAppointmentTitle) ? 1 : 0) != 0);
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertTrue((String)"One should be the _unchanged_ private one", (app1[namePos].equals(this.privateAppointmentTitle) || app2[namePos].equals(this.privateAppointmentTitle) ? 1 : 0) != 0);
    }

    public void testShouldNotAllowToGetFullPrivateAppointmentsForNonOwner() throws Exception, Exception, Exception, Exception {
        GetResponse response = this.client2.execute(new GetRequest(this.privateAppointment));
        Appointment expected = response.getAppointment(this.timeZone);
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertFalse((String)"Title should be anonymized", (boolean)this.privateAppointmentTitle.equals(expected.getTitle()));
    }

    public void testShouldStillAllowToGetFullPrivateAppointmentsForOwner() throws Exception, Exception, Exception, Exception {
        GetResponse response = this.client1.execute(new GetRequest(this.privateAppointment));
        Appointment expected = response.getAppointment(this.timeZone);
        SharedFoldersShowOwnersPrivateAppointmentsAsBlocks.assertTrue((String)"Title should not be anonymized", (boolean)this.privateAppointmentTitle.equals(expected.getTitle()));
    }

    public void testShouldShowRecurrences() throws Exception {
    }
}

