/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.json.JSONArray;

public class AllAliasTest
extends AppointmentTest {
    private Appointment appointment;
    private AJAXClient client;

    public AllAliasTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.appointment = new Appointment();
        this.appointment.setStartDate(new Date());
        this.appointment.setEndDate(new Date(System.currentTimeMillis() + 0x6DDD00L));
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setTitle("All Alias Test Appointment");
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.client.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.client.execute(insertRequest);
        insertResponse.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        DeleteRequest deleteRequest = new DeleteRequest(this.appointment);
        this.client.execute(deleteRequest);
        super.tearDown();
    }

    public void testAllAlias() throws Exception {
        AllRequest allAliasRequest = new AllRequest(this.client.getValues().getPrivateAppointmentFolder(), "all", new Date(0L), new Date(Long.MAX_VALUE), this.client.getValues().getTimeZone());
        CommonAllResponse allAliasResponse = this.client.execute(allAliasRequest);
        Object[][] aliasAppointments = allAliasResponse.getArray();
        AllRequest allRequest = new AllRequest(this.client.getValues().getPrivateAppointmentFolder(), new int[]{1, 20, 207, 206, 2}, new Date(0L), new Date(Long.MAX_VALUE), this.client.getValues().getTimeZone());
        CommonAllResponse allResponse = this.client.execute(allRequest);
        Object[][] appointments = allResponse.getArray();
        AllAliasTest.assertEquals((String)"Arrays' sizes are not equal.", (int)aliasAppointments.length, (int)appointments.length);
        for (int i = 0; i < aliasAppointments.length; ++i) {
            Object[] o1 = aliasAppointments[i];
            Object[] o2 = appointments[i];
            AllAliasTest.assertEquals((String)"Objects' sizes are not equal.", (int)o1.length, (int)o2.length);
            for (int j = 0; j < o1.length; ++j) {
                if (o1[j] == null && o2[j] == null) continue;
                if (!(o1[j] instanceof JSONArray) && !(o2[j] instanceof JSONArray)) {
                    AllAliasTest.assertEquals((String)("Array[" + i + "][" + j + "] not equal."), (Object)o1[j], (Object)o2[j]);
                    continue;
                }
                this.compareArrays((JSONArray)o1[j], (JSONArray)o2[j]);
            }
        }
    }

    private void compareArrays(JSONArray o1, JSONArray o2) throws Exception {
        if (o1.length() != o2.length()) {
            AllAliasTest.fail((String)"Arrays' sizes are not equal.");
        }
        for (int i = 0; i < o1.length(); ++i) {
            if (o1.get(i) == null && o2.get(i) == null) continue;
            if (!(o1.get(i) instanceof JSONArray) && !(o2.get(i) instanceof JSONArray)) {
                AllAliasTest.assertEquals((String)("Array[" + i + "] not equal."), (String)o1.get(i).toString(), (String)o2.get(i).toString());
                continue;
            }
            this.compareArrays((JSONArray)o1.get(i), (JSONArray)o2.get(i));
        }
    }
}

