/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.sql;

import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.DBTransactionPolicy;
import com.openexchange.datatypes.genericonf.storage.GenericConfigurationStorageService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Autoboxing;
import com.openexchange.sql.builder.StatementBuilder;
import com.openexchange.sql.grammar.Command;
import com.openexchange.sql.grammar.Constant;
import com.openexchange.sql.grammar.DELETE;
import com.openexchange.sql.grammar.EQUALS;
import com.openexchange.sql.grammar.Expression;
import com.openexchange.sql.grammar.IN;
import com.openexchange.sql.grammar.INSERT;
import com.openexchange.sql.grammar.LIST;
import com.openexchange.sql.grammar.Predicate;
import com.openexchange.sql.grammar.SELECT;
import com.openexchange.sql.grammar.UPDATE;
import com.openexchange.sql.schema.Tables;
import com.openexchange.subscribe.EncryptedField;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionErrorMessage;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.SubscriptionStorage;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubscriptionSQLStorage
implements SubscriptionStorage {
    private final DBProvider dbProvider;
    private final DBTransactionPolicy txPolicy;
    private final GenericConfigurationStorageService storageService;
    private final SubscriptionSourceDiscoveryService discoveryService;

    public SubscriptionSQLStorage(DBProvider dbProvider, GenericConfigurationStorageService storageService, SubscriptionSourceDiscoveryService discoveryService) {
        this(dbProvider, DBTransactionPolicy.NORMAL_TRANSACTIONS, storageService, discoveryService);
    }

    public SubscriptionSQLStorage(DBProvider dbProvider, DBTransactionPolicy txPolicy, GenericConfigurationStorageService storageService, SubscriptionSourceDiscoveryService discoveryService) {
        this.dbProvider = dbProvider;
        this.txPolicy = txPolicy;
        this.storageService = storageService;
        this.discoveryService = discoveryService;
    }

    @Override
    public void forgetSubscription(Subscription subscription) throws OXException {
        if (!this.exist(subscription.getId(), subscription.getContext())) {
            return;
        }
        Connection writeConnection = null;
        boolean rollback = false;
        try {
            writeConnection = this.dbProvider.getWriteConnection(subscription.getContext());
            this.txPolicy.setAutoCommit(writeConnection, false);
            rollback = true;
            this.delete(subscription, writeConnection);
            this.txPolicy.commit(writeConnection);
            rollback = false;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            if (writeConnection != null) {
                if (rollback) {
                    Databases.rollback((Connection)writeConnection);
                }
                Databases.autocommit((Connection)writeConnection);
                this.dbProvider.releaseWriteConnection(subscription.getContext(), writeConnection);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Subscription getSubscription(Context ctx, int id) throws OXException {
        Subscription retval = null;
        Connection readConnection = null;
        ResultSet resultSet = null;
        StatementBuilder builder = null;
        try {
            readConnection = this.dbProvider.getReadConnection(ctx);
            SELECT select = new SELECT(new String[]{"id", "user_id", "configuration_id", "source_id", "folder_id", "last_update", "enabled"}).FROM(Tables.subscriptions).WHERE(new EQUALS("id", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("cid", (Expression)Constant.PLACEHOLDER)));
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(Autoboxing.I((int)id));
            values.add(Autoboxing.I((int)ctx.getContextId()));
            builder = new StatementBuilder();
            resultSet = builder.executeQuery(readConnection, (Command)select, values);
            List<Subscription> subscriptions = this.parseResultSet(resultSet, ctx, readConnection);
            if (subscriptions.size() != 0) {
                retval = subscriptions.get(0);
            }
        }
        catch (SQLException e) {
            try {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (builder == null) throw throwable;
                    builder.closePreparedStatement(null, resultSet);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw SubscriptionErrorMessage.SQLException.create(e2, new Object[0]);
                }
                finally {
                    this.dbProvider.releaseReadConnection(ctx, readConnection);
                }
            }
        }
        try {
            if (builder == null) return retval;
            builder.closePreparedStatement(null, resultSet);
            return retval;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            this.dbProvider.releaseReadConnection(ctx, readConnection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Subscription> getSubscriptions(Context ctx, String folderId) throws OXException {
        List<Subscription> retval = null;
        Connection readConnection = null;
        ResultSet resultSet = null;
        StatementBuilder builder = null;
        try {
            readConnection = this.dbProvider.getReadConnection(ctx);
            SELECT select = new SELECT(new String[]{"id", "user_id", "configuration_id", "source_id", "folder_id", "last_update", "enabled"}).FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("folder_id", (Expression)Constant.PLACEHOLDER)));
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(Autoboxing.I((int)ctx.getContextId()));
            values.add(folderId);
            builder = new StatementBuilder();
            resultSet = builder.executeQuery(readConnection, (Command)select, values);
            retval = this.parseResultSet(resultSet, ctx, readConnection);
        }
        catch (SQLException e) {
            try {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (builder == null) throw throwable;
                    builder.closePreparedStatement(null, resultSet);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw SubscriptionErrorMessage.SQLException.create(e2, new Object[0]);
                }
                finally {
                    this.dbProvider.releaseReadConnection(ctx, readConnection);
                }
            }
        }
        try {
            if (builder == null) return retval;
            builder.closePreparedStatement(null, resultSet);
            return retval;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            this.dbProvider.releaseReadConnection(ctx, readConnection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Subscription> getSubscriptionsOfUser(Context ctx, int userId) throws OXException {
        List<Subscription> retval = null;
        Connection readConnection = null;
        ResultSet resultSet = null;
        StatementBuilder builder = null;
        try {
            readConnection = this.dbProvider.getReadConnection(ctx);
            SELECT select = new SELECT(new String[]{"*"}).FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("user_id", (Expression)Constant.PLACEHOLDER)));
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(Autoboxing.I((int)ctx.getContextId()));
            values.add(Autoboxing.I((int)userId));
            builder = new StatementBuilder();
            resultSet = builder.executeQuery(readConnection, (Command)select, values);
            retval = this.parseResultSet(resultSet, ctx, readConnection);
        }
        catch (SQLException e) {
            try {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (builder == null) throw throwable;
                    builder.closePreparedStatement(null, resultSet);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw SubscriptionErrorMessage.SQLException.create(e2, new Object[0]);
                }
                finally {
                    this.dbProvider.releaseReadConnection(ctx, readConnection);
                }
            }
        }
        try {
            if (builder == null) return retval;
            builder.closePreparedStatement(null, resultSet);
            return retval;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            this.dbProvider.releaseReadConnection(ctx, readConnection);
        }
    }

    @Override
    public void rememberSubscription(Subscription subscription) throws OXException {
        if (subscription.getId() > 0) {
            throw SubscriptionErrorMessage.IDGiven.create();
        }
        Connection writeConnection = null;
        boolean rollback = false;
        try {
            writeConnection = this.dbProvider.getWriteConnection(subscription.getContext());
            this.txPolicy.setAutoCommit(writeConnection, false);
            rollback = true;
            int id = this.save(subscription, writeConnection);
            subscription.setId(id);
            this.txPolicy.commit(writeConnection);
            rollback = false;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            if (writeConnection != null) {
                if (rollback) {
                    Databases.rollback((Connection)writeConnection);
                }
                Databases.autocommit((Connection)writeConnection);
                this.dbProvider.releaseWriteConnection(subscription.getContext(), writeConnection);
            }
        }
    }

    @Override
    public void updateSubscription(Subscription subscription) throws OXException {
        if (!this.exist(subscription.getId(), subscription.getContext())) {
            throw SubscriptionErrorMessage.SubscriptionNotFound.create();
        }
        Connection writeConnection = null;
        boolean rollback = false;
        try {
            writeConnection = this.dbProvider.getWriteConnection(subscription.getContext());
            this.txPolicy.setAutoCommit(writeConnection, false);
            rollback = true;
            this.update(subscription, writeConnection);
            this.txPolicy.commit(writeConnection);
            rollback = false;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            if (writeConnection != null) {
                if (rollback) {
                    Databases.rollback((Connection)writeConnection);
                }
                Databases.autocommit((Connection)writeConnection);
                this.dbProvider.releaseWriteConnection(subscription.getContext(), writeConnection);
            }
        }
    }

    private void delete(Subscription subscription, Connection writeConnection) throws SQLException, OXException {
        DELETE delete = new DELETE().FROM(Tables.subscriptions).WHERE(new EQUALS("id", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("cid", (Expression)Constant.PLACEHOLDER)));
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(Autoboxing.I((int)subscription.getId()));
        values.add(Autoboxing.I((int)subscription.getContext().getContextId()));
        new StatementBuilder().executeStatement(writeConnection, (Command)delete, values);
        this.storageService.delete(writeConnection, subscription.getContext(), this.getConfigurationId(subscription));
    }

    private int save(Subscription subscription, Connection writeConnection) throws OXException, SQLException {
        int configId = this.storageService.save(writeConnection, subscription.getContext(), subscription.getConfiguration());
        int id = IDGenerator.getId((int)subscription.getContext().getContextId(), (int)126, (Connection)writeConnection);
        INSERT insert = new INSERT().INTO(Tables.subscriptions).SET("id", new Expression[]{Constant.PLACEHOLDER}).SET("cid", new Expression[]{Constant.PLACEHOLDER}).SET("user_id", new Expression[]{Constant.PLACEHOLDER}).SET("configuration_id", new Expression[]{Constant.PLACEHOLDER}).SET("source_id", new Expression[]{Constant.PLACEHOLDER}).SET("folder_id", new Expression[]{Constant.PLACEHOLDER}).SET("last_update", new Expression[]{Constant.PLACEHOLDER}).SET("enabled", new Expression[]{Constant.PLACEHOLDER});
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(Autoboxing.I((int)id));
        values.add(Autoboxing.I((int)subscription.getContext().getContextId()));
        values.add(Autoboxing.I((int)subscription.getUserId()));
        values.add(Autoboxing.I((int)configId));
        values.add(subscription.getSource().getId());
        values.add(subscription.getFolderId());
        values.add(Autoboxing.L((long)subscription.getLastUpdate()));
        values.add(subscription.isEnabled());
        new StatementBuilder().executeStatement(writeConnection, (Command)insert, values);
        return id;
    }

    private void update(Subscription subscription, Connection writeConnection) throws OXException, SQLException {
        if (subscription.getConfiguration() != null) {
            int configId = this.getConfigurationId(subscription);
            this.storageService.update(writeConnection, subscription.getContext(), configId, subscription.getConfiguration());
        }
        UPDATE update = new UPDATE(Tables.subscriptions);
        ArrayList<Object> values = new ArrayList<Object>();
        if (subscription.containsUserId()) {
            update.SET("user_id", (Expression)Constant.PLACEHOLDER);
            values.add(Autoboxing.I((int)subscription.getUserId()));
        }
        if (subscription.containsSource()) {
            update.SET("source_id", (Expression)Constant.PLACEHOLDER);
            values.add(subscription.getSource().getId());
        }
        if (subscription.containsFolderId()) {
            update.SET("folder_id", (Expression)Constant.PLACEHOLDER);
            values.add(subscription.getFolderId());
        }
        if (subscription.containsLastUpdate()) {
            update.SET("last_update", (Expression)Constant.PLACEHOLDER);
            values.add(Autoboxing.L((long)subscription.getLastUpdate()));
        }
        if (subscription.containsEnabled()) {
            update.SET("enabled", (Expression)Constant.PLACEHOLDER);
            values.add(subscription.isEnabled());
        }
        update.WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("id", (Expression)Constant.PLACEHOLDER)));
        values.add(Autoboxing.I((int)subscription.getContext().getContextId()));
        values.add(Autoboxing.I((int)subscription.getId()));
        if (values.size() > 2) {
            new StatementBuilder().executeStatement(writeConnection, (Command)update, values);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getConfigurationId(Subscription subscription) throws OXException {
        int retval = 0;
        Connection readConection = null;
        ResultSet resultSet = null;
        StatementBuilder builder = null;
        try {
            readConection = this.dbProvider.getReadConnection(subscription.getContext());
            SELECT select = new SELECT(new String[]{"configuration_id"}).FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("id", (Expression)Constant.PLACEHOLDER)));
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(Autoboxing.I((int)subscription.getContext().getContextId()));
            values.add(Autoboxing.I((int)subscription.getId()));
            builder = new StatementBuilder();
            resultSet = builder.executeQuery(readConection, (Command)select, values);
            if (resultSet.next()) {
                retval = resultSet.getInt("configuration_id");
            }
        }
        catch (SQLException e) {
            try {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (builder == null) throw throwable;
                    builder.closePreparedStatement(null, resultSet);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw SubscriptionErrorMessage.SQLException.create(e2, new Object[0]);
                }
                finally {
                    this.dbProvider.releaseReadConnection(subscription.getContext(), readConection);
                }
            }
        }
        try {
            if (builder == null) return retval;
            builder.closePreparedStatement(null, resultSet);
            return retval;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            this.dbProvider.releaseReadConnection(subscription.getContext(), readConection);
        }
    }

    private List<Subscription> parseResultSet(ResultSet resultSet, Context ctx, Connection readConnection) throws OXException, SQLException {
        ArrayList<Subscription> retval = new ArrayList<Subscription>();
        while (resultSet.next()) {
            Subscription subscription = new Subscription();
            subscription.setContext(ctx);
            subscription.setFolderId(resultSet.getString("folder_id"));
            subscription.setId(resultSet.getInt("id"));
            subscription.setLastUpdate(resultSet.getLong("last_update"));
            subscription.setUserId(resultSet.getInt("user_id"));
            subscription.setEnabled(resultSet.getBoolean("enabled"));
            HashMap<String, Object> content = new HashMap<String, Object>();
            this.storageService.fill(readConnection, ctx, resultSet.getInt("configuration_id"), content);
            subscription.setConfiguration(content);
            subscription.setSource(this.discoveryService.getSource(resultSet.getString("source_id")));
            retval.add(subscription);
        }
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exist(int id, Context ctx) throws OXException {
        boolean retval = false;
        Connection readConnection = null;
        ResultSet resultSet = null;
        StatementBuilder builder = null;
        try {
            readConnection = this.dbProvider.getReadConnection(ctx);
            SELECT select = new SELECT(new String[]{"id"}).FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("id", (Expression)Constant.PLACEHOLDER)));
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(Autoboxing.I((int)ctx.getContextId()));
            values.add(Autoboxing.I((int)id));
            builder = new StatementBuilder();
            resultSet = builder.executeQuery(readConnection, (Command)select, values);
            retval = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (builder == null) throw throwable;
                    builder.closePreparedStatement(null, resultSet);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw SubscriptionErrorMessage.SQLException.create(e2, new Object[0]);
                }
                finally {
                    this.dbProvider.releaseReadConnection(ctx, readConnection);
                }
            }
        }
        try {
            if (builder == null) return retval;
            builder.closePreparedStatement(null, resultSet);
            return retval;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            this.dbProvider.releaseReadConnection(ctx, readConnection);
        }
    }

    @Override
    public void deleteAllSubscriptionsForUser(int userId, Context ctx) throws OXException {
        Connection writeConnection = null;
        try {
            writeConnection = this.dbProvider.getWriteConnection(ctx);
            this.txPolicy.setAutoCommit(writeConnection, false);
            List<Subscription> subs = this.getSubscriptionsOfUser(ctx, userId);
            for (Subscription sub : subs) {
                this.delete(sub, writeConnection);
            }
            this.txPolicy.commit(writeConnection);
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            try {
                if (writeConnection != null) {
                    this.txPolicy.rollback(writeConnection);
                    this.txPolicy.setAutoCommit(writeConnection, true);
                }
            }
            catch (SQLException e) {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            this.dbProvider.releaseWriteConnection(ctx, writeConnection);
        }
    }

    @Override
    public void deleteAllSubscriptionsInContext(int contextId, Context ctx) throws OXException {
        Connection writeConnection = null;
        try {
            writeConnection = this.dbProvider.getWriteConnection(ctx);
            this.txPolicy.setAutoCommit(writeConnection, false);
            DELETE delete = new DELETE().FROM(Tables.subscriptions).WHERE((Predicate)new EQUALS("cid", (Expression)Constant.PLACEHOLDER));
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(Autoboxing.I((int)ctx.getContextId()));
            new StatementBuilder().executeStatement(writeConnection, (Command)delete, values);
            this.storageService.delete(writeConnection, ctx);
            this.txPolicy.commit(writeConnection);
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            try {
                if (writeConnection != null) {
                    this.txPolicy.rollback(writeConnection);
                    this.txPolicy.setAutoCommit(writeConnection, true);
                }
            }
            catch (SQLException e) {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            this.dbProvider.releaseWriteConnection(ctx, writeConnection);
        }
    }

    @Override
    public void deleteAllSubscriptionsWhereConfigMatches(Map<String, Object> query, String sourceId, Context ctx) throws OXException {
        Connection writeConnection = null;
        try {
            writeConnection = this.dbProvider.getWriteConnection(ctx);
            this.txPolicy.setAutoCommit(writeConnection, false);
            DELETE delete = new DELETE().FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("source_id", (Expression)Constant.PLACEHOLDER)).AND((Predicate)new EQUALS("configuration_id", (Expression)Constant.PLACEHOLDER)));
            ArrayList<Object> values = new ArrayList<Object>(Arrays.asList(null, null, null));
            values.set(0, ctx.getContextId());
            values.set(1, sourceId);
            List configIds = this.storageService.search(ctx, query);
            for (Integer configId : configIds) {
                values.set(2, configId);
                int deleted = new StatementBuilder().executeStatement(writeConnection, (Command)delete, values);
                if (deleted != 1) continue;
                this.storageService.delete(writeConnection, ctx, configId.intValue());
            }
            this.txPolicy.commit(writeConnection);
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            try {
                if (writeConnection != null) {
                    this.txPolicy.rollback(writeConnection);
                    this.txPolicy.setAutoCommit(writeConnection, true);
                }
            }
            catch (SQLException e) {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            this.dbProvider.releaseWriteConnection(ctx, writeConnection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Boolean> hasSubscriptions(Context ctx, List<String> folderIds) throws OXException {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        for (String folderId : folderIds) {
            retval.put(folderId, false);
        }
        Connection readConnection = null;
        ResultSet resultSet = null;
        StatementBuilder builder = null;
        try {
            readConnection = this.dbProvider.getReadConnection(ctx);
            ArrayList<Constant> placeholders = new ArrayList<Constant>(folderIds.size());
            for (int i = 0; i < folderIds.size(); ++i) {
                placeholders.add(Constant.PLACEHOLDER);
            }
            SELECT select = new SELECT(new String[]{"folder_id"}).FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new IN("folder_id", new LIST(placeholders))));
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(Autoboxing.I((int)ctx.getContextId()));
            values.addAll(folderIds);
            builder = new StatementBuilder();
            resultSet = builder.executeQuery(readConnection, (Command)select, values);
            while (resultSet.next()) {
                String folderId = resultSet.getString(1);
                retval.put(folderId, true);
            }
        }
        catch (SQLException e) {
            try {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (builder == null) throw throwable;
                    builder.closePreparedStatement(null, resultSet);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw SubscriptionErrorMessage.SQLException.create(e2, new Object[0]);
                }
                finally {
                    this.dbProvider.releaseReadConnection(ctx, readConnection);
                }
            }
        }
        try {
            if (builder == null) return retval;
            builder.closePreparedStatement(null, resultSet);
            return retval;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            this.dbProvider.releaseReadConnection(ctx, readConnection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasSubscriptions(Context ctx, User user) throws OXException {
        boolean bl;
        Connection readConnection = null;
        ResultSet resultSet = null;
        StatementBuilder builder = null;
        try {
            readConnection = this.dbProvider.getReadConnection(ctx);
            SELECT select = new SELECT(new String[]{"1"}).FROM(Tables.subscriptions).WHERE(new EQUALS("cid", (Expression)Constant.PLACEHOLDER).AND((Predicate)new EQUALS("user_id", (Expression)Constant.PLACEHOLDER)));
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(Autoboxing.I((int)ctx.getContextId()));
            values.add(Autoboxing.I((int)user.getId()));
            builder = new StatementBuilder();
            resultSet = builder.executeQuery(readConnection, (Command)select, values);
            bl = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                try {
                    if (builder == null) throw throwable;
                    builder.closePreparedStatement(null, resultSet);
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw SubscriptionErrorMessage.SQLException.create(e2, new Object[0]);
                }
                finally {
                    this.dbProvider.releaseReadConnection(ctx, readConnection);
                }
            }
        }
        try {
            if (builder == null) return bl;
            builder.closePreparedStatement(null, resultSet);
            return bl;
        }
        catch (SQLException e) {
            throw SubscriptionErrorMessage.SQLException.create(e, new Object[0]);
        }
        finally {
            this.dbProvider.releaseReadConnection(ctx, readConnection);
        }
    }

    public void update(String recrypted, EncryptedField customizationNote) throws OXException {
        int configId = this.getConfigurationId(customizationNote.subscription);
        HashMap<String, String> update = new HashMap<String, String>();
        update.put(customizationNote.field, recrypted);
        this.storageService.update(customizationNote.subscription.getContext(), configId, update);
    }
}

