/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.secret;

import com.openexchange.exception.OXException;
import com.openexchange.secret.recovery.EncryptedItemCleanUpService;
import com.openexchange.secret.recovery.EncryptedItemDetectorService;
import com.openexchange.secret.recovery.SecretMigrator;
import com.openexchange.session.Session;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.tools.session.ServerSession;
import java.util.List;
import java.util.Set;

public class SubscriptionSecretHandling
implements EncryptedItemDetectorService,
SecretMigrator,
EncryptedItemCleanUpService {
    private SubscriptionSourceDiscoveryService discovery = null;

    public SubscriptionSecretHandling(SubscriptionSourceDiscoveryService discovery) {
        this.discovery = discovery;
    }

    public boolean hasEncryptedItems(ServerSession session) throws OXException {
        List<SubscriptionSource> sources = this.discovery.getSources();
        for (SubscriptionSource subscriptionSource : sources) {
            SubscribeService subscribeService;
            Set<String> passwordFields = subscriptionSource.getPasswordFields();
            if (passwordFields.isEmpty() || !(subscribeService = subscriptionSource.getSubscribeService()).hasAccounts(session.getContext(), session.getUser())) continue;
            return true;
        }
        return false;
    }

    public void migrate(String oldSecret, String newSecret, ServerSession session) throws OXException {
        List<SubscriptionSource> sources = this.discovery.getSources();
        for (SubscriptionSource subscriptionSource : sources) {
            SubscribeService subscribeService;
            Set<String> passwordFields = subscriptionSource.getPasswordFields();
            if (passwordFields.isEmpty() || null == (subscribeService = subscriptionSource.getSubscribeService())) continue;
            subscribeService.migrateSecret((Session)session, oldSecret, newSecret);
        }
    }

    public void cleanUpEncryptedItems(String secret, ServerSession session) throws OXException {
        List<SubscriptionSource> sources = this.discovery.getSources();
        for (SubscriptionSource subscriptionSource : sources) {
            SubscribeService subscribeService;
            Set<String> passwordFields = subscriptionSource.getPasswordFields();
            if (passwordFields.isEmpty() || null == (subscribeService = subscriptionSource.getSubscribeService())) continue;
            subscribeService.cleanUp(secret, (Session)session);
        }
    }
}

