/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.api2.FolderSQLInterface;
import com.openexchange.api2.RdbFolderSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.webdav.WebdavExceptionCode;
import com.openexchange.webdav.xml.FolderChildWriter;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class FolderWriter
extends FolderChildWriter {
    protected static final String PRIVATE_STRING = "private";
    protected static final String PUBLIC_STRING = "public";
    protected static final String SHARED_STRING = "shared";
    protected int counter;
    protected int userId = -1;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(FolderWriter.class));

    public FolderWriter(int userId) {
        this.userId = userId;
    }

    public FolderWriter(Session sessionObj, Context ctx) {
        this.sessionObj = sessionObj;
        this.ctx = ctx;
        this.userId = sessionObj.getUserId();
    }

    public void startWriter(int objectId, OutputStream os) throws Exception {
        RdbFolderSQLInterface sqlinterface = new RdbFolderSQLInterface(ServerSessionAdapter.valueOf(this.sessionObj));
        Element eProp = new Element("prop", "D", "DAV:");
        XMLOutputter xo = new XMLOutputter();
        try {
            FolderObject folderObj = sqlinterface.getFolderById(objectId);
            this.writeObject(folderObj, eProp, false, xo, os);
        }
        catch (OXException exc) {
            if (exc.isGeneric(OXException.Generic.NOT_FOUND) || OXFolderExceptionCode.FOLDER_COULD_NOT_BE_LOADED.equals(exc) || OXFolderExceptionCode.NOT_EXISTS.equals(exc)) {
                this.writeResponseElement(eProp, 0, 404, "[1001] Object not found", xo, os);
            } else {
                this.writeResponseElement(eProp, 0, 500, FolderWriter.getErrorMessage("[%s] Server Error - ", 1500), xo, os);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            this.writeResponseElement(eProp, 0, 500, FolderWriter.getErrorMessage("[%s] Server Error - ", 1500), xo, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriter(boolean modified, boolean deleted, boolean bList, Date lastsync, OutputStream os) throws Exception {
        Date dLastSync;
        ServerSession serverSession = ServerSessionAdapter.valueOf(this.sessionObj);
        RdbFolderSQLInterface sqlinterface = new RdbFolderSQLInterface(serverSession);
        XMLOutputter xo = new XMLOutputter();
        Date date = dLastSync = lastsync == null ? new Date(0L) : lastsync;
        if (modified || deleted) {
            UpdatesResult updatesResult = FolderWriter.calculateUpdates(sqlinterface, dLastSync, !deleted, serverSession);
            if (deleted) {
                Queue<FolderObject> deletedQueue = updatesResult.deletedQueue;
                this.writeIterator((SearchIterator<FolderObject>)new SearchIteratorAdapter(deletedQueue.iterator()), true, xo, os);
            }
            if (modified) {
                Queue<FolderObject> updatedQueue = updatesResult.updatedQueue;
                this.writeIterator((SearchIterator<FolderObject>)new SearchIteratorAdapter(updatedQueue.iterator()), false, xo, os);
            }
        }
        if (bList) {
            SearchIterator<FolderObject> it = null;
            try {
                it = sqlinterface.getModifiedUserFolders(new Date(0L));
                this.writeList(it, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
    }

    public void writeIterator(SearchIterator<FolderObject> it, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        while (it.hasNext()) {
            this.writeObject((FolderObject)it.next(), delete, xo, os);
        }
    }

    public void writeObject(FolderObject folderobject, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        this.writeObject(folderobject, new Element("prop", "D", "DAV:"), delete, xo, os);
    }

    public void writeObject(FolderObject folderobject, Element e_prop, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        int module = folderobject.getModule();
        if (module == 2 || module == 1 || module == 3) {
            int status = 200;
            String description = "OK";
            int object_id = 0;
            try {
                object_id = folderobject.getObjectID();
                this.addContent2PropElement(e_prop, folderobject, delete);
            }
            catch (Exception exc) {
                LOG.error((Object)"writeObject", (Throwable)exc);
                status = 500;
                description = "Server Error: " + exc.getMessage();
                object_id = 0;
            }
            this.writeResponseElement(e_prop, object_id, status, description, xo, os);
        }
    }

    public void addContent2PropElement(Element e_prop, FolderObject folderobject, boolean delete) throws Exception {
        ++this.counter;
        if (delete) {
            FolderWriter.addElement("object_id", folderobject.getObjectID(), e_prop);
            FolderWriter.addElement("object_status", "DELETE", e_prop);
        } else {
            int type = folderobject.getType();
            int owner = folderobject.getCreator();
            int module = folderobject.getModule();
            FolderWriter.addElement("object_status", "CREATE", e_prop);
            String folderName = null;
            folderName = folderobject.getFolderName();
            if (folderName != null && folderName.length() > 0) {
                FolderWriter.addElement("title", folderobject.getFolderName(), e_prop);
            } else {
                FolderWriter.addElement("title", "no folder name " + this.counter, e_prop);
            }
            FolderWriter.addElement("owner", folderobject.getCreator(), e_prop);
            switch (module) {
                case 2: {
                    FolderWriter.addElement("module", "calendar", e_prop);
                    break;
                }
                case 3: {
                    FolderWriter.addElement("module", "contact", e_prop);
                    break;
                }
                case 1: {
                    FolderWriter.addElement("module", "task", e_prop);
                    break;
                }
                default: {
                    throw WebdavExceptionCode.IO_ERROR.create("invalid module");
                }
            }
            if (type == 1) {
                if (owner == this.userId) {
                    FolderWriter.addElement("type", PRIVATE_STRING, e_prop);
                } else {
                    FolderWriter.addElement("type", SHARED_STRING, e_prop);
                    folderobject.setParentFolderID(3);
                }
            } else {
                FolderWriter.addElement("type", PUBLIC_STRING, e_prop);
            }
            FolderWriter.addElement("defaultfolder", folderobject.isDefaultFolder(), e_prop);
            this.writeFolderChildElements(folderobject, e_prop);
            FolderWriter.addElementPermission(folderobject.getPermissions(), e_prop);
        }
    }

    public static void addElementPermission(List<OCLPermission> permissions, Element e_prop) throws Exception {
        Element e_permissions = new Element("permissions", "ox", "http://www.open-xchange.org");
        if (permissions != null) {
            for (int a = 0; a < permissions.size(); ++a) {
                OCLPermission oclp = permissions.get(a);
                int entity = oclp.getEntity();
                int fp = oclp.getFolderPermission();
                int orp = oclp.getReadPermission();
                int owp = oclp.getWritePermission();
                int odp = oclp.getDeletePermission();
                if (oclp.isGroupPermission()) {
                    FolderWriter.addElementGroup(e_permissions, entity, fp, orp, owp, odp, oclp.isFolderAdmin());
                    continue;
                }
                FolderWriter.addElementUser(e_permissions, entity, fp, orp, owp, odp, oclp.isFolderAdmin());
            }
        }
        e_prop.addContent((Content)e_permissions);
    }

    protected static void addElementUser(Element e_permissions, int entity, int fp, int orp, int owp, int odp, boolean adminFlag) throws Exception {
        Element e = new Element("user", namespace);
        FolderWriter.addAttributes(e, fp, orp, owp, odp, adminFlag);
        e.addContent(Integer.toString(entity));
        e_permissions.addContent((Content)e);
    }

    protected static void addElementGroup(Element e_permissions, int entity, int fp, int orp, int owp, int odp, boolean adminFlag) throws Exception {
        Element e = new Element("group", namespace);
        FolderWriter.addAttributes(e, fp, orp, owp, odp, adminFlag);
        e.addContent(Integer.toString(entity));
        e_permissions.addContent((Content)e);
    }

    protected static void addAttributes(Element e, int fp, int orp, int owp, int odp, boolean adminFlag) throws Exception {
        e.setAttribute("folderpermission", Integer.toString(fp), namespace);
        e.setAttribute("objectreadpermission", Integer.toString(orp), namespace);
        e.setAttribute("objectwritepermission", Integer.toString(owp), namespace);
        e.setAttribute("objectdeletepermission", Integer.toString(odp), namespace);
        e.setAttribute("admin_flag", Boolean.toString(adminFlag), namespace);
    }

    private static Enqueuer getEnqueuer(boolean ignoreDeleted, UserConfiguration userConf, Queue<FolderObject> updatedQueue, Queue<FolderObject> deletedQueue) {
        if (ignoreDeleted) {
            if (userConf.hasFullSharedFolderAccess()) {
                return new IgnoreDeletedFullEnqueuer(updatedQueue, userConf);
            }
            return new IgnoreDeletedNoSharedAccessEnqueuer(updatedQueue, userConf);
        }
        if (userConf.hasFullSharedFolderAccess()) {
            return new FullEnqueuer(updatedQueue, deletedQueue, userConf);
        }
        return new NoSharedAccessEnqueuer(updatedQueue, deletedQueue, userConf);
    }

    private static UpdatesResult calculateUpdates(FolderSQLInterface sqlInterface, Date timestamp, boolean ignoreDeleted, ServerSession session) throws OXException {
        Queue<FolderObject> queue = ((FolderObjectIterator)sqlInterface.getAllModifiedFolders(timestamp)).asQueue();
        LinkedList<FolderObject> updatedQueue = new LinkedList<FolderObject>();
        LinkedList<FolderObject> deletedQueue = ignoreDeleted ? null : new LinkedList<FolderObject>();
        Enqueuer enqueuer = FolderWriter.getEnqueuer(ignoreDeleted, session.getUserConfiguration(), updatedQueue, deletedQueue);
        for (FolderObject fo : queue) {
            enqueuer.enqueue(fo);
        }
        if (ignoreDeleted) {
            return new UpdatesResult(updatedQueue, null);
        }
        queue = ((FolderObjectIterator)sqlInterface.getDeletedFolders(timestamp)).asQueue();
        queue.addAll(deletedQueue);
        return new UpdatesResult(updatedQueue, queue);
    }

    private static final class IgnoreDeletedNoSharedAccessEnqueuer
    extends FullEnqueuer {
        public IgnoreDeletedNoSharedAccessEnqueuer(Queue<FolderObject> updatedQueue, UserConfiguration userConf) {
            super(updatedQueue, null, userConf);
        }

        @Override
        public void enqueue(FolderObject fo) throws OXException {
            try {
                if (!fo.isShared(this.userId) && fo.isVisible(this.userId, this.userConf)) {
                    this.updatedQueue.add(fo);
                }
            }
            catch (RuntimeException e) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static final class IgnoreDeletedFullEnqueuer
    extends FullEnqueuer {
        public IgnoreDeletedFullEnqueuer(Queue<FolderObject> updatedQueue, UserConfiguration userConf) {
            super(updatedQueue, null, userConf);
        }

        @Override
        public void enqueue(FolderObject fo) throws OXException {
            try {
                if (fo.isVisible(this.userId, this.userConf)) {
                    this.updatedQueue.add(fo);
                }
            }
            catch (RuntimeException e) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static final class NoSharedAccessEnqueuer
    extends FullEnqueuer {
        public NoSharedAccessEnqueuer(Queue<FolderObject> updatedQueue, Queue<FolderObject> deletedQueue, UserConfiguration userConf) {
            super(updatedQueue, deletedQueue, userConf);
        }

        @Override
        public void enqueue(FolderObject fo) throws OXException {
            try {
                if (fo.isVisible(this.userId, this.userConf)) {
                    if (fo.isShared(this.userId)) {
                        this.deletedQueue.add(fo);
                    } else {
                        this.updatedQueue.add(fo);
                    }
                } else {
                    this.deletedQueue.add(fo);
                }
            }
            catch (RuntimeException e) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static class FullEnqueuer
    implements Enqueuer {
        protected final int userId;
        protected final UserConfiguration userConf;
        protected final Queue<FolderObject> updatedQueue;
        protected final Queue<FolderObject> deletedQueue;

        public FullEnqueuer(Queue<FolderObject> updatedQueue, Queue<FolderObject> deletedQueue, UserConfiguration userConf) {
            this.updatedQueue = updatedQueue;
            this.deletedQueue = deletedQueue;
            this.userId = userConf.getUserId();
            this.userConf = userConf;
        }

        @Override
        public void enqueue(FolderObject fo) throws OXException {
            try {
                if (fo.isVisible(this.userId, this.userConf)) {
                    this.updatedQueue.add(fo);
                } else {
                    this.deletedQueue.add(fo);
                }
            }
            catch (RuntimeException e) {
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
            }
        }
    }

    private static interface Enqueuer {
        public void enqueue(FolderObject var1) throws OXException;
    }

    private static final class UpdatesResult {
        public final Queue<FolderObject> updatedQueue;
        public final Queue<FolderObject> deletedQueue;

        public UpdatesResult(Queue<FolderObject> updatedQueue, Queue<FolderObject> deletedQueue) {
            this.updatedQueue = updatedQueue;
            this.deletedQueue = deletedQueue;
        }
    }
}

