/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.groupware.container.DataObject;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.io.IOException;
import java.util.Date;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DataParser {
    public static final int SAVE = 1;
    public static final int DELETE = 2;
    public static final int CONFIRM = 3;
    public static final int CLEAR = 4;
    protected Session sessionObj;
    protected String client_id;
    protected int method = 1;
    private int inFolder;
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DataParser.class));

    protected void parseElement(DataObject dataobject, XmlPullParser parser) throws XmlPullParserException, IOException {
        if (this.isTag(parser, "object_id", "http://www.open-xchange.org")) {
            dataobject.setObjectID(this.getValueAsInt(parser));
        } else if (this.isTag(parser, "last_modified", "http://www.open-xchange.org")) {
            dataobject.setLastModified(this.getValueAsDate(parser));
        } else if (this.isTag(parser, "client_id", "http://www.open-xchange.org")) {
            this.client_id = this.getValue(parser);
        } else if (this.isTag(parser, "method", "http://www.open-xchange.org")) {
            String s = this.getValue(parser);
            if (s != null) {
                if (s.equalsIgnoreCase("save")) {
                    this.method = 1;
                } else if (s.equalsIgnoreCase("delete")) {
                    this.method = 2;
                } else if (s.equalsIgnoreCase("confirm")) {
                    this.method = 3;
                } else if (s.equalsIgnoreCase("clear")) {
                    this.method = 4;
                }
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("unknown xml tag: " + parser.getName()));
            }
            this.getValue(parser);
        }
    }

    protected boolean hasCorrectNamespace(XmlPullParser parser) throws XmlPullParserException {
        return parser.getEventType() == 2 && parser.getNamespace().equals("http://www.open-xchange.org");
    }

    public boolean isTag(XmlPullParser parser, String name) throws XmlPullParserException {
        return parser.getEventType() == 2 && (name == null || name.equals(parser.getName()));
    }

    public boolean isTag(XmlPullParser parser, String name, String namespace) throws XmlPullParserException {
        return parser.getEventType() == 2 && (name == null || name.equals(parser.getName()));
    }

    public String getClientID() {
        return this.client_id;
    }

    public int getMethod() {
        return this.method;
    }

    protected void setInFolder(int folderId) {
        this.inFolder = folderId;
    }

    public int getFolder() {
        return this.inFolder;
    }

    public int getValueAsInt(XmlPullParser parser) throws XmlPullParserException, IOException {
        block3: {
            String s = null;
            s = this.getValue(parser);
            if (s != null && s.length() > 0) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)("Value is not a number: " + s), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public float getValueAsFloat(XmlPullParser parser) throws XmlPullParserException, IOException {
        String s = null;
        s = this.getValue(parser);
        if (s != null && s.length() > 0) {
            return Float.parseFloat(s);
        }
        return 0.0f;
    }

    public long getValueAsLong(XmlPullParser parser) throws XmlPullParserException, IOException {
        String s = null;
        s = this.getValue(parser);
        if (s != null && s.length() > 0) {
            return Long.parseLong(s);
        }
        return 0L;
    }

    public Date getValueAsDate(XmlPullParser parser) throws XmlPullParserException, IOException {
        String s = null;
        s = this.getValue(parser);
        if (s != null && s.length() > 0) {
            return new Date(Long.parseLong(s));
        }
        return null;
    }

    public boolean getValueAsBoolean(XmlPullParser parser) throws XmlPullParserException, IOException {
        String s = null;
        s = this.getValue(parser);
        return s != null && s.equalsIgnoreCase("true");
    }

    public byte[] getValueAsByteArray(XmlPullParser parser) throws XmlPullParserException, IOException {
        String s = parser.nextText();
        if (s != null && s.length() == 0) {
            return null;
        }
        return s.getBytes();
    }

    public String getValue(XmlPullParser parser) throws XmlPullParserException, IOException {
        String s = parser.nextText();
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    public static boolean isEnd(XmlPullParser parser) throws XmlPullParserException {
        return parser.getEventType() == 1;
    }
}

