/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class GeoValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new GeoValueDefinition();
    private static Pattern FloatPattern = Pattern.compile("[-+]\\d+(\\.\\d+)?");
    private static DecimalFormat Format = new DecimalFormat("0.################");

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        ArrayList<Double> geo = new ArrayList<Double>();
        String str = s.regex(FloatPattern);
        if (str == null) {
            throw new VersitException(s, "Latitude expected");
        }
        geo.add(Double.valueOf(str));
        if (s.peek != 59) {
            throw new IOException("Geographic position expected");
        }
        s.read();
        str = s.regex(FloatPattern);
        if (str == null) {
            throw new VersitException(s, "Latitude expected");
        }
        geo.add(Double.valueOf(str));
        return geo;
    }

    @Override
    public String writeValue(Object value) {
        ArrayList geo = (ArrayList)value;
        return Format.format((Double)geo.get(0)) + ';' + Format.format((Double)geo.get(1));
    }
}

