/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.http;

import com.openexchange.ajax.Login;
import com.openexchange.ajax.helper.BrowserDetector;
import com.openexchange.authentication.Cookie;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.java.Charsets;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.systemname.SystemNameService;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.encoding.Helper;
import com.openexchange.tools.servlet.http.Cookies;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.idn.IDNA;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class Tools {
    private static final DateFormat HEADER_DATEFORMAT = new SimpleDateFormat("EEE',' dd MMMM yyyy HH:mm:ss z", Locale.ENGLISH);
    private static final String NAME_CACHE_CONTROL = "Cache-Control";
    private static final String NAME_EXPIRES = "Expires";
    private static final String NAME_ETAG = "ETag";
    private static final String EXPIRES_DATE;
    private static final String CACHE_VALUE = "no-store, no-cache, must-revalidate, post-check=0, pre-check=0";
    private static final String PRAGMA_KEY = "Pragma";
    private static final String PRAGMA_VALUE = "no-cache";
    private static final long MILLIS_WEEK = 604800000L;
    private static final long MILLIS_YEAR = 31449600000L;
    public static final String HEADER_AGENT = "User-Agent";
    public static final String HEADER_TYPE = "Content-Type";
    public static final String HEADER_REFERER = "Referer";
    public static final String HEADER_LENGTH = "Content-Length";
    public static final String JSESSIONID_COOKIE = "JSESSIONID";
    private static final CookieNameMatcher OX_COOKIE_MATCHER;
    private static final String NAME_ACCEPT_LANGUAGE;
    private static final String MULTIPART = "multipart/";

    private Tools() {
    }

    public static String toACE(String idnAddress) throws OXException {
        try {
            return IDNA.toACE((String)idnAddress);
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
    }

    public static String toIDN(String aceAddress) {
        return IDNA.toIDN((String)aceAddress);
    }

    public static void setETag(String eTag, HttpServletResponse resp) {
        Tools.setETag(eTag, null, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setETag(String eTag, Date expires, HttpServletResponse resp) {
        Tools.removeCachingHeader(resp);
        resp.setHeader(NAME_ETAG, eTag);
        if (null == expires) {
            DateFormat dateFormat = HEADER_DATEFORMAT;
            synchronized (dateFormat) {
                resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(new Date(System.currentTimeMillis() + 31449600000L)));
            }
            resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=31521018");
        } else {
            DateFormat dateFormat = HEADER_DATEFORMAT;
            synchronized (dateFormat) {
                resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(expires));
            }
            resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=31521018");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExpires(Date expires, HttpServletResponse resp) {
        if (null != expires) {
            DateFormat dateFormat = HEADER_DATEFORMAT;
            synchronized (dateFormat) {
                resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(expires));
            }
            resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=31521018");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExpiresInOneYear(HttpServletResponse resp) {
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            resp.setHeader(NAME_EXPIRES, HEADER_DATEFORMAT.format(new Date(System.currentTimeMillis() + 31449600000L)));
        }
        resp.setHeader(NAME_CACHE_CONTROL, "private, max-age=31521018");
    }

    public static void disableCaching(HttpServletResponse resp) {
        resp.setHeader(NAME_EXPIRES, EXPIRES_DATE);
        resp.setHeader(NAME_CACHE_CONTROL, CACHE_VALUE);
        resp.setHeader(PRAGMA_KEY, PRAGMA_VALUE);
    }

    public static void removeCachingHeader(HttpServletResponse resp) {
        resp.setHeader(PRAGMA_KEY, null);
        resp.setHeader(NAME_CACHE_CONTROL, null);
        resp.setHeader(NAME_EXPIRES, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatHeaderDate(Date date) {
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            return HEADER_DATEFORMAT.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseHeaderDate(String str) throws ParseException {
        DateFormat dateFormat = HEADER_DATEFORMAT;
        synchronized (dateFormat) {
            return HEADER_DATEFORMAT.parse(str);
        }
    }

    public static String logHeaderForError(HttpServletRequest req) {
        StringBuilder message = new StringBuilder();
        String sep = System.getProperty("line.separator");
        message.append("|").append(sep);
        message.append(HEADER_AGENT);
        message.append(": ");
        message.append(req.getHeader(HEADER_AGENT));
        message.append(sep);
        message.append(HEADER_TYPE);
        message.append(": ");
        message.append(req.getHeader(HEADER_TYPE));
        message.append(sep);
        message.append(HEADER_REFERER);
        message.append(": ");
        message.append(req.getHeader(HEADER_REFERER));
        message.append(sep);
        message.append(HEADER_LENGTH);
        message.append(": ");
        message.append(req.getHeader(HEADER_LENGTH));
        return message.toString();
    }

    public static void deleteCookies(HttpServletRequest req, HttpServletResponse resp) {
        Tools.deleteCookies(req, resp, OX_COOKIE_MATCHER);
    }

    public static void deleteCookies(HttpServletRequest req, HttpServletResponse resp, CookieNameMatcher matcher) {
        javax.servlet.http.Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (javax.servlet.http.Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (!matcher.matches(cookieName)) continue;
                javax.servlet.http.Cookie respCookie = new javax.servlet.http.Cookie(cookieName, cookie.getValue());
                respCookie.setPath("/");
                respCookie.setMaxAge(0);
                resp.addCookie(respCookie);
            }
        }
    }

    public static void setHeaderForFileDownload(String userAgent, HttpServletResponse resp, String fileName) throws UnsupportedEncodingException {
        Tools.setHeaderForFileDownload(userAgent, resp, fileName, null);
    }

    public static void setHeaderForFileDownload(String userAgent, HttpServletResponse resp, String fileName, String contentDisposition) throws UnsupportedEncodingException {
        BrowserDetector detector = new BrowserDetector(userAgent);
        String cd = contentDisposition;
        if (cd == null) {
            cd = "attachment";
        }
        String filename = null;
        filename = detector.isMSIE() ? Helper.encodeFilenameForIE(fileName, Charsets.UTF_8) : (detector.isSafari5() ? new String(fileName.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1) : Helper.escape(Helper.encodeFilename(fileName, "UTF-8")));
        if (cd.indexOf(59) < 0 && filename != null) {
            cd = new StringBuilder(64).append(cd).append("; filename=\"").append(filename).append('\"').toString();
        }
        resp.setHeader("Content-Disposition", cd);
    }

    public static String getProtocol(HttpServletRequest req) {
        return Tools.considerSecure(req) ? "https://" : "http://";
    }

    public static boolean considerSecure(HttpServletRequest req) {
        ConfigurationService configurationService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (configurationService != null && configurationService.getBoolProperty(ServerConfig.Property.FORCE_HTTPS.getPropertyName(), false) && !Cookies.isLocalLan(req)) {
            return true;
        }
        return req.isSecure();
    }

    public static boolean considerSecure(HttpServletRequest req, boolean force) {
        if (force && !Cookies.isLocalLan(req)) {
            return true;
        }
        return req.isSecure();
    }

    public static String getRoute(String httpSessionId) {
        if (null == httpSessionId) {
            return null;
        }
        int pos = httpSessionId.indexOf(46);
        return pos > 0 ? httpSessionId : httpSessionId + '.' + ServerServiceRegistry.getInstance().getService(SystemNameService.class).getSystemName();
    }

    public static Locale getLocaleByAcceptLanguage(HttpServletRequest request, Locale defaultLocale) {
        if (null == request) {
            return defaultLocale;
        }
        String header = request.getHeader(NAME_ACCEPT_LANGUAGE);
        if (Tools.isEmpty(header)) {
            return defaultLocale;
        }
        int pos = header.indexOf(59);
        if (pos > 0) {
            header = header.substring(0, pos);
        }
        Locale l = LocaleTools.getLocale((String)((pos = (header = header.trim()).indexOf(44)) > 0 ? header.substring(0, pos) : header));
        return null == l ? defaultLocale : l;
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        if (null == request) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public static final Map<String, List<String>> copyHeaders(HttpServletRequest req) {
        if (null == req) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            LinkedList<String> values = (LinkedList<String>)headers.get(name);
            if (null == values) {
                values = new LinkedList<String>();
                headers.put(name, values);
            }
            Enumeration valueEnum = req.getHeaders(name);
            while (valueEnum.hasMoreElements()) {
                values.add((String)valueEnum.nextElement());
            }
        }
        return headers;
    }

    public static Cookie[] getCookieFromHeader(HttpServletRequest req) {
        if (null == req) {
            return new Cookie[0];
        }
        javax.servlet.http.Cookie[] cookies = req.getCookies();
        if (null == cookies) {
            return new Cookie[0];
        }
        Cookie[] retval = new Cookie[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            retval[i] = Tools.getCookie(cookies[i]);
        }
        return retval;
    }

    private static Cookie getCookie(javax.servlet.http.Cookie cookie) {
        return new AuthCookie(cookie);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    static {
        HEADER_DATEFORMAT.setTimeZone(TimeZoneUtils.getTimeZone("GMT"));
        EXPIRES_DATE = HEADER_DATEFORMAT.format(new Date(799761600000L));
        OX_COOKIE_MATCHER = new CookieNameMatcher(){

            @Override
            public boolean matches(String cookieName) {
                return null != cookieName && (cookieName.startsWith(Login.SESSION_PREFIX) || Tools.JSESSIONID_COOKIE.equals(cookieName));
            }
        };
        NAME_ACCEPT_LANGUAGE = "Accept-Language".intern();
    }

    public static interface CookieNameMatcher {
        public boolean matches(String var1);
    }

    private static final class AuthCookie
    implements Cookie {
        private final javax.servlet.http.Cookie cookie;

        protected AuthCookie(javax.servlet.http.Cookie cookie) {
            this.cookie = cookie;
        }

        public String getValue() {
            return this.cookie.getValue();
        }

        public String getName() {
            return this.cookie.getName();
        }
    }
}

