/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.memory;

import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.oxfolder.memory.Condition;
import com.openexchange.tools.oxfolder.memory.Permission;
import gnu.trove.TIntCollection;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ConditionTree {
    private static final Condition CONDITION_ADMIN = new Condition(){

        @Override
        public boolean fulfilled(Permission p) {
            return p.admin;
        }
    };
    private static final Condition CONDITION_READ_FOLDER = new Condition(){

        @Override
        public boolean fulfilled(Permission p) {
            return p.readFolder;
        }
    };
    private static final List<Condition> CONDITIONS = Collections.unmodifiableList(new ArrayList<Condition>(Arrays.asList(CONDITION_ADMIN, CONDITION_READ_FOLDER)));
    private static final int LENGTH = CONDITIONS.size();
    private final TIntSet folderIds = new TIntHashSet();
    private final List<Permission> permissions = new ArrayList<Permission>();
    private final boolean ignoreSharedAddressbook = OXFolderProperties.isIgnoreSharedAddressbook();

    public void insert(Permission p) {
        if (this.ignoreSharedAddressbook && 5 == p.fuid) {
            return;
        }
        this.insert(CONDITION_ADMIN, p, 0);
    }

    private void insert(Condition condition, Permission p, int index) {
        if (index >= LENGTH) {
            return;
        }
        if (condition.fulfilled(p)) {
            this.folderIds.add(p.fuid);
            this.permissions.add(p);
        } else {
            int nextIndex = index + 1;
            if (nextIndex >= LENGTH) {
                return;
            }
            this.insert(CONDITIONS.get(nextIndex), p, nextIndex);
        }
    }

    public TIntSet getVisibleFolderIds() {
        return this.folderIds;
    }

    public TIntSet getVisibleFolderIds(Condition condition) {
        if (null == condition) {
            return new TIntHashSet((TIntCollection)this.folderIds);
        }
        TIntHashSet retval = new TIntHashSet((TIntCollection)this.folderIds);
        for (Permission p : this.permissions) {
            if (condition.fulfilled(p)) continue;
            retval.remove(p.fuid);
        }
        return retval;
    }
}

