/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.StaticDBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAdminHelper;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class OXFolderAccess {
    private final Connection readCon;
    private final Context ctx;

    public OXFolderAccess(Context ctx) {
        this(null, ctx);
    }

    public OXFolderAccess(Connection readCon, Context ctx) {
        this.readCon = readCon;
        this.ctx = ctx;
    }

    public boolean exists(int folderId) throws OXException {
        try {
            this.getFolderObject(folderId);
            return true;
        }
        catch (OXException e) {
            if (OXFolderExceptionCode.isNotFound(e)) {
                return false;
            }
            throw e;
        }
    }

    public final FolderObject getFolderObject(int folderId) throws OXException {
        return this.getFolderObject(folderId, true);
    }

    public final FolderObject getFolderObject(int folderId, boolean fromCache) throws OXException {
        FolderObject fo = fromCache && FolderCacheManager.isEnabled() ? FolderCacheManager.getInstance().getFolderObject(folderId, true, this.ctx, this.readCon) : FolderObject.loadFolderObjectFromDB(folderId, this.ctx, this.readCon);
        return fo;
    }

    public final List<FolderObject> getFolderObjects(int[] folderIDs) throws OXException {
        ArrayList<FolderObject> retval = new ArrayList<FolderObject>(folderIDs.length);
        for (int fuid : folderIDs) {
            try {
                retval.add(this.getFolderObject(fuid));
            }
            catch (OXException e) {
                if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) continue;
                throw e;
            }
        }
        return retval;
    }

    public final List<FolderObject> getFolderObjects(Collection<Integer> folderIDs) throws OXException {
        int size = folderIDs.size();
        ArrayList<FolderObject> retval = new ArrayList<FolderObject>(size);
        Iterator<Integer> iter = folderIDs.iterator();
        for (int i = 0; i < size; ++i) {
            try {
                retval.add(this.getFolderObject(iter.next()));
                continue;
            }
            catch (OXException e) {
                if (OXFolderExceptionCode.NOT_EXISTS.equals(e)) continue;
                throw e;
            }
        }
        return retval;
    }

    public final int getFolderType(int folderId, int userId) throws OXException {
        return this.getFolderObject(folderId).getType(userId);
    }

    public final int getFolderType(int folderId) throws OXException {
        return this.getFolderObject(folderId).getType();
    }

    public final int getFolderModule(int folderId) throws OXException {
        return this.getFolderObject(folderId).getModule();
    }

    public final int getFolderOwner(int folderId) throws OXException {
        return this.getFolderObject(folderId).getCreatedBy();
    }

    public final boolean isFolderShared(int folderId, int userId) throws OXException {
        return this.getFolderType(folderId, userId) == 3;
    }

    public final boolean isDefaultFolder(int folderId) throws OXException {
        return this.getFolderObject(folderId).isDefaultFolder();
    }

    public String getFolderName(int folderId) throws OXException {
        return this.getFolderObject(folderId).getFolderName();
    }

    public int getParentFolderID(int folderId) throws OXException {
        return this.getFolderObject(folderId).getParentFolderID();
    }

    public Date getFolderLastModified(int folderId) throws OXException {
        return this.getFolderObject(folderId).getLastModified();
    }

    public final EffectivePermission getFolderPermission(int folderId, int userId, UserConfiguration userConfig) throws OXException {
        try {
            FolderObject fo = this.getFolderObject(folderId);
            return fo.getEffectiveUserPermission(userId, userConfig, this.readCon);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final FolderObject getDefaultFolder(int userId, int module) throws OXException {
        try {
            int folderId = OXFolderSQL.getUserDefaultFolder(userId, module, this.readCon, this.ctx);
            if (folderId != -1) return this.getFolderObject(folderId);
            if (8 != module) {
                throw OXFolderExceptionCode.NO_DEFAULT_FOLDER_FOUND.create(OXFolderUtility.folderModule2String(module), OXFolderUtility.getUserName(userId, this.ctx), this.ctx.getContextId());
            }
            Connection wc = DBPool.pickupWriteable(this.ctx);
            try {
                wc.setAutoCommit(false);
                String displayName = UserStorage.getStorageUser(userId, this.ctx).getDisplayName();
                int fuid = new OXFolderAdminHelper().addUserToInfoStore(userId, displayName, this.ctx.getContextId(), wc);
                wc.commit();
                FolderObject folderObject = this.getFolderObject(fuid);
                return folderObject;
            }
            catch (SQLException e) {
                DBUtils.rollback(wc);
                throw e;
            }
            catch (Exception e) {
                DBUtils.rollback(wc);
                throw e;
            }
            finally {
                DBUtils.autocommit(wc);
                DBPool.closeWriterSilent(this.ctx, wc);
            }
        }
        catch (OXException e) {
            throw e;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Exception e) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, this.ctx.getContextId());
        }
    }

    public final boolean canDeleteAllObjectsInFolder(FolderObject fo, Session session, Context ctx) throws OXException {
        int userId = session.getUserId();
        UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(userId, ctx);
        try {
            EffectivePermission oclPerm = fo.getEffectiveUserPermission(userId, userConfig, this.readCon);
            if (!((OCLPermission)oclPerm).isFolderVisible()) {
                return false;
            }
            if (((OCLPermission)oclPerm).canDeleteAllObjects()) {
                return true;
            }
            if (((OCLPermission)oclPerm).canDeleteOwnObjects()) {
                return !this.containsForeignObjects(fo, session, ctx);
            }
            return this.isEmpty(fo, session, ctx);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean containsForeignObjects(FolderObject fo, Session session, Context ctx) throws OXException {
        try {
            int userId = session.getUserId();
            int module = fo.getModule();
            if (module == 1) {
                Tasks tasks2 = Tasks.getInstance();
                if (null != this.readCon) return tasks2.containsNotSelfCreatedTasks(session, this.readCon, fo.getObjectID());
                Connection rc = null;
                try {
                    rc = DBPool.pickup(ctx);
                    boolean bl = tasks2.containsNotSelfCreatedTasks(session, rc, fo.getObjectID());
                    return bl;
                }
                finally {
                    if (null != rc) {
                        DBPool.closeReaderSilent(ctx, rc);
                    }
                }
            }
            if (module == 2) {
                AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
                if (this.readCon != null) return calSql.checkIfFolderContainsForeignObjects(userId, fo.getObjectID(), this.readCon);
                return calSql.checkIfFolderContainsForeignObjects(userId, fo.getObjectID());
            }
            if (module == 3) {
                if (this.readCon != null) return Contacts.containsForeignObjectInFolder(fo.getObjectID(), userId, session, this.readCon);
                return Contacts.containsForeignObjectInFolder(fo.getObjectID(), userId, session);
            }
            if (module == 6) {
                return false;
            }
            if (module != 8) {
                throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(module), ctx.getContextId());
            }
            InfostoreFacadeImpl db = new InfostoreFacadeImpl(this.readCon == null ? new DBPoolProvider() : new StaticDBPoolProvider(this.readCon));
            UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(userId, ctx);
            return db.hasFolderForeignObjects(fo.getObjectID(), ctx, UserStorage.getStorageUser(session.getUserId(), ctx), userConfig);
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }

    public final boolean isEmpty(FolderObject fo, Session session, Context ctx) throws OXException {
        try {
            int userId = session.getUserId();
            int module = fo.getModule();
            if (1 == module) {
                Tasks tasks2 = Tasks.getInstance();
                return this.readCon == null ? tasks2.isFolderEmpty(ctx, fo.getObjectID()) : tasks2.isFolderEmpty(ctx, this.readCon, fo.getObjectID());
            }
            if (2 == module) {
                AppointmentSQLInterface calSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
                return this.readCon == null ? calSql.isFolderEmpty(userId, fo.getObjectID()) : calSql.isFolderEmpty(userId, fo.getObjectID(), this.readCon);
            }
            if (3 == module) {
                return this.readCon == null ? !Contacts.containsAnyObjectInFolder(fo.getObjectID(), ctx) : !Contacts.containsAnyObjectInFolder(fo.getObjectID(), this.readCon, ctx);
            }
            if (6 == module) {
                return true;
            }
            if (8 == module) {
                InfostoreFacadeImpl db = new InfostoreFacadeImpl(this.readCon == null ? new DBPoolProvider() : new StaticDBPoolProvider(this.readCon));
                return db.isFolderEmpty(fo.getObjectID(), ctx);
            }
            throw OXFolderExceptionCode.UNKNOWN_MODULE.create(OXFolderUtility.folderModule2String(module), ctx.getContextId());
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Throwable t) {
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(t, ctx.getContextId());
        }
    }
}

