/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.file.internal.State;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.logging.Log;

public class LocalFileStorage
implements FileStorage {
    public static final int DEFAULT_FILES = 256;
    public static final int DEFAULT_DEPTH = 3;
    private static final int LOCK_TIMEOUT = 10000;
    private static final String STATEFILENAME = "state";
    private final transient int entries = 256;
    private final transient int depth = 3;
    private final File storage;
    private boolean alreadyInitialized;
    private static final int DEFAULT_BUFSIZE = 1024;
    private static final String LOCK_FILENAME = ".lock";
    private static final int RELOCK_TIME = 10;
    protected static final Set<String> SPECIAL_FILENAMES;
    private static final Log LOG;
    private static final Lock LOCK;
    private transient int nameLength = -1;

    public LocalFileStorage(URI uri) throws OXException {
        this.storage = new File(uri);
        this.alreadyInitialized = this.storage.exists();
    }

    protected LocalFileStorage() {
        this.storage = this.assignStorage();
    }

    private File assignStorage() {
        try {
            return File.createTempFile("test-storage", "tmp");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stateFileIsCorrect() throws OXException {
        this.lock(10000L);
        try {
            State state = this.loadState();
            Set<String> unusedEntries = this.getUnusedEntries();
            if (this.exists(state.getNextEntry())) {
                boolean bl = false;
                return bl;
            }
            if (state.hasUnused()) {
                for (String unused : unusedEntries) {
                    if (!this.exists(unused)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            String previousEntry = this.getPreviousEntry(state.getNextEntry());
            String[] tokens = previousEntry.split("/");
            int[] parts = new int[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                int val;
                parts[i] = val = Integer.parseInt(tokens[i], 16);
            }
            int entryCount = parts[0];
            entryCount = (int)((double)entryCount * Math.pow(256.0, tokens.length - 1));
            for (int i = 1; i < tokens.length; ++i) {
                entryCount = (int)((double)entryCount + (double)parts[i] * Math.pow(256.0, tokens.length - 1 - i));
            }
            ++entryCount;
            while (state.hasUnused()) {
                unusedEntries.add(state.getUnused());
            }
            for (String entry : unusedEntries) {
                state.addUnused(entry);
            }
            int realEntries = this.getFileList().size() + unusedEntries.size();
            boolean bl = realEntries == entryCount;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    protected String getPreviousEntry(String identifier) throws OXException {
        int i;
        String[] tokens = identifier.split("/");
        int[] parts = new int[tokens.length];
        int sum = 0;
        for (i = 0; i < tokens.length; ++i) {
            try {
                int val;
                parts[i] = val = Integer.parseInt(tokens[i], 16);
                sum += val;
                continue;
            }
            catch (NumberFormatException n) {
                throw FileStorageCodes.NO_NUMBER.create(n, new Object[0]);
            }
        }
        if (sum == 0) {
            return null;
        }
        i = tokens.length - 1;
        boolean overflow = false;
        do {
            if (parts[i] == 0) {
                parts[i] = 255;
                overflow = true;
                --i;
                continue;
            }
            int n = i;
            parts[n] = parts[n] - 1;
            overflow = false;
        } while (overflow && i > -1);
        String maxChars = Integer.toHexString(255);
        int charCount = maxChars.length();
        String[] vals = new String[parts.length];
        for (int j = 0; j < parts.length; ++j) {
            vals[j] = Integer.toHexString(parts[j]);
            while (vals[j].length() < charCount) {
                vals[j] = "0" + vals[j];
            }
        }
        StringBuilder retval = new StringBuilder();
        for (int j = 0; j < vals.length; ++j) {
            retval.append('/');
            retval.append(vals[j]);
        }
        return retval.substring(1);
    }

    protected Set<String> getUnusedEntries() throws OXException {
        State state = this.loadState();
        TreeSet<String> unusedEntries = new TreeSet<String>();
        while (state.hasUnused()) {
            unusedEntries.add(state.getUnused());
        }
        return unusedEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String saveNewFile(InputStream input) throws OXException {
        this.initialize();
        String nextentry = null;
        State state = null;
        this.lock(10000L);
        try {
            state = this.loadState();
            while (nextentry == null && state.hasUnused()) {
                nextentry = state.getUnused();
                if (!this.exists(nextentry)) continue;
                nextentry = null;
            }
            if (nextentry == null) {
                String savenextentry;
                nextentry = state.getNextEntry();
                while (nextentry != null && this.exists(nextentry)) {
                    nextentry = this.computeNextEntry(nextentry);
                }
                if (nextentry == null) {
                    Set<String> unused = this.scanForUnusedEntries();
                    if (unused.isEmpty()) {
                        throw FileStorageCodes.STORE_FULL.create();
                    }
                    Iterator<String> iter = unused.iterator();
                    nextentry = iter.next();
                    while (iter.hasNext()) {
                        state.addUnused(iter.next());
                    }
                }
                if ((savenextentry = this.computeNextEntry(nextentry)) == null) {
                    state.setNextEntry(nextentry);
                } else {
                    state.setNextEntry(savenextentry);
                }
            }
            this.saveState(state);
        }
        finally {
            this.unlock();
        }
        try {
            this.save(nextentry, input);
        }
        catch (OXException ie) {
            this.delete(new String[]{nextentry});
            this.lock(10000L);
            try {
                state = this.loadState();
                state.addUnused(nextentry);
                this.saveState(state);
            }
            finally {
                this.unlock();
            }
            throw ie;
        }
        return nextentry;
    }

    @Override
    public InputStream getFile(String identifier) throws OXException {
        return this.load(identifier);
    }

    @Override
    public SortedSet<String> getFileList() {
        TreeSet<String> allIds = new TreeSet<String>();
        this.listRecursively(allIds, "", this.storage);
        return allIds;
    }

    protected void listRecursively(SortedSet<String> allIds, String prefix, File file) {
        if (prefix.length() != 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if (SPECIAL_FILENAMES.contains(file.getName())) {
            return;
        }
        if (file.isDirectory()) {
            for (File subfile : file.listFiles()) {
                if (file.equals(this.storage)) {
                    this.listRecursively(allIds, "", subfile);
                    continue;
                }
                this.listRecursively(allIds, prefix + file.getName(), subfile);
            }
        } else {
            allIds.add(prefix + file.getName());
        }
    }

    @Override
    public long getFileSize(String name) throws OXException {
        File dataFile = new File(this.storage, name);
        if (!dataFile.exists()) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(dataFile.getAbsoluteFile().getAbsolutePath());
        }
        return dataFile.length();
    }

    @Override
    public String getMimeType(String name) {
        MimetypesFileTypeMap map = new MimetypesFileTypeMap();
        return map.getContentType(new File(this.storage, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(String identifier) throws OXException {
        boolean retval = this.delete(new String[]{identifier}).isEmpty();
        if (retval) {
            this.lock(10000L);
            try {
                State state = this.loadState();
                state.addUnused(identifier);
                this.saveState(state);
            }
            finally {
                this.unlock();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> deleteFiles(String[] identifiers) throws OXException {
        Set<String> notDeleted = this.delete(identifiers);
        if (notDeleted.size() < identifiers.length) {
            this.lock(10000L);
            try {
                State state = this.loadState();
                for (String identifier : identifiers) {
                    if (notDeleted.contains(identifier)) continue;
                    state.addUnused(identifier);
                }
                this.saveState(state);
            }
            finally {
                this.unlock();
            }
        }
        return notDeleted;
    }

    @Override
    public void remove() throws OXException {
        if (!this.alreadyInitialized || !this.storage.exists()) {
            return;
        }
        this.lock(10000L);
        this.eliminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recreateStateFile() throws OXException {
        this.lock(10000L);
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Repairing.");
            }
            State state = this.repairState();
            this.saveState(state);
        }
        finally {
            this.unlock();
        }
    }

    protected String computeNextEntry(String identifier) throws OXException {
        int[] entry = new int[3];
        StringTokenizer tokenizer = new StringTokenizer(identifier, File.separator);
        if (tokenizer.countTokens() != 3) {
            throw FileStorageCodes.DEPTH_MISMATCH.create();
        }
        int actualDepth = 0;
        while (tokenizer.hasMoreTokens()) {
            try {
                entry[actualDepth++] = Integer.parseInt(tokenizer.nextToken(), 16);
            }
            catch (NumberFormatException n) {
                throw FileStorageCodes.NO_NUMBER.create(n, new Object[0]);
            }
        }
        boolean uebertrag = true;
        for (actualDepth = 2; actualDepth >= 0 && uebertrag; --actualDepth) {
            int n = actualDepth;
            entry[n] = entry[n] + 1;
            if (entry[actualDepth] == 256) {
                if (actualDepth == 0) {
                    return null;
                }
                entry[actualDepth] = 0;
                continue;
            }
            uebertrag = false;
        }
        StringBuffer retval = new StringBuffer();
        for (actualDepth = 0; actualDepth < 3; ++actualDepth) {
            retval.append(this.formatName(entry[actualDepth]));
            retval.append(File.separator);
        }
        retval.delete(retval.length() - 1, retval.length());
        return retval.toString();
    }

    protected Set<String> scanForUnusedEntries() throws OXException {
        HashSet<String> unused = new HashSet<String>();
        String entry = this.computeFirstEntry();
        while (entry != null) {
            if (!this.exists(entry)) {
                unused.add(entry);
            }
            entry = this.computeNextEntry(entry);
        }
        return unused;
    }

    protected String computeFirstEntry() {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            retval.append(this.formatName(0));
            retval.append(File.separator);
        }
        retval.delete(retval.length() - 1, retval.length());
        return retval.toString();
    }

    protected boolean exists(String name) {
        return new File(this.storage, name).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String name, InputStream input) throws OXException {
        File file = new File(this.storage, name);
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            try {
                LOCK.lock();
                if (!parentDir.exists() && !this.mkdirs(parentDir)) {
                    throw FileStorageCodes.CREATE_DIR_FAILED.create(parentDir.getAbsolutePath());
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int len = input.read(buf);
            while (len > 0) {
                fos.write(buf, 0, len);
                len = input.read(buf);
            }
        }
        catch (IOException e) {
            try {
                throw FileStorageCodes.IOERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(fos);
                throw throwable;
            }
        }
        Streams.close((Closeable)fos);
    }

    protected void lock(long timeout) throws OXException {
        File lock = new File(this.storage, LOCK_FILENAME);
        long maxLifeTime = 100L * timeout;
        long lastModified = lock.lastModified();
        if (lastModified > 0L && lastModified + maxLifeTime < System.currentTimeMillis()) {
            this.unlock();
            LOG.error((Object)("Deleting a very old stale lock file here " + lock.getAbsolutePath() + ". Assuming it has not been removed by a crashed/restarted application."));
        }
        long failTime = System.currentTimeMillis() + timeout;
        boolean created = false;
        IOException ioe = null;
        do {
            block7: {
                try {
                    created = lock.createNewFile();
                }
                catch (IOException e) {
                    ioe = e;
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (created) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } while (!created && System.currentTimeMillis() < failTime);
        if (!created) {
            throw null == ioe ? FileStorageCodes.LOCK.create(lock.getAbsolutePath()) : FileStorageCodes.LOCK.create(ioe, lock.getAbsolutePath());
        }
    }

    protected void unlock() throws OXException {
        File lock = new File(this.storage, LOCK_FILENAME);
        if (!lock.delete() && lock.exists()) {
            LOG.error((Object)("Couldn't delete lock file: " + lock.getAbsolutePath() + ". This will probably leave a stale lockfile behind rendering this filestorage unusable, delete in manually."));
            throw FileStorageCodes.UNLOCK.create();
        }
    }

    protected State loadState() throws OXException {
        try {
            return new State(this.load(STATEFILENAME));
        }
        catch (OXException e) {
            this.delete(new String[]{STATEFILENAME});
            throw e;
        }
    }

    protected void saveState(State state) throws OXException {
        try {
            this.save(STATEFILENAME, state.saveState());
        }
        catch (OXException e) {
            this.delete(new String[]{STATEFILENAME});
            throw e;
        }
    }

    protected InputStream load(String name) throws OXException {
        File dataFile = new File(this.storage, name);
        if (!dataFile.exists()) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(dataFile.getAbsoluteFile().getAbsolutePath());
        }
        try {
            return new FileInputStream(new File(this.storage, name));
        }
        catch (FileNotFoundException e) {
            throw FileStorageCodes.IOERROR.create(e, e.getMessage());
        }
    }

    protected String formatName(int entry) {
        if (this.nameLength == -1) {
            this.nameLength = Integer.toHexString(255).length();
        }
        StringBuffer stbf = new StringBuffer(Integer.toHexString(entry));
        while (stbf.length() < this.nameLength) {
            stbf.insert(0, "0");
        }
        return stbf.toString();
    }

    protected void eliminate() throws OXException {
        if (this.storage.exists() && !LocalFileStorage.delete(this.storage)) {
            throw FileStorageCodes.NOT_ELIMINATED.create();
        }
    }

    protected static final boolean delete(File file) {
        boolean retval = true;
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                retval &= LocalFileStorage.delete(sub);
            }
            retval &= file.delete();
        } else {
            retval = file.delete();
        }
        return retval;
    }

    protected Set<String> delete(String[] names) {
        HashSet<String> notDeleted = new HashSet<String>();
        for (String name : names) {
            if (new File(this.storage, name).delete()) continue;
            notDeleted.add(name);
        }
        return notDeleted;
    }

    protected State repairState() throws OXException {
        String nextentry = this.computeFirstEntry();
        State state = new State(3, 256, nextentry);
        String previousentry = null;
        while (nextentry != null && this.exists(nextentry)) {
            previousentry = nextentry;
            nextentry = this.computeNextEntry(nextentry);
        }
        if (nextentry == null) {
            state.setNextEntry(previousentry);
        } else {
            state.setNextEntry(nextentry);
        }
        return state;
    }

    private boolean mkdirs(File directory) {
        if (directory.exists()) {
            return true;
        }
        File parent = directory.getParentFile();
        if (!this.mkdirs(parent)) {
            return false;
        }
        return directory.mkdir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws OXException {
        if (this.alreadyInitialized) {
            return;
        }
        try {
            LOCK.lock();
            if (!this.storage.exists() && !this.mkdirs(this.storage)) {
                throw FileStorageCodes.CREATE_DIR_FAILED.create(this.storage.getAbsolutePath());
            }
        }
        finally {
            LOCK.unlock();
        }
        this.lock(10000L);
        try {
            if (!this.exists(STATEFILENAME)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Repairing.");
                }
                State state = this.repairState();
                this.saveState(state);
            }
        }
        finally {
            this.unlock();
        }
        this.alreadyInitialized = true;
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add(LOCK_FILENAME);
        tmp.add(STATEFILENAME);
        SPECIAL_FILENAMES = Collections.unmodifiableSet(tmp);
        LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(LocalFileStorage.class));
        LOCK = new ReentrantLock();
    }
}

