/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.file.external.FileStorageFactory;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import java.util.SortedSet;

public class FileStorage {
    private static volatile FileStorageFactory fss;
    private com.openexchange.tools.file.external.FileStorage fs;

    protected FileStorage() {
    }

    public FileStorage(com.openexchange.tools.file.external.FileStorage fs) {
        this.fs = fs;
    }

    public static final FileStorage getInstance(URI uri) throws OXException {
        if (fss == null) {
            throw FileStorageCodes.INSTANTIATIONERROR.create("No file storage starter registered.");
        }
        return new FileStorage(fss.getFileStorage(uri));
    }

    public static void setFileStorageStarter(FileStorageFactory fss) {
        FileStorage.fss = fss;
    }

    public boolean deleteFile(String identifier) throws OXException {
        return this.fs.deleteFile(identifier);
    }

    public Set<String> deleteFiles(String[] identifiers) throws OXException {
        return this.fs.deleteFiles(identifiers);
    }

    public InputStream getFile(String name) throws OXException {
        return this.fs.getFile(name);
    }

    public SortedSet<String> getFileList() throws OXException {
        return this.fs.getFileList();
    }

    public long getFileSize(String name) throws OXException {
        return this.fs.getFileSize(name);
    }

    public String getMimeType(String name) throws OXException {
        return this.fs.getMimeType(name);
    }

    public void recreateStateFile() throws OXException {
        this.fs.recreateStateFile();
    }

    public void remove() throws OXException {
        this.fs.remove();
    }

    public String saveNewFile(InputStream file) throws OXException {
        return this.fs.saveNewFile(file);
    }

    public void close() {
        this.fs = null;
    }
}

